Imports System.Collections

Namespace commerce
    ' 
    ' Implementation of ICurrencyConversion for testing.
    ' Uses hardwired conversion rates rather than external data
    ' sources.
    ' 
    Public Class HardwiredCurrencyConversion
        Implements ICurrencyConversion

        '
        ' Container for hardwired conversions.
        '
        Private conversionTable As Hashtable = New Hashtable(80)

        '
        ' Constructor
        '
        Public Sub New()
            Dim zero As Decimal = 0D

            ' United Arab Emirates Dirham
            conversionTable.Add("AED", zero)

            ' Afghani
            conversionTable.Add("AFA", zero)

            ' Netherlands Antilles Guilder
            conversionTable.Add("ANG", zero)

            ' Australian Dollar
            conversionTable.Add("AUD", 1.93817D)

            ' Aruban Guilder
            conversionTable.Add("AWG", zero)

            ' Barbados Dollar
            conversionTable.Add("BBD", 1.99D)

            ' Bermudian Dollar
            conversionTable.Add("BMD", 1D)

            ' Brunei Dollar
            conversionTable.Add("BND", zero)

            ' Boliviano
            conversionTable.Add("BOB", zero)

            ' Real
            conversionTable.Add("BRL", 2.424D)

            ' Bahamian Dollar
            conversionTable.Add("BSD", 1D)

            ' Belize Dollar
            conversionTable.Add("BZD", zero)

            ' Canadian Dollar
            conversionTable.Add("CAD", 1.6118D)

            ' Swiss Franc
            conversionTable.Add("CHF", 1.71283D)

            ' Chilean Peso
            conversionTable.Add("CLP", 675.3D)

            ' Colombian Peso
            conversionTable.Add("COP", zero)

            ' Costa Rican Coln
            conversionTable.Add("CRC", zero)

            ' Sucre
            conversionTable.Add("ECS", zero)

            ' Egyptian Pound
            conversionTable.Add("EGP", 4.6125D)

            ' Euro
            conversionTable.Add("EUR", 1.16386D)

            ' Pound Sterling
            conversionTable.Add("GBP", 0.710958D)

            ' Hong Kong Dollar
            conversionTable.Add("HKD", 7.79927D)

            ' Shekel
            conversionTable.Add("ILS", 4.61823D)

            ' Jamaican Dollar
            conversionTable.Add("JMD", 47.15D)

            ' Yen
            conversionTable.Add("JPY", 133.346D)

            ' Republic of Korean Won
            conversionTable.Add("KRW", zero)

            ' Cayman Islands Dollar
            conversionTable.Add("KYD", 1D)

            ' Mexican New Peso
            conversionTable.Add("MXN", 9.14072D)

            ' New Zealand Dollar
            conversionTable.Add("NZD", zero)

            ' Balboa
            conversionTable.Add("PAB", zero)

            ' Philippines Peso
            conversionTable.Add("PHP", 51.1998D)

            ' New Zloty
            conversionTable.Add("PLN", 4.11073D)

            ' Guarani
            conversionTable.Add("PYG", zero)

            ' Qatari Riyal
            conversionTable.Add("QAR", zero)

            ' Singapore Dollar
            conversionTable.Add("SGD", zero)

            ' St Helena Pound
            conversionTable.Add("SHP", zero)

            ' Baht
            conversionTable.Add("THB", 44.0742D)

            ' Turkish Lira
            conversionTable.Add("TRL", 1303401.26D)

            ' Trinidad and Tobago Dollar
            conversionTable.Add("TTD", zero)

            ' Taiwan Dollar
            conversionTable.Add("TWD", 34.92D)

            ' United States Dollar
            conversionTable.Add("USD", zero)

            ' Uruguayan New Peso
            conversionTable.Add("UYU", zero)

            ' Uzbekistani Som
            conversionTable.Add("UZS", zero)

            ' Bolivar
            conversionTable.Add("VEB", zero)

            ' South Africa Rand
            conversionTable.Add("ZAR", 11.4986D)

            ' Zimbabwe Dollar
            conversionTable.Add("ZWD", zero)
        End Sub

        '
        ' Return the conversion factor for the given currency.  You 
        ' multiply an amount in the given currency by the number returned
        ' by this method to get an equivalent amount in U.S. Dollars.
        ' 
        ' Parameters:
        ' - currency
        '   A three letter ISO 4217 currency abbreviation.
        '
        ' - time
        '   The effective time of the requested conversion factor.  This
        ' allows for queries about historical rates or forcasted rates.
        '
        Public Function _
            ConverstionToUSDollars(ByVal currency As String, _
                                ByVal time As DateTime) As Decimal _
                Implements ICurrencyConversion.ConverstionToUSDollars
            Return DirectCast(conversionTable(currency), Decimal)
        End Function
    End Class
End Namespace
