Imports Commerce.commerce

Namespace browser
    '
    ' This class is the data model for displaying the description of a
    ' framework object.
    '
    Public Class DescriptionModel
        '
        ' The browser this object as the data model for an object's 
        ' description.  The object that this object is a description for
        ' is the object referred to by the myObject variable.
        '
        ' The myObject variable is set by this object's constructor.  If
        ' the object passed to the constructor does not implement the
        ' IDescription interface, then myObject will be Nothing.
        ' 
        Private myObject As IDescription

        ' 
        ' Constructor
        ' 
        ' parameters:
        ' - theObject
        '     The object that this object will provide a description for.
        '
        Public Sub New(ByVal theObject As Object)
            myObject = DirectCast(theObject, IDescription)
        End Sub

        '
        ' Return the description of the object being browsed.
        '
        Public Function GetDescription() As String
            If (myObject Is Nothing) Then
                Return "No Description available"
            End If
            Return myObject.Description
        End Function

    End Class
End Namespace

