Namespace commerce
    '
    ' Classes/structs that encapsulate a quantity implement this 
    ' interface.
    '
    Public Interface IQuantity
        Inherits IComparable

        '
        ' The amount of the specified measurement unit this quantity
        ' represents.
        '
        ReadOnly Property Amount() As Decimal

        '
        ' The unit of measurment for this quantity.
        '
        ReadOnly Property Unit() As MeasurementUnit

        '
        ' Return a quantity that is the sum of this Quantity and the given
        ' Quantity.
        '
        ' Parameters:
        ' - that
        '   The quantity to add to this one.
        '
        ' Exceptions:
        ' - ConversionException
        '   If this quantity and the given quantity have different units 
        '   of measurement.
        '
        Function add(ByVal that As IQuantity) As IQuantity

        '
        ' Return a Quantity that is the difference between this Quantity
        ' and the given Quantity.
        '
        ' Parameters:
        ' - that
        '   The Quantity to subtact from this one.
        '
        ' Exceptions:
        ' - ConversionException
        '   If this quantity and the given quantity have different units 
        '   of measurement.
        '
        Function subtract(ByVal that As IQuantity) As IQuantity

        '
        ' Multiply this quantity by the given value.
        '
        ' - x
        '   The multiplier.
        ' Returns the product.
        '
        Function multiply(ByVal x As Integer) As IQuantity

        '
        ' Multiply this quantity by the given value.
        '
        ' - x
        '   The multiplier.
        ' Returns the product.
        '
        Function multiply(ByVal x As Decimal) As IQuantity

        '
        ' Multiply this quantity by the given value.
        '
        ' - x
        '   The multiplier.
        ' Returns the product.
        '
        Function multiply(ByVal x As Double) As IQuantity

        '
        ' Divide this quantity by the given value.
        '
        ' Parameters:
        ' - x
        '   The divisor.
        '
        ' Returns the quotient.
        '
        Function divide(ByVal x As Decimal) As IQuantity

        '
        ' Divide this quantity by the given value.
        '
        ' Parameters:
        ' - x
        '   The divisor.
        '
        ' Returns the quotient.
        '
        Function divide(ByVal x As Integer) As IQuantity

        '
        ' Divide this quantity by the given value.
        '
        ' Parameters:
        ' - x
        '   The divisor.
        '
        ' Returns the quotient.
        '
        Function divide(ByVal x As Double) As IQuantity

        ' 
        ' Return true if the amount in this quantity is zero.
        ' 
        Function isZero() As Boolean
    End Interface
End Namespace