Option Explicit On 
Option Strict On


Module AllAboutObjects
    Public Sub Main()

        Dim objPerson1 As New Person()
        Dim objPerson2 As New Person()
        Dim objPerson3 As New Person()
        Dim Val1, Val2, Val3 As Integer

        Val1 = 234
        Val2 = 13
        Val3 = 500

        objPerson1.FirstName = "John"
        objPerson1.LastName = "Adams"
        objPerson2.FirstName = "Quincy"
        objPerson2.LastName = "Wallace"
        objPerson3.FirstName = "Arlene"
        objPerson3.LastName = "Ratuski"

        Dim slPeople As New SortedList()

        slPeople.Add(objPerson1, Val1)
        slPeople.Add(objPerson2, Val2)
        slPeople.Add(objPerson3, Val3)

        Dim objDE As DictionaryEntry

        For Each objDE In slPeople
            Console.WriteLine("{0} {1}", _
                CType(objDE.Key, Person).DisplayName, _
                CType(objDE.Value, Integer))
        Next

        Console.ReadLine()
    End Sub
End Module




Public Class Person
    Implements IComparable
    Private m_sName As String
    Private m_sFirstName As String
    Private m_sLastName As String

    Public ReadOnly Property DisplayName() As String
        Get
            Return String.Format("{0} {1}", m_sFirstName, m_sLastName)
        End Get
    End Property

    Public Property FirstName() As String
        Get
            Return m_sFirstName
        End Get
        Set(ByVal Value As String)
            m_sFirstName = Value
        End Set
    End Property

    Public Property LastName() As String
        Get
            Return m_sLastName
        End Get
        Set(ByVal Value As String)
            m_sLastName = Value
        End Set
    End Property


    Public Function CompareTo(ByVal obj As Object) As Integer _
        Implements System.IComparable.CompareTo
        'Porwnaj ten egzemplarz z obj, zwr liczb
        'mniejsz od zera jeli me < obj, 0 jeli
        'obj = me, wiksz ni zero jeli me > obj
        Dim objOtherPerson As Person
        objOtherPerson = CType(obj, Person)

        If objOtherPerson.LastName > Me.LastName Then
            Return -1
        ElseIf objOtherPerson.LastName < Me.LastName Then
            Return 1
        Else
            If objOtherPerson.FirstName > Me.FirstName Then
                Return -1
            ElseIf objOtherPerson.FirstName < Me.FirstName Then
                Return 1
            Else
                Return 0
            End If
        End If


    End Function
End Class
