Imports System
Public Class frmLittleTextEditor
    Inherits System.Windows.Forms.Form
    Private sCurrentFile As String

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub
    Friend WithEvents rtfContents As System.Windows.Forms.RichTextBox
    Friend WithEvents Panel1 As System.Windows.Forms.Panel
    Friend WithEvents btnOpen As System.Windows.Forms.Button
    Friend WithEvents btnSave As System.Windows.Forms.Button
    Friend WithEvents btnFont As System.Windows.Forms.Button
    Friend WithEvents btnColor As System.Windows.Forms.Button
    Friend WithEvents dlgColor As System.Windows.Forms.ColorDialog
    Friend WithEvents dlgSave As System.Windows.Forms.SaveFileDialog
    Friend WithEvents dlgOpen As System.Windows.Forms.OpenFileDialog
    Friend WithEvents dlgFont As System.Windows.Forms.FontDialog

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.Container

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.btnOpen = New System.Windows.Forms.Button()
        Me.dlgColor = New System.Windows.Forms.ColorDialog()
        Me.dlgFont = New System.Windows.Forms.FontDialog()
        Me.btnFont = New System.Windows.Forms.Button()
        Me.Panel1 = New System.Windows.Forms.Panel()
        Me.btnColor = New System.Windows.Forms.Button()
        Me.btnSave = New System.Windows.Forms.Button()
        Me.dlgOpen = New System.Windows.Forms.OpenFileDialog()
        Me.dlgSave = New System.Windows.Forms.SaveFileDialog()
        Me.rtfContents = New System.Windows.Forms.RichTextBox()
        Me.Panel1.SuspendLayout()
        Me.SuspendLayout()
        '
        'btnOpen
        '
        Me.btnOpen.Location = New System.Drawing.Point(8, 8)
        Me.btnOpen.Name = "btnOpen"
        Me.btnOpen.TabIndex = 0
        Me.btnOpen.Text = "Otwrz"
        '
        'btnFont
        '
        Me.btnFont.Location = New System.Drawing.Point(8, 72)
        Me.btnFont.Name = "btnFont"
        Me.btnFont.TabIndex = 2
        Me.btnFont.Text = "Czcionka..."
        '
        'Panel1
        '
        Me.Panel1.Controls.AddRange(New System.Windows.Forms.Control() {Me.btnColor, Me.btnFont, Me.btnSave, Me.btnOpen})
        Me.Panel1.Dock = System.Windows.Forms.DockStyle.Right
        Me.Panel1.Location = New System.Drawing.Point(352, 0)
        Me.Panel1.Name = "Panel1"
        Me.Panel1.Size = New System.Drawing.Size(88, 317)
        Me.Panel1.TabIndex = 1
        '
        'btnColor
        '
        Me.btnColor.Location = New System.Drawing.Point(8, 104)
        Me.btnColor.Name = "btnColor"
        Me.btnColor.TabIndex = 2
        Me.btnColor.Text = "Kolor..."
        '
        'btnSave
        '
        Me.btnSave.Location = New System.Drawing.Point(8, 40)
        Me.btnSave.Name = "btnSave"
        Me.btnSave.TabIndex = 1
        Me.btnSave.Text = "Zapisz"
        '
        'dlgSave
        '
        Me.dlgSave.FileName = "doc1"
        '
        'rtfContents
        '
        Me.rtfContents.Dock = System.Windows.Forms.DockStyle.Fill
        Me.rtfContents.Name = "rtfContents"
        Me.rtfContents.ScrollBars = System.Windows.Forms.RichTextBoxScrollBars.Vertical
        Me.rtfContents.Size = New System.Drawing.Size(352, 317)
        Me.rtfContents.TabIndex = 0
        Me.rtfContents.Text = ""
        '
        'frmLittleTextEditor
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(440, 317)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.rtfContents, Me.Panel1})
        Me.Name = "frmLittleTextEditor"
        Me.Text = "May edytor tekstu"
        Me.Panel1.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub btnFont_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnFont.Click
        dlgFont.Font = rtfContents.Font

        If dlgFont.ShowDialog() = DialogResult.OK Then
            rtfContents.Font = dlgFont.Font
        End If

    End Sub

  Private Sub btnOpen_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOpen.Click
    Dim sNewFile As String
    Dim trNewFile As System.IO.TextReader
        If MessageBox.Show("Nadpisa biec zawarto?", "Otwrz nowy plik", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) = DialogResult.Yes Then
            With dlgOpen
                .Filter = "Pliki tekstowe(*.txt)|*.txt"
                .AddExtension = True
                .CheckFileExists = True
                .CheckPathExists = True
                .InitialDirectory = IO.Path.GetDirectoryName(sCurrentFile)
                .Multiselect = False

                If .ShowDialog() = DialogResult.OK Then
                    sNewFile = .FileName
                    If IO.File.Exists(sNewFile) Then
                        trNewFile = New IO.StreamReader(sNewFile)
                        rtfContents.Text = trNewFile.ReadToEnd()
                        sCurrentFile = sNewFile
                    End If
                End If
            End With
        End If
  End Sub

  Private Sub btnColor_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnColor.Click
    dlgColor.Color = rtfContents.ForeColor

    If dlgColor.ShowDialog() = DialogResult.OK Then
      rtfContents.ForeColor = dlgColor.Color
    End If

  End Sub

  Private Sub btnSave_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSave.Click

    Dim sNewFileName As String
    Dim swOutput As IO.StreamWriter

    sNewFileName = sCurrentFile

        If MessageBox.Show("Zapisa plik pod inn nazw?", "Zapisz plik", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) = DialogResult.Yes Then
            With dlgSave
                .FileName = sCurrentFile
                .CheckFileExists = False
                .CheckPathExists = True
                .DefaultExt = "txt"
                .Filter = "Pliki tekstowe (*.txt)|*.txt"
                .AddExtension = True
                .InitialDirectory = IO.Path.GetDirectoryName(sNewFileName)
                .OverwritePrompt = True
                .CreatePrompt = False

                If .ShowDialog() = DialogResult.OK Then
                    sNewFileName = .FileName
                    swOutput = New IO.StreamWriter(sNewFileName)

                    swOutput.Write(rtfContents.Text)
                    swOutput.Close()
                    sCurrentFile = sNewFileName
                End If
            End With
        End If

  End Sub

    
End Class
