Imports System.IO
Public Class frmMain
    Inherits System.Windows.Forms.Form
    Private m_sFileName As String
    Friend WithEvents mnuPlikZapiszjako As System.Windows.Forms.MenuItem
    Private m_bDirty As Boolean
    Public Property FileName() As String
        Get
            Return m_sFileName
        End Get
        Set(ByVal Value As String)
            m_sFileName = Value
            Me.Text = "Notatka - " & m_sFileName
        End Set
    End Property
    Public Property Dirty() As Boolean
        Get
            Return m_bDirty
        End Get
        Set(ByVal Value As Boolean)
            m_bDirty = Value
            Me.Text = "Notatka - " & m_sFileName & "*"
        End Set
    End Property
    Public Sub NewFile()
        Me.TxtText.Text = ""
        Me.FileName = "Bez tytuu"
        Me.Dirty = False
    End Sub


#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub
    Friend WithEvents TxtText As System.Windows.Forms.TextBox
    Friend WithEvents mnuMain As System.Windows.Forms.MainMenu
    Friend WithEvents mnuPlik As System.Windows.Forms.MenuItem
    Friend WithEvents mnuPlikNowy As System.Windows.Forms.MenuItem
    Friend WithEvents mnuPlikOtwrz As System.Windows.Forms.MenuItem
    Friend WithEvents mnuPlikZapisz As System.Windows.Forms.MenuItem
        Friend WithEvents mnuPlikSeparator As System.Windows.Forms.MenuItem
    Friend WithEvents mnuPlikZakocz As System.Windows.Forms.MenuItem
    Friend WithEvents mnuEdycja As System.Windows.Forms.MenuItem
    Friend WithEvents mnuEdycjaWytnij As System.Windows.Forms.MenuItem
    Friend WithEvents mnuEdycjaKopiuj As System.Windows.Forms.MenuItem
    Friend WithEvents mnuEdycjaWklej As System.Windows.Forms.MenuItem
    Friend WithEvents mnuPomoc As System.Windows.Forms.MenuItem
    Friend WithEvents mnuPomocOprog As System.Windows.Forms.MenuItem
    Friend WithEvents dlgOtwrz As System.Windows.Forms.OpenFileDialog
    Friend WithEvents dlgZapisz As System.Windows.Forms.SaveFileDialog

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.Container

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.mnuPlikZakocz = New System.Windows.Forms.MenuItem()
        Me.dlgOtwrz = New System.Windows.Forms.OpenFileDialog()
        Me.mnuMain = New System.Windows.Forms.MainMenu()
        Me.mnuPlik = New System.Windows.Forms.MenuItem()
        Me.mnuPlikNowy = New System.Windows.Forms.MenuItem()
        Me.mnuPlikOtwrz = New System.Windows.Forms.MenuItem()
        Me.mnuPlikZapisz = New System.Windows.Forms.MenuItem()
        Me.mnuPlikZapiszjako = New System.Windows.Forms.MenuItem()
        Me.mnuPlikSeparator = New System.Windows.Forms.MenuItem()
        Me.mnuEdycja = New System.Windows.Forms.MenuItem()
        Me.mnuEdycjaWytnij = New System.Windows.Forms.MenuItem()
        Me.mnuEdycjaKopiuj = New System.Windows.Forms.MenuItem()
        Me.mnuEdycjaWklej = New System.Windows.Forms.MenuItem()
        Me.mnuPomoc = New System.Windows.Forms.MenuItem()
        Me.mnuPomocOprog = New System.Windows.Forms.MenuItem()
        Me.TxtText = New System.Windows.Forms.TextBox()
        Me.dlgZapisz = New System.Windows.Forms.SaveFileDialog()
        Me.SuspendLayout()
        '
        'mnuPlikZakocz
        '
        Me.mnuPlikZakocz.Index = 5
        Me.mnuPlikZakocz.Text = "Za&kocz"
        '
        'dlgOtwrz
        '
        Me.dlgOtwrz.Filter = "Pliki tekstowe|*.txt|Wszystkie pliki|*.*"
        '
        'mnuMain
        '
        Me.mnuMain.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuPlik, Me.mnuEdycja, Me.mnuPomoc})
        '
        'mnuPlik
        '
        Me.mnuPlik.Index = 0
        Me.mnuPlik.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuPlikNowy, Me.mnuPlikOtwrz, Me.mnuPlikZapisz, Me.mnuPlikZapiszjako, Me.mnuPlikSeparator, Me.mnuPlikZakocz})
        Me.mnuPlik.Text = "&Plik"
        '
        'mnuPlikNowy
        '
        Me.mnuPlikNowy.Index = 0
        Me.mnuPlikNowy.Shortcut = System.Windows.Forms.Shortcut.CtrlN
        Me.mnuPlikNowy.Text = "&Nowy"
        '
        'mnuPlikOtwrz
        '
        Me.mnuPlikOtwrz.Index = 1
        Me.mnuPlikOtwrz.Shortcut = System.Windows.Forms.Shortcut.CtrlO
        Me.mnuPlikOtwrz.Text = "&Otwrz"
        '
        'mnuPlikZapisz
        '
        Me.mnuPlikZapisz.Index = 2
        Me.mnuPlikZapisz.Shortcut = System.Windows.Forms.Shortcut.CtrlS
        Me.mnuPlikZapisz.Text = "&Zapisz"
        '
        'mnuPlikZapiszjako
        '
        Me.mnuPlikZapiszjako.Index = 3
        Me.mnuPlikZapiszjako.Text = "Z&apisz jako"
        '
        'mnuPlikSeparator
        '
        Me.mnuPlikSeparator.Index = 4
        Me.mnuPlikSeparator.Text = "-"
        '
        'mnuEdycja
        '
        Me.mnuEdycja.Index = 1
        Me.mnuEdycja.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuEdycjaWytnij, Me.mnuEdycjaKopiuj, Me.mnuEdycjaWklej})
        Me.mnuEdycja.Text = "&Edycja"
        '
        'mnuEdycjaWytnij
        '
        Me.mnuEdycjaWytnij.Index = 0
        Me.mnuEdycjaWytnij.Shortcut = System.Windows.Forms.Shortcut.CtrlX
        Me.mnuEdycjaWytnij.Text = "&Wytnij"
        '
        'mnuEdycjaKopiuj
        '
        Me.mnuEdycjaKopiuj.Index = 1
        Me.mnuEdycjaKopiuj.Shortcut = System.Windows.Forms.Shortcut.CtrlC
        Me.mnuEdycjaKopiuj.Text = "&Kopiuj"
        '
        'mnuEdycjaWklej
        '
        Me.mnuEdycjaWklej.Index = 2
        Me.mnuEdycjaWklej.Shortcut = System.Windows.Forms.Shortcut.CtrlV
        Me.mnuEdycjaWklej.Text = "Wk&lej"
        '
        'mnuPomoc
        '
        Me.mnuPomoc.Index = 2
        Me.mnuPomoc.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuPomocOprog})
        Me.mnuPomoc.Text = "Pomo&c"
        '
        'mnuPomocOprog
        '
        Me.mnuPomocOprog.Index = 0
        Me.mnuPomocOprog.Text = "O program&ie"
        '
        'TxtText
        '
        Me.TxtText.Dock = System.Windows.Forms.DockStyle.Fill
        Me.TxtText.Multiline = True
        Me.TxtText.Name = "TxtText"
        Me.TxtText.ScrollBars = System.Windows.Forms.ScrollBars.Vertical
        Me.TxtText.Size = New System.Drawing.Size(292, 273)
        Me.TxtText.TabIndex = 0
        Me.TxtText.Text = ""
        '
        'dlgZapisz
        '
        Me.dlgZapisz.FileName = "Notatka1"
        Me.dlgZapisz.Filter = "Pliki tekstowe|*.txt|Wszystkie pliki|*.*"
        '
        'frmMain
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(292, 273)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.TxtText})
        Me.Menu = Me.mnuMain
        Me.Name = "frmMain"
        Me.Text = "Notatki"
        Me.ResumeLayout(False)

    End Sub

#End Region


    Private Sub mnuPomocOprog_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuPomocOprog.Click
        Dim sMessage As String
        sMessage = "Notatki  prosty edytor tekstu" & ControlChars.CrLf & _
       "Program pochodzi z ksiki Visual Basic .NET dla kadego" & ControlChars.CrLf & _
       "wydawnictwa Helion. Copyright 2002. "
        MessageBox.Show(sMessage, "Notatki", MessageBoxButtons.OK, _
        MessageBoxIcon.Information)

    End Sub

    Private Sub mnuPlikNowy_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuPlikNowy.Click
        If Me.Dirty = True Then
            If MessageBox.Show("Czy zapisa zmiany w pliku?", "Nowy Plik", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = DialogResult().Yes Then
                NewFile()
            End If
        Else
            NewFile()
        End If

    End Sub

    Private Sub mnuPlikOtwrz_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuPlikOtwrz.Click
        Dim oFile As FileStream
        Dim oReader As StreamReader
        If Me.dlgOtwrz.ShowDialog = DialogResult().OK Then
            'Prba otwarcia pliku
            Try
                Me.FileName = Me.dlgOtwrz.FileName
                oFile = File.OpenRead(Me.FileName)
                oReader = New StreamReader(oFile)
                Me.TxtText.Text = oReader.ReadToEnd
            Catch ex As Exception
                'Komunikat o wystpieniu bdu
                MessageBox.Show(ex.Message, "Error Opening File", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Finally
                'Zawsze trzeba zamyka strumienie i pliki
                oReader.Close()
                oFile.Close()
            End Try
        End If

    End Sub

    Private Sub mnuPlikZapisz_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuPlikZapisz.Click
        'bdziemy zapisywa tylko te pliki, ktre nie maj nazwy domylnej
        If Me.FileName <> "Bez tytuu" Then
            'Prba zapisu do pliku
            Dim oFile As FileStream
            Dim oWriter As StreamWriter

            Try
                oFile = File.OpenWrite(Me.FileName)
                'konwersja danych w tablicy na bloki bajtowe
                oWriter = New StreamWriter(oFile)

                'zapis do pliku
                oWriter.Write(Me.TxtText.Text)
                'plik nie by zmieniany
                Me.Dirty = False
            Catch ex As Exception
                'wywietlenie komunikatu o bdzie
                MessageBox.Show(ex.Message, "Bd zapisu", MessageBoxButtons.OK, MessageBoxIcon.Error)

            Finally
                'zawsze trzeba zamyka strumienie i pliki
                oWriter.Close()
                oFile.Close()
            End Try

        Else
            'pozwlmy uytkownikowi nada inn nazw pliku, zamiast Bez tytuu.
            mnuPlikZapiszjako_Click(sender, e)
        End If
    End Sub

    
    Private Sub mnuPlikZapiszjako_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuPlikZapiszjako.Click
        If Me.dlgZapisz.ShowDialog = DialogResult().OK Then
            'mona wpisa nazw pliku i zapisa go
            FileName() = Me.dlgZapisz.FileName
            'skorzystamy z kodu w procedurze obsugi polecenia Plik, Zapoisz
            mnuPlikZapisz_Click(sender, e)
        End If

    End Sub

    Private Sub mnuPlikZakocz_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuPlikZakocz.Click
        Me.Close()
    End Sub

    Private Sub mnuEdycjaWytnij_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuEdycjaWytnij.Click
        Clipboard.SetDataObject(Me.TxtText.SelectedText)
        Me.TxtText.SelectedText = ""

    End Sub

    Private Sub mnuEdycjaKopiuj_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuEdycjaKopiuj.Click
        Clipboard.SetDataObject(Me.TxtText.SelectedText)
    End Sub

    Private Sub mnuEdycjaWklej_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuEdycjaWklej.Click
        Me.TxtText.SelectedText = CType(Clipboard.GetDataObject.GetData(DataFormats.Text), String)
    End Sub

    Private Sub frmMain_Closing(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing
        If Me.Dirty = True Then
            If MessageBox.Show( _
                "Czy zachowa zmiany w pliku?", _
                "Nowy plik", _
                MessageBoxButtons.YesNo, _
                MessageBoxIcon.Question, _
                MessageBoxDefaultButton.Button2) = DialogResult.No Then
                e.Cancel = True

            End If

        End If
    End Sub

    Private Sub TxtText_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles TxtText.TextChanged
        Me.Dirty = True
    End Sub

    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        NewFile()
    End Sub
End Class
