Option Explicit On 
Option Strict On
Public Class Person
    Implements IComparable
    Private m_sName As String
    Private m_sFirstName As String
    Private m_sLastName As String

    Public ReadOnly Property DisplayName() As String
        Get
            Return String.Format("{0} {1}", m_sFirstName, m_sLastName)
        End Get
    End Property

    Public Property FirstName() As String
        Get
            Return m_sFirstName
        End Get
        Set(ByVal Value As String)
            m_sFirstName = Value
        End Set
    End Property

    Public Property LastName() As String
        Get
            Return m_sLastName
        End Get
        Set(ByVal Value As String)
            m_sLastName = Value
        End Set
    End Property

    Public Function LookUpInOutlook() As String
        Dim objOutlook As New Outlook.Application()
        Dim objSession As Outlook.NameSpace
        Dim objPerson As Outlook.Recipient
        Dim sEmailAddress As String

        objOutlook.Session.Logon(NewSession:=False)
        objSession = CType(objOutlook.Session, Outlook.NameSpace)
        objPerson = objSession.CreateRecipient(Me.DisplayName)
        Try
            sEmailAddress = String.Format("{0}:{1}", _
                objPerson.AddressEntry.Type, _
                objPerson.AddressEntry.Address)
            Return sEmailAddress
        Catch objException As Exception
            'Adresu nie odnaleziono
            Return ""
        End Try

    End Function

    Public Function CompareTo(ByVal obj As Object) As Integer _
        Implements System.IComparable.CompareTo
        'Porwnaj ten egzemparz z obj, zwr liczb
        'mniejsz od zera aby zaznaczy, e obj < me, 0 aby zaznaczy,e
        'obj = me, lub wikszej od zera aby zaznaczy, e obj > me
        Dim objOtherPerson As Person
        objOtherPerson = CType(obj, Person)

        If objOtherPerson.LastName > Me.LastName Then
            Return -1
        ElseIf objOtherPerson.LastName < Me.LastName Then
            Return 1
        Else
            If objOtherPerson.FirstName > Me.FirstName Then
                Return -1
            ElseIf objOtherPerson.FirstName < Me.FirstName Then
                Return 1
            Else
                Return 0
            End If
        End If


    End Function
End Class
