Public Class Mortgage
    'Bardzo prosty kalkulator inwestycyjny
    'Naley wprowadzi odpowiedznie wartoci do zmiennych AnnualInterestRate, NumberOfYears and Principal
    'A nastpnie otrzyma warto waciwoci PaymentAmount
    Private m_dblInterestRate As Double
    Private m_iDuration_Years As Integer
    Private m_curPrincipal As Decimal

    Public Property AnnualInterestRate() As Double
        Get
            Return m_dblInterestRate
        End Get
        Set(ByVal Value As Double)
            m_dblInterestRate = Value
        End Set
    End Property

    Public Property NumberOfYears() As Integer
        Get
            Return m_iDuration_Years
        End Get
        Set(ByVal Value As Integer)
            m_iDuration_Years = Value
        End Set
    End Property

    Public Property Principal() As Decimal
        Get
            Return m_curPrincipal
        End Get
        Set(ByVal Value As Decimal)
            m_curPrincipal = Value
        End Set
    End Property

    Public Overridable Function PaymentAmount() As Decimal
        Dim iNumPaymentsPerYear As Integer = 12
        Dim iPayments As Integer
        Dim dblFractionalInterestRate As Double
        Dim curPayment As Decimal

        iPayments = m_iDuration_Years * iNumPaymentsPerYear
        dblFractionalInterestRate = m_dblInterestRate / iNumPaymentsPerYear

        curPayment = m_curPrincipal * _
            ((1 - (1 + dblFractionalInterestRate)) _
             / (1 - ((1 + dblFractionalInterestRate) ^ iPayments)) _
             + dblFractionalInterestRate)

        Return curPayment
    End Function
End Class