Public Class AccelMortgage
    Inherits Mortgage
    Private m_iNumberOfPaymentsInYear As Integer = 12

    Public Property PaymentsInYear() As Integer
        Get
            Return m_iNumberOfPaymentsInYear
        End Get
        Set(ByVal Value As Integer)
            m_iNumberOfPaymentsInYear = Value
        End Set
    End Property

    Public Overrides Function PaymentAmount() As Decimal
        Dim iPayments As Integer
        Dim dblFractionalInterestRate As Double
        Dim curPayment As Decimal

        iPayments = Me.NumberOfYears * Me.PaymentsInYear
        dblFractionalInterestRate = Me.AnnualInterestRate / Me.PaymentsInYear

        curPayment = Me.Principal * _
            ((1 - (1 + dblFractionalInterestRate)) _
             / (1 - ((1 + dblFractionalInterestRate) ^ iPayments)) _
             + dblFractionalInterestRate)

        Return curPayment
    End Function
End Class
