Option Explicit On 
Option Strict On

Module Main
    Sub Main()
        Dim objPerson As New Person()
        objPerson.FirstName = "Duncan"
        objPerson.LastName = "Mackenzie"
        Console.WriteLine(objPerson.DisplayName())
    End Sub
End Module

Public Class Person
    Implements IComparable
    Implements IDebugInfo

    Private m_sName As String
    Private m_sFirstName As String
    Private m_sLastName As String

    Public Sub New()
        LoggingRoutine.LogMsgToFile _
            ("Started Up", "C:\test.txt", Me)
    End Sub

    Public ReadOnly Property DisplayName() As String
        Get
            LoggingRoutine.LogMsgToFile _
                (String.Format("wywoano DisplayName , {0} {1} wynik", _
                    m_sFirstName, m_sLastName), "C:\test.txt", Me)

            Return String.Format("{0} {1}", m_sFirstName, m_sLastName)
        End Get
    End Property

    Public Property FirstName() As String
        Get
            Return m_sFirstName
        End Get
        Set(ByVal Value As String)
            m_sFirstName = Value
        End Set
    End Property

    Public Property LastName() As String
        Get
            Return m_sLastName
        End Get
        Set(ByVal Value As String)
            m_sLastName = Value
        End Set
    End Property

    Public Function CompareTo(ByVal obj As Object) As Integer _
        Implements System.IComparable.CompareTo
        'Porwnaj ten egzemparz z obj, zwr liczb
        'mniejsz od zera aby zaznaczy, e obj < me, 0 aby zaznaczy,e
        'obj = me, lub wikszej od zera aby zaznaczy, e obj > me
        Dim objOtherPerson As Person
        objOtherPerson = CType(obj, Person)

        If objOtherPerson.LastName < Me.LastName Then
            Return -1
        ElseIf objOtherPerson.LastName > Me.LastName Then
            Return 1
        Else
            If objOtherPerson.FirstName < Me.FirstName Then
                Return -1
            ElseIf objOtherPerson.FirstName > Me.FirstName Then
                Return 1
            Else
                Return 0
            End If
        End If
    End Function

    Public ReadOnly Property Author() As String _
            Implements DebugInterface.IDebugInfo.Author
        Get
            Return "Duncan Mackenzie"
        End Get
    End Property

    Public ReadOnly Property ClassName() As String _
            Implements DebugInterface.IDebugInfo.ClassName
        Get
            Return "Person"
        End Get
    End Property

    Private ReadOnly Property Description() As String _
            Implements DebugInterface.IDebugInfo.Description
        Get
            Return "Osoba jest wyznaczona do reprezentacji" _
                & " klienta lub pracownika"
        End Get
    End Property

    Public ReadOnly Property SourceFile() As String _
            Implements DebugInterface.IDebugInfo.SourceFile
        Get
            Return "\\liquidsoap\bigproject\Source\Person.vb"
        End Get
    End Property
End Class
