Public Class frmMain
    Inherits System.Windows.Forms.Form
    Dim m_sngX As Single
    Dim m_sngY As Single

    Dim m_sngCPUY As Single
    Dim m_sngProcsY As Single
    Dim m_sngMemY As Single

    Dim penCPU As New System.Drawing.Pen(Color.Red)
    Dim penProcs As New System.Drawing.Pen(Color.Green)
    Dim penMem As New System.Drawing.Pen(Color.Blue)
    Dim penFore As New System.Drawing.Pen(SystemColors.WindowText)
    Dim penBack As New System.Drawing.Pen(SystemColors.Control)

    Dim MachineName As String = System.Windows.Forms.SystemInformation.ComputerName
    Const INCREMENT As Single = 1

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub
    Friend WithEvents pnlSweep As System.Windows.Forms.Panel
    Friend WithEvents cmdSweep As System.Windows.Forms.Button
    Friend WithEvents trkSpeed As System.Windows.Forms.TrackBar
    Friend WithEvents lblCPU As System.Windows.Forms.Label
    Friend WithEvents lblProc As System.Windows.Forms.Label
    Friend WithEvents lblMem As System.Windows.Forms.Label
    Friend WithEvents tmrClock As System.Windows.Forms.Timer
#Region "Declaration of Performance counters"
    Friend WithEvents prfCPU As System.Diagnostics.PerformanceCounter
    Friend WithEvents prfProcs As System.Diagnostics.PerformanceCounter
    Friend WithEvents prfMem As System.Diagnostics.PerformanceCounter
#End Region

    Friend WithEvents logApp As System.Diagnostics.EventLog
    Private components As System.ComponentModel.IContainer

    'Required by the Windows Form Designer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container()
        Me.prfMem = New System.Diagnostics.PerformanceCounter()
        Me.lblCPU = New System.Windows.Forms.Label()
        Me.logApp = New System.Diagnostics.EventLog()
        Me.lblProc = New System.Windows.Forms.Label()
        Me.cmdSweep = New System.Windows.Forms.Button()
        Me.trkSpeed = New System.Windows.Forms.TrackBar()
        Me.lblMem = New System.Windows.Forms.Label()
        Me.prfCPU = New System.Diagnostics.PerformanceCounter()
        Me.pnlSweep = New System.Windows.Forms.Panel()
        Me.tmrClock = New System.Windows.Forms.Timer(Me.components)
        Me.prfProcs = New System.Diagnostics.PerformanceCounter()
        CType(Me.prfMem, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.logApp, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.trkSpeed, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.prfCPU, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.prfProcs, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SuspendLayout()
        '
        'prfMem
        '
        Me.prfMem.CategoryName = "Memory"
        Me.prfMem.CounterName = "Committed Bytes"
        '
        'lblCPU
        '
        Me.lblCPU.AutoSize = True
        Me.lblCPU.ForeColor = System.Drawing.Color.Red
        Me.lblCPU.Location = New System.Drawing.Point(240, 248)
        Me.lblCPU.Name = "lblCPU"
        Me.lblCPU.Size = New System.Drawing.Size(31, 13)
        Me.lblCPU.TabIndex = 3
        Me.lblCPU.Text = "CPU:"
        '
        'logApp
        '
        Me.logApp.Log = "Application"
        Me.logApp.Source = "PerfLite"
        Me.logApp.SynchronizingObject = Me
        '
        'lblProc
        '
        Me.lblProc.AutoSize = True
        Me.lblProc.ForeColor = System.Drawing.Color.Green
        Me.lblProc.Location = New System.Drawing.Point(240, 272)
        Me.lblProc.Name = "lblProc"
        Me.lblProc.Size = New System.Drawing.Size(48, 13)
        Me.lblProc.TabIndex = 3
        Me.lblProc.Text = "Procesy:"
        '
        'cmdSweep
        '
        Me.cmdSweep.Location = New System.Drawing.Point(8, 248)
        Me.cmdSweep.Name = "cmdSweep"
        Me.cmdSweep.Size = New System.Drawing.Size(64, 24)
        Me.cmdSweep.TabIndex = 1
        Me.cmdSweep.Text = "&Start"
        '
        'trkSpeed
        '
        Me.trkSpeed.Location = New System.Drawing.Point(8, 280)
        Me.trkSpeed.Maximum = 20
        Me.trkSpeed.Minimum = 1
        Me.trkSpeed.Name = "trkSpeed"
        Me.trkSpeed.TabIndex = 2
        Me.trkSpeed.Value = 10
        '
        'lblMem
        '
        Me.lblMem.AutoSize = True
        Me.lblMem.ForeColor = System.Drawing.Color.Blue
        Me.lblMem.Location = New System.Drawing.Point(240, 296)
        Me.lblMem.Name = "lblMem"
        Me.lblMem.Size = New System.Drawing.Size(45, 13)
        Me.lblMem.TabIndex = 3
        Me.lblMem.Text = "Pami:"
        '
        'prfCPU
        '
        Me.prfCPU.CategoryName = "Processor"
        Me.prfCPU.CounterName = "% Processor Time"
        Me.prfCPU.InstanceName = "_Total"
        '
        'pnlSweep
        '
        Me.pnlSweep.Dock = System.Windows.Forms.DockStyle.Top
        Me.pnlSweep.Name = "pnlSweep"
        Me.pnlSweep.Size = New System.Drawing.Size(472, 240)
        Me.pnlSweep.TabIndex = 0
        '
        'tmrClock
        '
        Me.tmrClock.Interval = 1000
        '
        'prfProcs
        '
        Me.prfProcs.CategoryName = "System"
        Me.prfProcs.CounterName = "Processes"
        '
        'frmMain
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(472, 333)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.lblCPU, Me.trkSpeed, Me.cmdSweep, Me.pnlSweep, Me.lblProc, Me.lblMem})
        Me.Name = "frmMain"
        Me.Text = "PerfLite"
        CType(Me.prfMem, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.logApp, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.trkSpeed, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.prfCPU, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.prfProcs, System.ComponentModel.ISupportInitialize).EndInit()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub tmrClock_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tmrClock.Tick
        Dim sngCPU As Single = prfCPU.NextValue() / 100
        Dim sngProcs As Single = prfProcs.NextValue()
        Dim sngMem As Single = prfMem.NextValue / 1024
        'Rysowanie 
        DrawSweep(sngCPU, sngProcs, sngMem)
        'Uaktualnienie pl tekstowych
        lblCPU.Text = "CPU: " & sngCPU.ToString("p")
        lblProc.Text = "Procesy: " & sngProcs
        lblMem.Text = "Pami: " & sngMem.ToString("f0") & "KB"
    End Sub

    Private Sub DrawSweep(ByVal CPU As Single, _
        ByVal Processes As Single, _
        ByVal Memory As Single)
        Dim oGrafix As Graphics = pnlSweep.CreateGraphics()
        Dim sngHeight As Single = pnlSweep.Height
        'dla punktw
        Dim sngCPUY As Single
        Dim sngProcsY As Single
        Dim sngMemY As Single
        'wyczyszcenie poprzedniej linii
        oGrafix.DrawLine(penBack, m_sngX, 0, m_sngX, sngHeight)
        'rysowanie punktw danych
        sngCPUY = sngHeight - (CPU * sngHeight) - 1
        oGrafix.DrawLine(penCPU, _
            m_sngX - INCREMENT, m_sngCPUY, m_sngX, sngCPUY)
        m_sngCPUY = sngCPUY
        sngProcsY = sngHeight - Processes
        oGrafix.DrawLine(penProcs, _
            m_sngX - INCREMENT, m_sngProcsY, m_sngX, sngProcsY)
        m_sngProcsY = sngProcsY
        '10000 jest wartoci przystpn na moim komputerze
        'mona j zmieni, jeli linia dotyczca pamici
        'nie jest rysowana poprawnie
        sngMemY = sngHeight - (Memory / 10000)
        oGrafix.DrawLine(penMem, _
            m_sngX - INCREMENT, m_sngMemY, m_sngX, sngMemY)
        m_sngMemY = sngMemY
        'inkrementacja x
        m_sngX += INCREMENT
        If m_sngX > pnlSweep.Width Then
            'powrt do poczatku
            m_sngX = 0
            'wyczyszczenie powierzchni rysunkowej
            oGrafix.Clear(SystemColors.Control)
        End If
        'rysowanie nowej linii
        oGrafix.DrawLine(penFore, m_sngX, 0, m_sngX, sngHeight)
    End Sub

    Private Sub cmdSweep_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdSweep.Click
        'Wczanie i wyczanie zegara, oraz zmiana tekstu na przycisku (start/stop)
        If cmdSweep.Text = "&Start" Then
            cmdSweep.Text = "&Stop"
            tmrClock.Enabled = True
        Else
            cmdSweep.Text = "&Start"
            tmrClock.Enabled = False
        End If
    End Sub

    Private Sub trkSpeed_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles trkSpeed.Scroll
        Dim iValue As Integer
        iValue = CInt(trkSpeed.Value)
        'ustawienie interwau 
        tmrClock.Interval = iValue * 100 'ms
    End Sub
End Class
