Option Explicit On 
Option Strict On

Namespace VB21.Day03

    Module Payment

        Private dblAnnualInterest As Double = 0
        Private iYears As Integer = 0
        Private decLoanAmount As Decimal = 0
        Private decMonthlyDeposit As Decimal = 0

        Public Sub Main()
            Dim decResult As Decimal

            'pobranie wartosci pocztkowych
            GetInputValues()

            'obliczenia 
            decResult = CalculatePayment(decLoanAmount, dblAnnualInterest, iYears)

            'wywietlenie wynikw
            DisplayResults(decResult)

        End Sub

        Private Function CalculatePayment(ByVal LoanAmount As Decimal, ByVal AnnualInterest As Double, ByVal Years As Integer) As Decimal
            'podziel przez 1200 aby wyrazi w procentach/miesiac
            Dim decMonthlyInterest As Decimal = CDec(AnnualInterest / 1200)
            Dim iMonths As Integer = Years * 12
            Dim decTemp As Decimal
            Dim decReturn As Decimal


            'bdziemy potrzebowali wartoci tej zmiennej w kilku miejscach
            decTemp = CDec(((1 + decMonthlyInterest) ^ iMonths))
            decReturn = LoanAmount * (decMonthlyInterest * decTemp / (decTemp - 1))
            Return decReturn

        End Function

        Private Sub GetInputValues()
            Console.WriteLine()
            decLoanAmount = CDec(GetValue("Wysoko kredytu: "))
            dblAnnualInterest = CDbl(GetValue("Oprocentowanie roczne (np. dla 5% wpisz 5):"))
            iYears = CInt(GetValue("Liczba lat spaty: "))
            Console.WriteLine()
        End Sub

        Private Function GetValue(ByVal Prompt As String) As String

            Console.Write(Prompt)
            Return Console.ReadLine

        End Function

        Private Sub DisplayResults(ByVal Result As Decimal)
            Console.WriteLine()

            Console.WriteLine("Jali poyczysz {0:c}, ", decLoanAmount)
            Console.WriteLine("przy  {0}% oprocentowaniu", dblAnnualInterest)
            Console.WriteLine("na {0} lat", iYears)

            Console.WriteLine()
            Console.WriteLine("To miesicznie bdziesz spaca {0:c}", Result)
            Console.ReadLine()

        End Sub

    End Module

End Namespace
