Option Explicit On 
Option Strict On

Namespace VB21.Rozdzia03

    Module Invest

        Private dblAnnualInterest As Double = 0
        Private iYears As Integer = 0
        Private decStartingBalance As Decimal = 0
        Private decMonthlyDeposit As Decimal = 0

        Public Sub Main()
            Dim decResult As Decimal

            'pobranie wartoci rdowych
            GetInputValues()

            'obliczenia
            decResult = CalculateFV(dblAnnualInterest, iYears, decMonthlyDeposit, decStartingBalance)

            'wywietlenie wynikw
            DisplayResults(decResult)

        End Sub

        Private Function CalculateFV(ByVal AnnualInterest As Double, ByVal Years As Integer, ByVal MonthlyDeposit As Decimal, ByVal StartingBalance As Decimal) As Decimal
            'podziel przez 1200 aby uzyska warto procentow na miesic
            Dim decMonthlyInterest As Decimal = CDec(AnnualInterest / 1200)
            Dim iMonths As Integer = Years * 12
            Dim decTemp As Decimal
            Dim decReturn As Decimal

            'Wzr sucy do wyznaczenia przyszej wartoci
            'FV = MonthlyDeposit * (((1 + MonthlyInterest)^Months - 1 ) / MonthlyInterest ) 
            '   +  StartingBalance * ( 1 + MonthlyInterest )^Months

            'ta warto bdzie potrzebna w kilku miejscach programu
            decTemp = CDec((1 + decMonthlyInterest) ^ iMonths)
            decReturn = CDec(MonthlyDeposit * ((decTemp - 1) / decMonthlyInterest) + (StartingBalance * decTemp))

            Return decReturn

        End Function

        Private Sub GetInputValues()
            Console.WriteLine()
            decStartingBalance = CDec(GetValue("Kapita pocztkowy: "))
            dblAnnualInterest = CDbl(GetValue("Oprocentowanie w skali roku (np. dla 5%, wprowad 5): "))
            decMonthlyDeposit = CDec(GetValue("Miesiczna wpata: "))
            iYears = CInt(GetValue("Liczba lat inwestycji: "))
            Console.WriteLine()
        End Sub

        Private Function GetValue(ByVal Prompt As String) As String

            Console.Write(Prompt)
            Return Console.ReadLine

        End Function

        Private Sub DisplayResults(ByVal Result As Decimal)
            Console.WriteLine()

            Console.WriteLine("Kapita zaoycielski wynosi  {0:c}, ", decStartingBalance)
            Console.WriteLine(" wpata miesiczna  {0:c} ", decMonthlyDeposit)
            Console.WriteLine(" przez {0} lat", iYears)
            Console.WriteLine(" przy oprocentowaniu rocznym   {0}% ", dblAnnualInterest)

            Console.WriteLine()
            Console.WriteLine("Bilans inwestycji: : {0:c}", Result)
            Console.ReadLine()

        End Sub

    End Module

End Namespace
