Imports System
Imports System.Net
Imports System.IO
Imports System.Environment
'***************************************
'Naley skompilowa z
'        vbc /r:system.dll /t:exe Get.vb
'***************************************

Module GetURL

    Sub Main()
        Dim sOutput As String
        Dim sCommandLine() As String
        Dim sURL As String
        Try
            sCommandLine = GetCommandLineArgs()
            If sCommandLine.Length > 1 Then
                sURL = GetCommandLineArgs(1)
            Else
                sURL = "/?"
            End If

            If sURL.Trim <> "/?" Then
                Dim objNewRequest As WebRequest = HttpWebRequest.Create(sURL)
                Dim objResponse As WebResponse = objNewRequest.GetResponse
                Dim objStream As New StreamReader(objResponse.GetResponseStream())
                sOutput = objStream.ReadToEnd()
            Else
                sOutput = "   Usage: Get <URL>" _
                    & NewLine() _
                    & "      example: GET http://www.microsoft.com"
            End If
        Catch eUFE As UriFormatException
            sOutput = "Bd w URL: [" & sURL & "]" & NewLine() & eUFE.Message
        Catch eWEB As WebException
            sOutput = "Bad dania: " & NewLine() & eWEB.Message
        Catch e As Exception
            sOutput = e.ToString
        Finally
            Console.Write(sOutput)
        End Try

    End Sub

End Module
