Imports System
Imports System.Windows.Forms

Public Class OutlookMessageWatcher
    Private WithEvents objInboxItems As Outlook.Items
    Private objOutlook As Outlook.Application
    Public Event EmailArrived(ByVal From As String, _
        ByVal Subject As String, _
        ByVal Message As Outlook.MailItem)

    Public Sub New()
        objOutlook = New Outlook.Application()
        objOutlook.Session.Logon(NewSession:=False)
        objInboxItems = objOutlook.Session.GetDefaultFolder _
            (Outlook.OlDefaultFolders.olFolderInbox).Items
    End Sub

    Private Sub objInboxItems_ItemAdd(ByVal Item As Object) _
            Handles objInboxItems.ItemAdd
        Dim objNewMail As Outlook.MailItem
        Try
            objNewMail = CType(Item, Outlook.MailItem)
            RaiseEvent EmailArrived(objNewMail.SenderName, _
                objNewMail.Subject, _
                objNewMail)
        Catch objException As Exception
            MessageBox.Show(objException.Message)
        End Try
    End Sub
End Class
