Option Explicit On 
Option Strict On

Imports System
Imports System.IO

Public Class LoggingRoutine
    Const DefaultLogFile As String = "C:\LogFile.txt"
    Shared Sub LogMsgToFile(ByVal Message As String, _
            ByVal FileName As String, _
            ByVal Source As IDebugInfo)
        Dim objLogFile As StreamWriter
        If IO.File.Exists(FileName) Then
            objLogFile = File.AppendText(FileName)
        ElseIf Directory.Exists _
                (Path.GetDirectoryName(FileName)) Then
            objLogFile = File.CreateText(FileName)
        Else
            'bd, skorzystaj z pliku domylnego
            objLogFile = File.AppendText(DefaultLogFile)
        End If

        objLogFile.WriteLine("-----------------------------")
        objLogFile.WriteLine(Message)
        objLogFile.WriteLine("Od {0} ({1}) przez {2}", _
            Source.ClassName, Source.SourceFile, Source.Author)
        objLogFile.WriteLine("Opis: {0}", _
            Source.Description)
        objLogFile.WriteLine("-----------------------------")

        objLogFile.Flush()
        objLogFile.Close()
    End Sub
End Class
