Option Strict On
Option Explicit On 
Imports System.IO

Public Class frmFiler
    Inherits System.Windows.Forms.Form


#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub
    Friend WithEvents lblSource As System.Windows.Forms.Label
    Friend WithEvents lblDestination As System.Windows.Forms.Label
    Friend WithEvents btnCopy As System.Windows.Forms.Button
    Friend WithEvents btnMove As System.Windows.Forms.Button
    Friend WithEvents btnDelete As System.Windows.Forms.Button
    Friend WithEvents txtDestination As System.Windows.Forms.TextBox
    Friend WithEvents txtSource As System.Windows.Forms.TextBox
  Friend WithEvents chkOverwrite As System.Windows.Forms.CheckBox

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.Container

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.btnCopy = New System.Windows.Forms.Button()
        Me.txtSource = New System.Windows.Forms.TextBox()
        Me.btnDelete = New System.Windows.Forms.Button()
        Me.lblDestination = New System.Windows.Forms.Label()
        Me.txtDestination = New System.Windows.Forms.TextBox()
        Me.lblSource = New System.Windows.Forms.Label()
        Me.btnMove = New System.Windows.Forms.Button()
        Me.chkOverwrite = New System.Windows.Forms.CheckBox()
        Me.SuspendLayout()
        '
        'btnCopy
        '
        Me.btnCopy.Location = New System.Drawing.Point(48, 56)
        Me.btnCopy.Name = "btnCopy"
        Me.btnCopy.TabIndex = 4
        Me.btnCopy.Text = "Kopiuj"
        '
        'txtSource
        '
        Me.txtSource.Location = New System.Drawing.Point(48, 8)
        Me.txtSource.Name = "txtSource"
        Me.txtSource.Size = New System.Drawing.Size(232, 20)
        Me.txtSource.TabIndex = 2
        Me.txtSource.Text = ""
        '
        'btnDelete
        '
        Me.btnDelete.Location = New System.Drawing.Point(204, 56)
        Me.btnDelete.Name = "btnDelete"
        Me.btnDelete.TabIndex = 6
        Me.btnDelete.Text = "Usu"
        '
        'lblDestination
        '
        Me.lblDestination.AutoSize = True
        Me.lblDestination.Location = New System.Drawing.Point(8, 36)
        Me.lblDestination.Name = "lblDestination"
        Me.lblDestination.Size = New System.Drawing.Size(24, 13)
        Me.lblDestination.TabIndex = 1
        Me.lblDestination.Text = "Cel:"
        '
        'txtDestination
        '
        Me.txtDestination.Location = New System.Drawing.Point(48, 32)
        Me.txtDestination.Name = "txtDestination"
        Me.txtDestination.Size = New System.Drawing.Size(232, 20)
        Me.txtDestination.TabIndex = 3
        Me.txtDestination.Text = ""
        '
        'lblSource
        '
        Me.lblSource.AutoSize = True
        Me.lblSource.Location = New System.Drawing.Point(8, 12)
        Me.lblSource.Name = "lblSource"
        Me.lblSource.Size = New System.Drawing.Size(39, 13)
        Me.lblSource.TabIndex = 0
        Me.lblSource.Text = "rdo:"
        '
        'btnMove
        '
        Me.btnMove.Location = New System.Drawing.Point(126, 56)
        Me.btnMove.Name = "btnMove"
        Me.btnMove.TabIndex = 5
        Me.btnMove.Text = "Przenie"
        '
        'chkOverwrite
        '
        Me.chkOverwrite.FlatStyle = System.Windows.Forms.FlatStyle.Flat
        Me.chkOverwrite.Location = New System.Drawing.Point(112, 88)
        Me.chkOverwrite.Name = "chkOverwrite"
        Me.chkOverwrite.TabIndex = 8
        Me.chkOverwrite.Text = "Nadpisz"
        '
        'frmFiler
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(292, 117)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.chkOverwrite, Me.btnDelete, Me.btnMove, Me.btnCopy, Me.txtDestination, Me.txtSource, Me.lblDestination, Me.lblSource})
        Me.Name = "frmFiler"
        Me.Text = "Menader plikw"
        Me.ResumeLayout(False)

    End Sub

#End Region


  Private Sub CopyClick(ByVal sender As System.Object, _
  ByVal e As System.EventArgs) Handles btnCopy.Click
    MessageBox.Show("CopyClick")
  End Sub




  Private Sub btnCopy_Click(ByVal sender As System.Object, _
  ByVal e As System.EventArgs) Handles btnCopy.Click
    Dim sSource As String
    Dim sDestination As String
    sSource = txtSource.Text()
    sDestination = txtDestination.Text()

    If File.Exists(sSource) Then

      Dim sConfirm As String
      sConfirm = _
      String.Format("Are you sure you wish to copy {0} to {1}?", _
          sSource, sDestination)
      If MessageBox.Show(sConfirm, _
        "Confirm Copy", _
        MessageBoxButtons.YesNo, _
        MessageBoxIcon.Question, _
        MessageBoxDefaultButton.Button2) = DialogResult.Yes Then

        Try
          File.Copy(sSource, sDestination, chkOverwrite.Checked)
        Catch objException As Exception
          MessageBox.Show(objException.Message)
        End Try
      End If
    End If
  End Sub

  Private Sub btnMove_Click(ByVal sender As System.Object, _
  ByVal e As System.EventArgs) Handles btnMove.Click
    Dim sSource As String
    Dim sDestination As String
    sSource = txtSource.Text()
    sDestination = txtDestination.Text()
    If File.Exists(sSource) Then
      Dim sConfirm As String
      sConfirm = String.Format( _
        "Are you sure you wish to move {0} to {1}?", _
        sSource, sDestination)

      If MessageBox.Show(sConfirm, _
        "Confirm Move", MessageBoxButtons.YesNo, _
         MessageBoxIcon.Question, _
         MessageBoxDefaultButton.Button2) = DialogResult.Yes Then

        If File.Exists(sDestination) Then
          If chkOverwrite.Checked Then
            File.Delete(sDestination)
          Else
            MessageBox.Show("Move aborted, destination exists")
            Return
          End If
        End If
        File.Move(sSource, sDestination)
      End If
    End If

  End Sub

  Private Sub btnDelete_Click(ByVal sender As Object, _
  ByVal e As System.EventArgs) Handles btnDelete.Click
    Dim sSource As String
    sSource = txtSource.Text()

    If File.Exists(sSource) Then
      Dim sConfirm As String
      sConfirm = String.Format( _
      "Are you sure you want to delete {0}?", _
      sSource)

      If MessageBox.Show(sConfirm, _
        "Confirm Delete", MessageBoxButtons.YesNo, _
        MessageBoxIcon.Question, _
        MessageBoxDefaultButton.Button2) = DialogResult.Yes Then

        File.Delete(sSource)
      End If
    End If

  End Sub

  Private Sub DoEverything(ByVal sender As Object, _
  ByVal e As System.EventArgs) '_
    'Handles btnCopy.Click, btnMove.Click, btnDelete.Click

    Dim sEventSource As String = CType(sender, Control).Name
    Dim sSource As String
    Dim sDestination As String
    sSource = txtSource.Text()
    sDestination = txtDestination.Text()

    Select Case sEventSource
      Case "btnCopy"
        File.Copy(sSource, sDestination)
      Case "btnMove"
        File.Move(sSource, sDestination)
      Case "btnDelete"
        File.Delete(sSource)
      Case Else
        'do nothing
    End Select
  End Sub
End Class
