Imports System.Xml

Public Class Settings
    Private m_sFileName As String
    Private m_oItems As Hashtable

    Public Sub New()
        Me.FileName = AppDomain.CurrentDomain.BaseDirectory & _
          AppDomain.CurrentDomain.FriendlyName & ".cfg"
    End Sub
    Public Sub New(ByVal fileName As String)
        Me.FileName = fileName
    End Sub

    Public Property FileName() As String
        Get
            Return m_sFileName
        End Get
        Set(ByVal Value As String)
            m_sFileName = Value
            LoadDOM()
        End Set
    End Property

    Public Property Items() As Hashtable
        Get
            Return m_oItems
        End Get
        Set(ByVal Value As Hashtable)
            m_oItems = Value
        End Set
    End Property

    Public Sub LoadReader()
        'loads the contents of the settings file into
        '   the HashTable
        m_oItems = New Hashtable()
        Dim oReader As XmlTextReader
        Dim sLastElement As String

        Try
            oReader = New XmlTextReader(FileName)
            While (oReader.Read)
                Select Case oReader.NodeType
                    Case XmlNodeType.Element
                        If oReader.Name <> "appSettings" Then
                            m_oItems.Add(oReader.Name, Nothing)
                            sLastElement = oReader.Name
                        End If
                    Case XmlNodeType.Text
                        m_oItems.Item(sLastElement) = oReader.Value
                End Select
            End While
        Catch ex As Exception
        Finally
            oReader.Close()
            oReader = Nothing
        End Try
    End Sub

    Public Sub LoadDOM()
        m_oItems = New Hashtable()
        Dim oDoc As New XmlDocument()
        Dim oNode As XmlElement

        Try
            oDoc.Load(FileName)

            oNode = oDoc.DocumentElement.FirstChild
            Do While Not IsNothing(oNode)
                m_oItems.Add(oNode.Name, oNode.InnerText)
                oNode = oNode.NextSibling
            Loop

        Catch ex As Exception
        Finally
            oDoc = Nothing
        End Try
    End Sub

    Public Sub SaveWriter()
        Dim oWriter As XmlTextWriter
        Dim oItem As DictionaryEntry

        oWriter = New XmlTextWriter(m_sFileName, Nothing)
        oWriter.Formatting = Formatting.Indented
        oWriter.WriteStartElement("appSettings")

        For Each oItem In m_oItems
            oWriter.WriteElementString(oItem.Key, oItem.Value)
        Next
        oWriter.WriteEndElement()

        oWriter.Flush()
        oWriter.Close()

    End Sub

    Public Sub SaveDOM()
        Dim oDoc As New XmlDocument()
        Dim oRoot As XmlElement
        Dim oItem As DictionaryEntry
        Dim oNode As XmlElement

        oRoot = oDoc.CreateElement("appSettings")
        oDoc.AppendChild(oRoot)

        For Each oItem In m_oItems
            oNode = oDoc.CreateElement(oItem.Key)
            oNode.InnerText = oItem.Value
            oRoot.AppendChild(oNode)
        Next

        oDoc.Save(m_sFileName)
    End Sub
End Class
