Imports System.Net
Imports System.IO

Module Module1
    Private Const sConnection As String = "Provider=Microsoft.Jet.OLEDB.4.0; " & _
 "Data Source=C:\CD.mdb;Persist Security Info=False"

    Sub Main()
        Dim sSQL As String
        sSQL = "SELECT IDWykonawcy, Wykonawca From Wykonawcy"
        Dim objConn _
            As New OleDb.OleDbConnection(sConnection)
        Dim objDataAdapter _
            As New OleDb.OleDbDataAdapter(sSQL, objConn)
        Dim objDS _
            As New DataSet("Wykonawcy")
        Dim objDeleteCommand _
            As New OleDb.OleDbCommand()
        Dim objUpdateCommand _
            As New OleDb.OleDbCommand()
        Dim objInsertCommand _
            As New OleDb.OleDbCommand()
        Dim sDeleteSQL As String
        Dim sUpdateSQL As String
        Dim sInsertSQL As String

        sDeleteSQL = "DELETE FROM Wykonawcy WHERE IDWykonawcy = ?"

        objDeleteCommand.Connection = objConn
        objDeleteCommand.CommandText = sDeleteSQL

        Dim objParam As OleDb.OleDbParameter
        objParam = objDeleteCommand.Parameters.Add( _
                "@IDWykonawcy", OleDb.OleDbType.Integer)
        objParam.SourceColumn = "IDWykonawcy"
        objParam.SourceVersion = DataRowVersion.Original

        objDataAdapter.DeleteCommand = objDeleteCommand

        sUpdateSQL = "Update Wykonawcy SET Wykonawca = ? " & _
                     "WHERE IDWykonawcy = ?"

        objUpdateCommand.Connection = objConn
        objUpdateCommand.CommandText = sUpdateSQL

        objParam = objUpdateCommand.Parameters.Add( _
                "@Wykonawca", OleDb.OleDbType.Char)
        objParam.SourceColumn = "Wykonawca"
        objParam.SourceVersion = DataRowVersion.Current

        objParam = objUpdateCommand.Parameters.Add( _
                "@IDWykonawcy", OleDb.OleDbType.Integer)
        objParam.SourceColumn = "IDWykonawcy"
        objParam.SourceVersion = DataRowVersion.Original

        objDataAdapter.UpdateCommand = objUpdateCommand

        sInsertSQL = "INSERT INTO Wykonawcy (IDWykonawcy, Wykonawca) " & _
                     "VALUES (?,?)"

        objInsertCommand.Connection = objConn
        objInsertCommand.CommandText = sInsertSQL

        objParam = objInsertCommand.Parameters.Add( _
                "@IDWykonawcy", OleDb.OleDbType.Integer)
        objParam.SourceColumn = "IDWykonawcy"
        objParam.SourceVersion = DataRowVersion.Current

        objParam = objInsertCommand.Parameters.Add( _
                "@Wykonawca", OleDb.OleDbType.Char)
        objParam.SourceColumn = "Wykonawca"
        objParam.SourceVersion = DataRowVersion.Current

        objDataAdapter.InsertCommand = objInsertCommand

        Try
            objConn.Open()
        Catch myException As System.Exception
            Console.WriteLine(myException.Message)
        End Try

        Try
            Dim sNewArtistSQL As String
            sNewArtistSQL = "INSERT INTO Wykonawcy " & _
                "(IDWykonawcy, Wykonawca, " & _
                "ImiWykonawcy, NazwiskoWykonawcy)" & _
                "VALUES (11, 'Weird Al Yankovich'," & _
                " 'Al', 'Yankovich')"

            Dim objNewArtistCmd _
                As New OleDb.OleDbCommand(sNewArtistSQL, objConn)
            objNewArtistCmd.ExecuteNonQuery()
        Catch e As Exception
            'Moe spowodowa wystpienie bdu
            'bo ArtistID #11 ju istnieje.
            'Jeli tak, to baza poinformuje o wystpieniu bdu,
            'ale program nadal bdzie dziaa.
            Console.WriteLine(e.Message)
        End Try

        If objConn.State = ConnectionState.Open Then
            Try
				objDataAdapter.MissingSchemaAction _
					= MissingSchemaAction.AddWithKey
                objDataAdapter.Fill(objDS, "Wykonawcy")

                objConn.Close()
                Dim objTable As DataTable
                objTable = objDS.Tables("Wykonawcy")
                Dim drRows As DataRowCollection
                Dim objCurrentRow As DataRow
                drRows = objTable.Rows


				DisplayTable(objTable)

                Console.Write("Elementy zsotan usunite," & _
                    " wcinij Enter")
                Console.ReadLine()

                'Usunicie wiersza z kluczem gwnym  = 11
                drRows.Find(11).Delete()

                Console.Write("Usuwanie zakoczone," & _
                    " wcinij Enter, aby zobaczy wynik")
                Console.ReadLine()

                DisplayTable(objTable)

                Console.Write("Elementy zostan wprowadzone," & _
                    " wcinij Enter")
                Console.ReadLine()

                Dim drRow As Data.DataRow
                drRow = objTable.NewRow
                drRow("IDWykonawcy") = 40
                drRow("Wykonawca") = "Kent Sharkey"
                objTable.Rows.Add(drRow)

                Console.Write("Wprowadzanie zakoczone," & _
     " wcisnij Enter, aby zobaczy wynik.")
                Console.ReadLine()
                DisplayTable(objTable)


                Console.Write("Baza zostanie uaktualniona," & _
     " wcinij Enter!")
                Console.ReadLine()

                'Pobranie wiersza z kluczem gwnym = 7 (Lisa Loeb)
                drRow = drRows.Find(7)

                drRow.BeginEdit()
                drRow("Wykonawca") = "John Doe"
                drRow.EndEdit()

                Console.Write("Uaktualnianie zakoczone," & _
     " wcinij Enter")
                Console.ReadLine()
                DisplayTable(objTable)

                objConn.Open()
                objDataAdapter.Update(objDS, "Wykonawcy")

            Catch myException As System.Exception
                Console.WriteLine(myException.Message)
            End Try
            Console.Write("Wcisnij Enter, aby zakoczy dziaanie programu.")
			Console.ReadLine()
        End If
	End Sub
	Sub DisplayTable(ByRef objTable As DataTable)
		Dim objRow As DataRow
		Dim objCol As DataColumn
		Dim i, j As Integer

		For j = 0 To objTable.Columns.Count - 1
			objCol = objTable.Columns(j)
			Console.Write("{0}:{1} ", _
				objCol.ColumnName, _
				objCol.DataType.Name)
		Next
		Console.WriteLine()
		For i = 0 To objTable.Rows.Count - 1
			objRow = objTable.Rows(i)
			Select Case objRow.RowState
				Case DataRowState.Deleted
                    Console.Write("[Usunito]   ")
				Case DataRowState.Modified
                    Console.Write("[Zmodyfikowano]  ")
                Case DataRowState.Added
                    Console.Write("[Nowy]       ")
                Case DataRowState.Unchanged
                    Console.Write("[Nie zmieniono] ")
            End Select
			For j = 0 To objTable.Columns.Count - 1
				If objRow.RowState <> DataRowState.Deleted Then
					Console.Write("{0} ", _
						objRow.Item(j))
				Else
					Console.Write("{0} ", _
						objRow.Item(j, DataRowVersion.Original))
				End If
			Next
			Console.WriteLine()
		Next
	End Sub
End Module