
'*********************************************************
' Purpose: Attaches the CD database to your SQL Server or 
'          MSDE Database. 
'
' Inputs:  Requires that CD.mdf and CD.ldf are in the same
'          folder and that the correct password for the "sa"
'          account is entered in this file.
'
' Result:  If Attach of DB succeeds, cd.mdf and cd.ldf will
'          not move, but they will be associated with your
'          local SQL or MSDE database
'*********************************************************

'Change this line if your "sa" account does not have
'a blank password.
Const SA_PASSWORD = ""

Dim sPath




sPath = Replace(WScript.ScriptFullName, WScript.ScriptName, "")

mdfPath = sPath & "cd.mdf"
ldfPath = sPath & "cd.ldf"

Dim fso

Set fso = CreateObject("Scripting.FileSystemObject")

If fso.FileExists(mdfPath) Then

	If fso.FileExists(ldfPath) Then

	   On Error Resume Next
  	   Dim oSvroot
   	   Set oSvroot = CreateObject("SQLDMO.SQLServer")
	   If Err.Number <> 0 Then
		WScript.Echo "Error: " & Err.Description
		WScript.Quit
	   End If

	   oSvroot.Connect "(local)", "sa", SA_PASSWORD

	   If Err.Number <> 0 Then
		WScript.Echo "Error: " & Err.Description
		WScript.Quit
	   End If

	   oSvroot.AttachDB "CD", "[" & mdfPath & "],[" & ldfPath & "]"

	   If Err.Number <> 0 Then
		WScript.Echo "Error: " & Err.Description
		WScript.Quit
	   Else
 	   	WScript.Echo "Attachment of CD database has completed successfully!"
	   End If

	Else

	   WScript.Echo "LDF File not found at " & ldfPath
	   WScript.Quit

	End If

Else

   Wscript.Echo "MDF File not found at " & mdfPath
   WScript.Quit

End If


WScript.Quit

AttachError:

	WScript.Echo "There has been an Error: " & Err.Description

	WScript.Quit

