﻿Option Strict On
Option Explicit On
Option Infer Off

Imports Microsoft.Win32

Public Class Form1
    Private Shared Function PobierzRozszerzeniaPlikow() As SortedList(Of String, String)
        Dim rejestr As RegistryKey = Registry.ClassesRoot
        Dim rozszerzenia As SortedList(Of String, String) = New SortedList(Of String, String)
        For Each nazwa As String In rejestr.GetSubKeyNames()
            If nazwa(0) = "." AndAlso (nazwa.Length > 1 AndAlso nazwa(1) <> "_") Then
                Try
                    Dim kod As String = rejestr.OpenSubKey(nazwa).GetValue("").ToString()
                    rozszerzenia.Add(nazwa, kod)
                Catch ex As NullReferenceException
                    'brak opisu rozszerzenia
                End Try
            End If
        Next
        Return rozszerzenia
    End Function

    Private Shared Sub PobierzInformacjeOSkojarzonejAplikacji(ByVal kod As String, ByRef opis As String, ByRef polecenie As String, ByRef edytor As String)
        'otwieranie klucza HKEY_CLASSES_ROOT\[kod]
        Dim rejestr As RegistryKey = Registry.ClassesRoot.OpenSubKey(kod)
        If rejestr Is Nothing Then
            Throw New Exception("Klucz o wskazanej przez kod nazwie nie istnieje")
        End If

        'odczytywanie opisu typu plików
        Try
            opis = rejestr.GetValue("").ToString()
        Catch
            'Brak wartości domyślnej z opisem
            opis = "Brak opisu dla typu " & kod
        End Try

        'odczytywanie nazwy polecenia głównego (domyślnie open)
        Try
            polecenie = rejestr.OpenSubKey("shell").GetValue("").ToString()
        Catch
            'Polecenie domyślne nie jest zapisane
            polecenie = "open"
        End Try

        'odczytywanie nazwy pliku domyślnego edytora
        Try
            edytor = rejestr.OpenSubKey("shell").OpenSubKey(polecenie).OpenSubKey("command").GetValue("").ToString()
        Catch
            Throw New Exception("Brak informacji o domyślnym edytorze dla typu " & kod)
        End Try

        'zamykanie klucza
        rejestr.Close()
    End Sub

    Private Shared Function PobierzInformacjeOSkojarzonejAplikacjiUzytkownika(ByVal rozszerzenie As String, ByRef edytor As String) As Boolean
        'otwieranie klucza
        Dim rejestr As RegistryKey = Registry.CurrentUser.OpenSubKey("Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\" & rozszerzenie)
        edytor = ""
        If rejestr Is Nothing Then Return False

        'odczytywanie edytora
        Try
            edytor = rejestr.GetValue("Application").ToString()
        Catch
            Return False
        Finally
            'zamykanie klucza
            rejestr.Close()
        End Try

        Return True
    End Function

    Private rozszerzenia As SortedList(Of String, String) = PobierzRozszerzeniaPlikow()

    Public Sub New()
        InitializeComponent()

        'umieszczanie listy rozszerzeń w rozwijanej liście ComboBox1
        ComboBox1.Items.AddRange(rozszerzenia.Keys.ToArray())
        ComboBox1.SelectedIndex = 0
    End Sub

    Private Sub ComboBox1_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles ComboBox1.SelectedIndexChanged
        Dim kod As String = ""
        If Not rozszerzenia.TryGetValue(ComboBox1.SelectedItem.ToString(), kod) Then
            TextBox1.Text = ""
            TextBox2.Text = ""
            TextBox3.Text = ""
            Return
        End If
        TextBox1.Text = kod

        Dim opis As String = ""
        Dim polecenie As String = ""
        Dim edytor As String = ""
        Dim edytorUzytkownika As String = ""
        Try
            PobierzInformacjeOSkojarzonejAplikacji(kod, opis, polecenie, edytor)
            If PobierzInformacjeOSkojarzonejAplikacjiUzytkownika(kod, edytorUzytkownika) Then
                edytor = edytorUzytkownika & " (prywatne)"
            End If
            TextBox3.Text = edytor
        Catch ex As Exception
            TextBox3.Text = ex.Message
        End Try
        TextBox2.Text = opis
    End Sub
End Class
