﻿Option Strict On
Option Explicit On
Option Infer Off

Imports System.Data.Linq.Mapping
Imports System.Data.Linq

Public Class Form1
    <Table(Name:="ListaOsob")>
    Class Osoba
        <Column(Name:="Id", IsPrimaryKey:=True)>
        Public Id As Integer
        <Column(Name:="Imię", CanBeNull:=False)>
        Public Imię As String
        <Column(Name:="Nazwisko", CanBeNull:=False)>
        Public Nazwisko As String
        <Column()>
        Public NumerTelefonu As Integer
        <Column()>
        Public Wiek As Integer
    End Class

    Private Shared nazwaPliku As String = "Telefony.mdf"
    Private Shared bazaDanychTelefony As DataContext = New DataContext(System.IO.Path.GetFullPath(nazwaPliku))
    Private Shared listaOsob As Table(Of Osoba) = bazaDanychTelefony.GetTable(Of Osoba)()

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        'pobieranie kolekcji
        Dim listaOsobPelnoletnich As IEnumerable(Of Osoba) = _
            From osoba In listaOsob
            Where osoba.Wiek >= 18
            Select osoba

        'wyświetlanie pobranej kolekcji
        Dim s As String = "Lista osób pełnoletnich:" & vbNewLine
        For Each osoba As Osoba In listaOsobPelnoletnich
            s &= osoba.Imię & " " & osoba.Nazwisko & " (" & osoba.Wiek.ToString() & ")" & vbNewLine
        Next
        MessageBox.Show(s)
    End Sub

    Private Sub Button2_Click(sender As System.Object, e As System.EventArgs) Handles Button2.Click
        'pobieranie kolekcji
        Dim listaOsobDoZmianyWieku As IEnumerable(Of Osoba) = _
            From osoba In listaOsob
            Where (osoba.Wiek < 18 Or Not osoba.Imię.EndsWith("a"))
            Select osoba

        'wyświetlanie pobranej kolekcji
        Dim s As String = "Lista osób niebędących pełnoletnimi kobietami:" & vbNewLine
        For Each osoba As Osoba In listaOsobDoZmianyWieku
            s &= osoba.Imię & " " & osoba.Nazwisko & " (" & osoba.Wiek & ")" & vbNewLine
        Next
        MessageBox.Show(s)

        'modyfikowanie kolekcji
        For Each osoba As Osoba In listaOsobDoZmianyWieku
            osoba.Wiek += 1
        Next

        'wyświetlanie pełnej listy osób kolekcji po zmianie
        s = "Lista wszystkich osób:" & vbNewLine
        For Each osoba As Osoba In listaOsob
            s &= osoba.Imię & " " & osoba.Nazwisko & " (" & osoba.Wiek & ")" & vbNewLine
        Next

        MessageBox.Show(s)

        'zapisywanie zmian
        bazaDanychTelefony.SubmitChanges()
    End Sub

    Private Sub Button3_Click(sender As System.Object, e As System.EventArgs) Handles Button3.Click
        'dodawanie osoby do tabeli
        Dim noweId As Integer = listaOsob.Max(Function(osoba) osoba.Id) + 1
        MessageBox.Show("Nowe Id: " & noweId)
        Dim noworodek As Osoba = New Osoba With {.Id = noweId, .Imię = "Ben", .Nazwisko = "Parr", .NumerTelefonu = 0, .Wiek = 0}
        listaOsob.InsertOnSubmit(noworodek)

        'zapisywanie zmian
        bazaDanychTelefony.SubmitChanges() 'dodawany jest także nowy rekord

        'wyświetlanie tabeli
        Dim s As String = "Lista osób:" & vbNewLine
        For Each osoba As Osoba In listaOsob
            s &= osoba.Imię & " " & osoba.Nazwisko & " (" & osoba.Wiek & ")" & vbNewLine
        Next
        MessageBox.Show(s)
    End Sub

    Private Sub Button4_Click(sender As System.Object, e As System.EventArgs) Handles Button4.Click
        'wybieranie elementów do usunięcia i ich oznaczanie
        Dim doSkasowania As IEnumerable(Of Osoba) = _
            From osoba In listaOsob
            Where osoba.Imię = "Nela"
            Select osoba
        listaOsob.DeleteAllOnSubmit(doSkasowania)

        'zapisywanie zmian
        bazaDanychTelefony.SubmitChanges()

        'wyświetlanie tabeli
        Dim s As String = "Lista osób:" & vbNewLine
        For Each osoba As Osoba In listaOsob
            s &= osoba.Imię & " " & osoba.Nazwisko & " (" & osoba.Wiek & ")" & vbNewLine
        Next

        MessageBox.Show(s)
    End Sub

End Class
