﻿Option Strict On
Option Explicit On
Option Infer Off

Imports System.Reflection

Public Class Form1

    Private a As Assembly = Nothing

    Private Sub exitToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Close()
    End Sub

    Private Sub aboutToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles aboutToolStripMenuItem.Click
        MessageBox.Show(".NET Assembly Explorer (version " & Application.ProductVersion & " VB)  " & vbNewLine & "(c) Jacek Matulewski 2004-2012" & vbNewLine & vbNewLine & "Newest version can be downloaded from" & vbNewLine & "http://www.phys.uni.torun.pl/~jacek/download/", ".NET Assembly Explorer")
    End Sub

    Private Sub openAnAssemblyToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles openAnAssemblyToolStripMenuItem.Click
        If openFileDialog1.ShowDialog() = DialogResult.OK Then
            Try
                a = Assembly.LoadFrom(openFileDialog1.FileName)
                toolStripStatusLabel1.Text = a.ToString()
                Me.Text = ".NET Assembly Explorer - " & a.Location
                listBox1.Items.Clear()
                listBox1.Items.AddRange(a.GetTypes())
                listBox1.SelectedIndex = 0
                assemblyInfoToolStripMenuItem.Enabled = True
            Catch exc As Exception
                MessageBox.Show("Error: " & exc.Message)
            End Try
        End If
    End Sub

    Private Sub listBox1_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles listBox1.SelectedIndexChanged
        Me.Cursor = Cursors.WaitCursor

        Dim type As Type = a.GetType(listBox1.SelectedItem.ToString())

        treeView1.BeginUpdate()
        treeView1.Nodes.Clear()

        treeView1.Nodes.Add(New TreeNode("Info"))
        treeView1.Nodes(0).Nodes.Add(New TreeNode("Name: " & type.FullName))
        treeView1.Nodes(0).Nodes.Add(New TreeNode("Assembly: " & type.Assembly.ToString()))
        treeView1.Nodes(0).Nodes.Add(New TreeNode("Attributes: " & type.Attributes))
        treeView1.Nodes(0).Nodes.Add(New TreeNode("Scope: " & If(type.IsPublic, "public", "not public")))
        treeView1.Nodes(0).Nodes.Add(New TreeNode("Class: " & type.IsClass))

        treeView1.Nodes.Add(New TreeNode("Fields"))
        Dim fields As FieldInfo() = type.GetFields()
        For Each field As FieldInfo In fields
            treeView1.Nodes(1).Nodes.Add(If(field.IsStatic, "static", "") & "  " & field.FieldType.ToString() & "  " & field.Name)
        Next

        treeView1.Nodes.Add(New TreeNode("Constructors"))
        Dim constructors As ConstructorInfo() = type.GetConstructors()
        For Each constructor As ConstructorInfo In constructors
            Dim parametersStr As String = ""
            Dim parameters As ParameterInfo() = constructor.GetParameters()
            For Each parameter As ParameterInfo In parameters
                parametersStr &= parameter.ParameterType.ToString() & " " & parameter.Name & ","
            Next
            If parametersStr.Length > 0 Then parametersStr = parametersStr.Substring(0, parametersStr.Length - 1)
            treeView1.Nodes(2).Nodes.Add(type.Name & "(" & parametersStr & ")")
        Next

        treeView1.Nodes.Add(New TreeNode("Methods"))
        Dim methods As MethodInfo() = type.GetMethods()
        For Each method As MethodInfo In methods
            treeView1.Nodes(3).Nodes.Add(If(method.IsStatic, "  static", "") & "  " & method.GetBaseDefinition().ToString())
        Next

        treeView1.Nodes.Add(New TreeNode("Properties"))
        Dim properties As PropertyInfo() = type.GetProperties()
        For Each [property] As PropertyInfo In properties
            treeView1.Nodes(4).Nodes.Add([property].PropertyType.ToString() & "  " & [property].Name & ",   {" & If([property].CanRead, "get; ", "") & If([property].CanWrite, "set;", "") & "}")
        Next

        treeView1.Nodes.Add(New TreeNode("Events"))
        Dim events As EventInfo() = type.GetEvents()
        For Each evnt As EventInfo In events
            treeView1.Nodes(5).Nodes.Add(evnt.EventHandlerType.ToString() & "  " & evnt.Name)
        Next

        treeView1.Nodes.Add(New TreeNode("Interfaces"))
        Dim interaces As Type() = type.GetInterfaces()
        For Each [interface] As Type In interaces
            treeView1.Nodes(6).Nodes.Add("" & [interface].Name)
        Next

        treeView1.Nodes.Add(New TreeNode("Nested Types"))
        Dim nestedTypes As Type() = type.GetNestedTypes()
        For Each nestedType As Type In nestedTypes
            treeView1.Nodes(7).Nodes.Add(nestedType.Name)
        Next

        treeView1.EndUpdate()

        Me.Cursor = Cursors.Default
    End Sub

    Private Sub nETInfoToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles nETInfoToolStripMenuItem.Click
        Dim systeminfo As String = ""
        systeminfo &= "Operating system version: " & Environment.OSVersion.ToString()
        systeminfo &= vbNewLine & ".NET Framework version: " & Environment.Version.ToString()

        systeminfo &= vbNewLine & vbNewLine & "Computer name: " & Environment.MachineName
        systeminfo &= vbNewLine & "User name: " & Environment.UserName
        systeminfo &= vbNewLine & vbNewLine & "Windows directory: " & Environment.GetEnvironmentVariable("windir")
        systeminfo &= vbNewLine & "System directory: " & Environment.SystemDirectory

        Dim ms_sekunda As Integer = 1000
        Dim ms_minuta As Integer = 60 * ms_sekunda
        Dim ms_godzina As Integer = 60 * ms_minuta
        Dim ms_doba As Integer = 24 * ms_godzina
        Dim ile_ms As Integer = Environment.TickCount
        Dim ile_dni As Integer = ile_ms \ ms_doba
        Dim reszta As Integer = ile_ms Mod ms_doba
        Dim ile_godzin As Integer = reszta \ ms_godzina
        reszta = reszta Mod ms_godzina
        Dim ile_minut As Integer = reszta \ ms_minuta
        reszta = reszta Mod ms_minuta
        Dim ile_sekund As Integer = reszta \ ms_sekunda
        systeminfo &= vbNewLine & "Duration of current Windows session: " & ile_dni & " dni, " & ile_godzin & " h, " & ile_minut & " min, " & ile_sekund & " s"

        MessageBox.Show(systeminfo, ".NET Framework informations")

    End Sub

    Private Sub assemblyInfoToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles assemblyInfoToolStripMenuItem.Click
        If a Is Nothing Then
            MessageBox.Show("Choose the assembly first", Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Information)
            Return
        End If

        Dim info As String = ""
        info &= "Name:   " & a.FullName & vbNewLine
        info &= "File:   " & a.Location & vbNewLine
        info &= "Entry point:   " & a.EntryPoint.ToString() & vbNewLine
        info &= "Version:   " & a.ImageRuntimeVersion & vbNewLine

        'Dim manfestResourceNames As String() = a.GetManifestResourceNames()
        'info &= "Zasoby:   "
        'For Each s As String In manfestResourceNames
        '    info += s
        'Next

        'Dim mri As ManifestResourceInfo = a.GetManifestResourceInfo((a.GetManifestResourceNames())(0))
        'info &= "Manifest:   " & mri.ResourceLocation

        MessageBox.Show(info, "Assembly info")
    End Sub

End Class
