﻿Option Strict On
Option Explicit On
Option Infer On 'Button5_Click

Public Class Form1

    Private Sub Form1_FormClosed(sender As System.Object, e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed
        Dim xml As XDocument = New XDocument( _
            New XDeclaration("1.0", "utf-8", "yes"), _
            New XComment("Parametry aplikacji"), _
            New XElement("opcje", _
                New XElement("okno", _
                    New XAttribute("nazwa", Me.Text), _
                    New XElement("pozycja", _
                        New XElement("X", Me.Left), _
                        New XElement("Y", Me.Top) _
                    ), _
                    New XElement("wielkość", _
                        New XElement("Szer", Me.Width), _
                        New XElement("Wys", Me.Height) _
                    ) _
                ) _
            ) _
        )

        xml.Save("Ustawienia.xml")
    End Sub

    'Private Sub Form1_FormClosed(sender As System.Object, e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed
    '    'definiowanie obiektów
    '    Dim xml As XDocument = New XDocument()
    '    Dim deklaracja As XDeclaration = New XDeclaration("1.0", "utf-8", "yes")
    '    Dim komentarz As XComment = New XComment("Parametry aplikacji")
    '    Dim opcje As XElement = New XElement("opcje")
    '    Dim okno As XElement = New XElement("okno")
    '    Dim nazwa As XAttribute = New XAttribute("nazwa", Me.Text)
    '    Dim pozycja As XElement = New XElement("pozycja")
    '    Dim X As XElement = New XElement("X", Me.Left)
    '    Dim Y As XElement = New XElement("Y", Me.Top)
    '    Dim wielkość As XElement = New XElement("wielkość")
    '    Dim Szer As XElement = New XElement("Szer", Me.Width)
    '    Dim Wys As XElement = New XElement("Wys", Me.Height)

    '    'budowanie drzewa (od gałęzi)
    '    pozycja.Add(X)
    '    pozycja.Add(Y)
    '    wielkość.Add(Szer)
    '    wielkość.Add(Wys)
    '    okno.Add(nazwa)
    '    okno.Add(pozycja)
    '    okno.Add(wielkość)
    '    opcje.Add(okno)

    '    xml.Declaration = deklaracja
    '    xml.Add(komentarz)
    '    xml.Add(opcje)

    '    'zapis do pliku
    '    xml.Save("Ustawienia.xml")
    'End Sub

    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        Try
            Dim xml As XDocument = XDocument.Load("Ustawienia.xml")

            'odczytanie tytułu okna
            Me.Text = xml.Root.Element("okno").Attribute("nazwa").Value

            'odczytanie pozycji i wielkości
            Dim pozycja As XElement = xml.Root.Element("okno").Element("pozycja")
            Me.Left = Integer.Parse(pozycja.Element("X").Value)
            Me.Top = Integer.Parse(pozycja.Element("Y").Value)

            Dim wielkość As XElement = xml.Root.Element("okno").Element("wielkość")
            Me.Width = Integer.Parse(wielkość.Element("Szer").Value)
            Me.Height = Integer.Parse(wielkość.Element("Wys").Value)
        Catch exc As Exception
            MessageBox.Show("Błąd podczas odczytywania pliku XML:" & vbNewLine & exc.Message)
        End Try
    End Sub

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        Dim xml As XDocument = XDocument.Load("Ustawienia.xml")

        'wersja XML
        Dim wersja As String = xml.Declaration.Version
        MessageBox.Show("Wersja XML: " & wersja)

        'odczytanie nazwy głównego elementu
        Dim nazwaElementuGlownego As String = xml.Root.Name.LocalName
        MessageBox.Show("Nazwa elementu głównego: " & nazwaElementuGlownego)

        'kolekcja podelementów ze wszystkich poziomów drzewa
        Dim wszystkiePodelementy As IEnumerable(Of XElement) = xml.Root.Descendants()
        Dim s As String = "Wszystkie podelementy:" & vbNewLine
        For Each podelement As XElement In wszystkiePodelementy
            s &= podelement.Name.ToString() & vbNewLine
        Next

        MessageBox.Show(s)

        'kolekcja podelementów elementu okno
        Dim podelementyOkno As IEnumerable(Of XElement) = xml.Root.Element("okno").Elements()
        s = "Podelementy elementu okno:" & vbNewLine
        For Each podelement As XElement In podelementyOkno
            s &= podelement.Name.ToString() & vbNewLine
        Next
        MessageBox.Show(s)
    End Sub

    Class Osoba
        Public Id As Integer
        Public Imię, Nazwisko As String
        Public NumerTelefonu As Integer
        Public Wiek As Integer
    End Class

    Dim listaOsob As List(Of Osoba) = New List(Of Osoba)({ _
        New Osoba With {.Id = 1, .Imię = "Bob", .Nazwisko = "Parr", .NumerTelefonu = 7272024, .Wiek = 39}, _
        New Osoba With {.Id = 2, .Imię = "Helen", .Nazwisko = "Parr", .NumerTelefonu = 7272025, .Wiek = 40}, _
        New Osoba With {.Id = 3, .Imię = "Wiola", .Nazwisko = "Parr", .NumerTelefonu = 7272022, .Wiek = 14}, _
        New Osoba With {.Id = 4, .Imię = "Maks", .Nazwisko = "Parr", .NumerTelefonu = 7272021, .Wiek = 11}, _
        New Osoba With {.Id = 5, .Imię = "Jack-Jack", .Nazwisko = "Parr", .NumerTelefonu = 0, .Wiek = 1} _
    })

    Private Sub Button2_Click(sender As System.Object, e As System.EventArgs) Handles Button2.Click
        Dim xml As XDocument = New XDocument( _
            New XDeclaration("1.0", "utf-8", "yes"), _
                New XElement("ListaOsob", _
                    From osoba In listaOsob _
                    Order By (osoba.Wiek) _
                    Select New XElement("Osoba", _
                        New XAttribute("Id", osoba.Id), _
                        New XElement("Imię", osoba.Imię), _
                        New XElement("Nazwisko", osoba.Nazwisko), _
                        New XElement("NumerTelefonu", osoba.NumerTelefonu), _
                        New XElement("Wiek", osoba.Wiek) _
                    ) _
                ) _
            )

        xml.Save("ListaOsob.xml")
    End Sub

    Private Sub Button4_Click(sender As System.Object, e As System.EventArgs) Handles Button4.Click
        'pobieranie danych
        Dim xml As XDocument = XDocument.Load("ListaOsob.xml")
        Dim listaOsobPelnoletnich As IEnumerable(Of Osoba) = _
            From osoba In xml.Descendants("Osoba") _
            Select _
                New Osoba With { _
                    .Id = Integer.Parse(osoba.Attribute("Id").Value), _
                    .Imię = osoba.Element("Imię").Value, _
                    .Nazwisko = osoba.Element("Nazwisko").Value, _
                    .NumerTelefonu = Integer.Parse(osoba.Element("NumerTelefonu").Value), _
                    .Wiek = Integer.Parse(osoba.Element("Wiek").Value) _
                }

        'wyświetlanie danych
        Dim s As String = "Lista osób pełnoletnich:" & vbNewLine
        For Each osoba As Osoba In listaOsobPelnoletnich
            s &= osoba.Imię & " " & osoba.Nazwisko & " (" & osoba.Wiek & ")" & vbNewLine
        Next
        MessageBox.Show(s)
    End Sub

    Private Sub Button5_Click(sender As System.Object, e As System.EventArgs) Handles Button5.Click
        Dim xml As XDocument = XDocument.Load("Ustawienia.xml")
        Dim cos = From element In xml.Descendants() Where element.Name = "X" Select element
        Dim ile As Integer = cos.Count()
        MessageBox.Show(ile.ToString())
        Dim s As String = "Wartości elementów:" & vbNewLine
        For Each element As XElement In cos
            s += element.Value
        Next
        MessageBox.Show(s)
    End Sub

    Private Sub Button6_Click(sender As System.Object, e As System.EventArgs) Handles Button6.Click
        'pobieranie danych
        Dim xml As XDocument = XDocument.Load("ListaOsob.xml")
        Dim listaOsobPelnoletnich As IEnumerable(Of String) = _
            From osoba In xml.Descendants("Osoba") _
            Where Integer.Parse(osoba.Element("Wiek").Value) >= 18 _
            Order By (osoba.Element("Imię").Value) _
            Select osoba.Element("Imię").Value & " " & osoba.Element("Nazwisko").Value & " (" & osoba.Element("Wiek").Value & ")"

        'wyświetlanie danych
        Dim s As String = "Lista osób pełnoletnich:" & vbNewLine
        For Each personalia As String In listaOsobPelnoletnich
            s &= personalia & vbNewLine
        Next
        MessageBox.Show(s)
    End Sub

    Private Sub Button7_Click(sender As System.Object, e As System.EventArgs) Handles Button7.Click
        Dim xml As XDocument = XDocument.Load("ListaOsob.xml")
        Dim listaOsob As IEnumerable(Of XElement) = xml.Descendants("Osoba").Where(Function(Osoba) (Osoba.Element("Imię").Value = "Maks" AndAlso Osoba.Element("Nazwisko").Value = "Parr"))
        If listaOsob.Count() > 0 Then
            listaOsob.First().Element("Wiek").Value = (Integer.Parse(listaOsob.First().Element("Wiek").Value) + 1).ToString()
        Else
            MessageBox.Show("Brak osób o podanym imieniu i nazwisku")
            Return
        End If
        xml.Save("ListaOsob.xml")
    End Sub

    Private Sub Button3_Click(sender As System.Object, e As System.EventArgs)

    End Sub
End Class
