Imports System.EnterpriseServices
Imports System.Text
Imports System.Reflection
Imports System.Threading
Imports System.Windows.Forms

'<EventTrackingEnabled(), _
' ComponentAccessControl(), _
' Description("A secure component")> _
Public Class MyComponent
   Inherits ServicedComponent
   Implements IMyInterface


   Public Sub PrivilegedMethodDeclarative() Implements IMyInterface.PrivilegedMethodDeclarative
      DisplayTraceMessageBox()
   End Sub

   Public Sub PrivilegedMethodProgrammatic(ByVal value As Integer) Implements IMyInterface.PrivilegedMethodProgrammatic
      DisplayTraceMessageBox()
   End Sub

   Public Sub RegularMethod() Implements IMyInterface.RegularMethod
      DisplayTraceMessageBox()
   End Sub

   Private Sub DisplayTraceMessageBox()
      Dim className As String
      Dim methodName As String
      Dim details As New StringBuilder
      Dim sf As New StackFrame(1) ' gets the stack frame calling us
      Dim mi As MethodBase = sf.GetMethod() 'info about the method calling us
      className = mi.DeclaringType.Name 'class declaring the method calling us
      methodName = mi.Name 'the actual name of the method  calling us
      details.Append(className)
      details.Append(".")
      details.Append(methodName)
      details.Append(Environment.NewLine)
      details.Append("   Process=")
      details.Append(Process.GetCurrentProcess().Id)
      details.Append(Environment.NewLine)
      details.Append("   Thread=")
      details.Append(Thread.CurrentThread.GetHashCode().ToString())
      Try
         details.Append(Environment.NewLine)
         details.Append("   Context=")
         'Throws COM Exception if zero services requested
         Dim contextID As Guid = ContextUtil.ContextId
         details.Append(contextID.ToString())
         details.Append(Environment.NewLine)
         details.Append("   Security=")
         details.Append(ContextUtil.IsSecurityEnabled().ToString())
         details.Append("; IsInRole(""PrivilegedTestUser"")=")
         details.Append(ContextUtil.IsCallerInRole("PrivilegedTestUser"))
      Catch ex As Exception
         'Catches exception if no context (zero services requested)
         details.Append("<None>")
      End Try
      MessageBox.Show(details.ToString(), _
         "Show Method Call Detail")
   End Sub

End Class

