Imports System.Text.RegularExpressions

Public Class CommandProcessor

   Public Shared Sub Main(ByVal args() As String)
      Dim cmdProc As New CommandProcessor
      Try
         cmdProc.ProcessCommand(args)
      Catch e As UsageException
         cmdProc.PrintUsage()
      Catch e As Exception
         Console.WriteLine(e.ToString)
      End Try
   End Sub

   Private Enum Operation
      Uninstall
      Reinstall
      Install
        ShutdownAll
   End Enum

   Private m_NextArg As Integer

   Public Sub ProcessCommand(ByVal args() As String)
      Dim theAssembly As AssemblyHelper
      Dim isVerbose As Boolean
      Dim operation As Operation
      Dim registrar As ComPlusRegistrar

      isVerbose = CheckVerbose(args)
      operation = FindOperation(args)
      theAssembly = New AssemblyHelper(args(m_NextArg))
      registrar = New ComPlusRegistrar(isVerbose)
      Select Case operation
            Case operation.Uninstall
                registrar.Uninstall(theAssembly)
            Case operation.Install
                registrar.Install(theAssembly)
            Case operation.Reinstall
                registrar.Uninstall(theAssembly)
                registrar.Install(theAssembly)
            Case operation.ShutdownAll
                registrar.ShutdownAll()
            Case Else
                Throw New ArgumentOutOfRangeException("Operation", operation, _
                                     "FindOperation returned illegal operation")
        End Select
   End Sub

   Private Function FindOperation(ByVal args() As String) As Operation
      Dim regex As Regex
      regex = New Regex("^[/\-]u(ninstall)?$", RegexOptions.IgnoreCase)
      If regex.IsMatch(args(m_NextArg)) Then
         m_NextArg += 1
         If Not (args.Length = (m_NextArg + 1)) Then
            Throw New UsageException
         End If
         Return Operation.Uninstall
      End If
      regex = New Regex("^[/\-]r(einstall)?$", RegexOptions.IgnoreCase)
      If regex.IsMatch(args(m_NextArg)) Then
         m_NextArg += 1
         If Not (args.Length = (m_NextArg + 1)) Then
            Throw New UsageException
         End If
         Return Operation.Reinstall
      End If
      regex = New Regex("^[/\-]i(nstall)?$", RegexOptions.IgnoreCase)
      If regex.IsMatch(args(m_NextArg)) Then
         m_NextArg += 1
         If Not (args.Length = (m_NextArg + 1)) Then
            Throw New UsageException
         End If
         Return Operation.Install
      End If
        regex = New Regex("^[/\-]s(hutdownall)?$", RegexOptions.IgnoreCase)
        If regex.IsMatch(args(m_NextArg)) Then
            m_NextArg += 1
            If Not (args.Length = m_NextArg) Then
                Throw New UsageException
            End If
            Return Operation.Install
        End If
        Throw New UsageException
   End Function

   Private Function CheckVerbose(ByVal args() As String) As Boolean
      If args.Length = 0 Then
         Throw New UsageException
      End If
      Dim regex As Regex
      regex = New Regex("^[/\-]q(uiet)?$", RegexOptions.IgnoreCase)
      Dim isQuiet As Boolean = regex.IsMatch(args(m_NextArg))
      If isQuiet Then
         m_NextArg = 1
         If args.Length = 1 Then
            Throw New UsageException
         End If
      End If
      Return Not isQuiet
   End Function

   Public Sub PrintUsage()
      Console.WriteLine( _
      "Usage: ComPlusAdmin [-q(uiet)] <option> [<parameters>]")
      Console.WriteLine( _
      "  Options:")
      Console.WriteLine( _
      "    -u(ninstall) <assembly_name>")
      Console.WriteLine( _
      "        Uninstall assembly: stop if it is a server application;")
      Console.WriteLine( _
      "        remove component from catalog (application is not removed)")
      Console.WriteLine( _
      "        and GAC")
      Console.WriteLine( _
      "    -i(nstall) <assembly_name>")
      Console.WriteLine( _
      "        Install assembly: in GAC and in COM+ catalog")
        Console.WriteLine( _
        "    -r(einstall) <assembly_name>")
        Console.WriteLine( _
        "        Uninstall and then install assembly")
        Console.WriteLine( _
        "    -s(hutdownall)")
        Console.WriteLine( _
        "        Shuts down all running instances of COM+ applications")
    End Sub

End Class
