Imports System.EnterpriseServices
Imports System.Threading
Imports System.Runtime.InteropServices
Imports System.IO
Imports System.Reflection
Imports System.Text
Imports System.Text.RegularExpressions
Imports System.Xml
Imports COMAdmin

Public NotInheritable Class ComPlusRegistrar

   Private m_Verbose As Boolean
   Private m_Catalog As ICOMAdminCatalog

   Public Sub New(ByVal isVerbose As Boolean)
      m_Verbose = isVerbose
      m_Catalog = CType(New COMAdminCatalog, ICOMAdminCatalog)
   End Sub

   Public Sub Install(ByVal theAssembly As AssemblyHelper)
      Dim name As String

        'Instalacja w GAC.
      name = theAssembly.FullFileName
        WriteLine("Dodawanie {0} do GAC", name)
      Dim args As String = "-silent -i """ + name + """"
      Dim info As ProcessStartInfo = New ProcessStartInfo("gacutil.exe", args)
      info.CreateNoWindow = True
      info.WindowStyle = ProcessWindowStyle.Hidden
      Dim process As Process = process.Start(info)
      process.WaitForExit()

        'Instalacja w COM+ z dynamiczn rejestracj.
      Dim myDomain As AppDomain = AppDomain.CurrentDomain
      Dim theApplicationName As String = theAssembly.ComPlusApplicationName
      Dim theAssemblyName As String = theAssembly.FullName
      For Each componentName As String In theAssembly.GetComPlusComponents
            WriteLine("Instalowanie {0} w aplikacji COM+ {1}", componentName, _
               theApplicationName)
         Try
                'Rejestrowanie podzespou (jeden powinien wystarczy).
                'Usuwa wynikowy obiekt.
            myDomain.CreateInstanceAndUnwrap(theAssemblyName, componentName)
         Catch ex As Exception
                Dim e2 As Exception = ex 'Do debugowania.
         End Try
      Next
   End Sub

   Public Sub Uninstall(ByVal theAssembly As AssemblyHelper)
      Dim application As String = theAssembly.ComPlusApplicationName

        'Wyszukiwanie aplikacji COM+, jeli istnieje.
      Dim appCollection As ICatalogCollection = _
            CType(m_Catalog.GetCollection("Applications"), ICatalogCollection)
      appCollection.Populate()
      Dim appCount As Integer = appCollection.Count
      Dim i As Integer
      Dim currentName As String = ""
      Dim appKey As Object = New Object
      Dim app As ICatalogObject = Nothing
      Dim compCollection As ICatalogCollection = Nothing
      Dim found As Boolean = False
      i = 0
      While i < appCount AndAlso Not found
         app = CType(appCollection.Item(i), ICatalogObject)
         currentName = CType(app.Value("Name"), String)
         If currentName = application Then
                'Aplikacja COM+ zostaa znaleziona.
            appKey = app.Key
            compCollection = _
               CType(appCollection.GetCollection("Components", appKey), _
               ICatalogCollection)
            compCollection.Populate()
            found = True
         End If
         i += 1
      End While
      If found Then
            'Czy aplikacja jest uruchomiona?
         Dim tries As Integer = 0
         While IsRunning(appCollection, appKey)
                'Aplikacja COM+ (wci) dziaa -> zostaje zatrzymana.
            InitiateShutdown(application)
            If IsRunning(appCollection, appKey) Then
                    'Aplikacja COM+ wci dziaa.
               If tries > 200 Then
                        'Niepowodzenie.
                        WriteLine( _
                          "Nie udao si zamkn aplikacji COM+ {0} w cigu 20 sekund", _
                          application)
                        Throw New ApplicationException( _
                            "Nieudane zamykanie aplikacji COM+ " + application)
               Else
                        'Ponowna prba zatrzymania aplikacji po 100 ms.
                  Thread.Sleep(TimeSpan.FromMilliseconds(100))
                  tries += 1
               End If
            End If
         End While

            'Usunicie komponentu z aplikacji COM+.
         Dim servicedComp As String() = theAssembly.GetComPlusComponents
         Dim j As Integer = 0
         While j < compCollection.Count
            Dim compObj As ICatalogObject = CType(compCollection.Item(j), _
                  ICatalogObject)
            Dim compName As String = CType(compObj.Name, String)
            Dim k As Integer = 0
            While k < servicedComp.Length
               If servicedComp(k) = compName Then
                  compCollection.Remove(j)
                  j -= 1
                        WriteLine( _
                           "RUsunito komponent {0} z aplikacji COM+ {1}", _
                           compName, application)
                  Exit While
               End If
               k += 1
            End While
            j += 1
         End While
         compCollection.SaveChanges()
      End If

        'Usunicie z GAC.
      Dim name As String = theAssembly.AssemblyName
        WriteLine("Usuwanie {0} z GAC", name)
      Dim args As String = "-silent -u """ + name + """"
      Dim info As ProcessStartInfo = New ProcessStartInfo("gacutil.exe", args)
      info.CreateNoWindow = True
      info.WindowStyle = ProcessWindowStyle.Hidden
      Dim process As Process = process.Start(info)
      process.WaitForExit()

   End Sub

    Public Sub ShutdownAll()

        'Wyszukanie wszystkich uruchomionych aplikacji COM+.
        Dim anyRunning As Boolean = True

        While anyRunning
            Dim instanceCollection As ICatalogCollection = _
                CType(m_Catalog.GetCollection("ApplicationInstances"), _
                    ICatalogCollection)
            instanceCollection.Populate()
            anyRunning = instanceCollection.Count = 0
            For Each appObj As Object In instanceCollection
                Dim app As ICatalogObject = CType(appObj, ICatalogObject)
                m_Catalog.ShutdownApplication(app.Name)
            Next
        End While
    End Sub

    Private Function IsRunning(ByVal appCollection As ICatalogCollection, _
             ByVal appKey As Object) As Boolean
        'Sprawdzenie katalogu.
        Dim instances As ICatalogCollection = _
           CType(appCollection.GetCollection("ApplicationInstances", _
           appKey), ICatalogCollection)
        instances.Populate()
        Return instances.Count > 0
    End Function

    Private Sub InitiateShutdown(ByVal application As String)
        Try
            'Polecenie zamknicia.
            m_Catalog.ShutdownApplication(application)
            WriteLine("Zamykanie aplikacji COM+ {0}", application)
        Catch ex As COMException
            WriteLine( _
               "Nieudane zamknicie aplikacji COM+ {0} zamykanie: {1}", _
               application, ex.ToString)
            Throw ex
        End Try
    End Sub

    Private Sub WriteLine(ByVal format As String, ByVal ParamArray arg As Object())
        If m_Verbose Then
            Console.WriteLine(format, arg)
        End If
    End Sub

    Private Sub Write(ByVal format As String, ByVal ParamArray arg As Object())
        If m_Verbose Then
            Console.Write(format, arg)
        End If
    End Sub

End Class
