Imports System
Imports System.Collections
Imports System.EnterpriseServices
Imports System.IO
Imports System.Text
Imports System.Text.RegularExpressions

Public Class AssemblyHelper
   Private m_FileInfo As FileInfo
   Private m_LocalAssembly As System.Reflection.Assembly
   Private m_ApplicationName As String
   Private m_AssemblyName As String
   Private m_ComPlusComponents As String()
   Private m_FullName As String

   Public Sub New(ByVal assemblyFileName As String)
      m_FileInfo = New FileInfo(assemblyFileName)
      m_LocalAssembly = Reflection.Assembly.LoadFrom(m_FileInfo.FullName)
      m_AssemblyName = m_LocalAssembly.GetName.Name
      m_FullName = m_LocalAssembly.FullName
      Dim attributes As Object() = m_LocalAssembly.GetCustomAttributes( _
            GetType(ApplicationNameAttribute), False)
      If Not (attributes.Length = 1) Then
         m_ApplicationName = m_AssemblyName
      Else
         Dim nameAttribute As ApplicationNameAttribute = _
               CType(attributes(0), ApplicationNameAttribute)
         m_ApplicationName = nameAttribute.Value
      End If
      Dim list As ArrayList = New ArrayList(10)
      Dim exported As Type() = m_LocalAssembly.GetExportedTypes
      For Each t As Type In exported
         Dim isServicedComponent As Boolean
         isServicedComponent = t.IsSubclassOf(GetType(ServicedComponent))
         If isServicedComponent AndAlso Not t.IsAbstract Then
            list.Add(t.ToString)
         End If
      Next
      Dim i As Integer = 0
      m_ComPlusComponents = New String(list.Count - 1) {}
      For Each o As Object In list
         m_ComPlusComponents(i) = CType(o, String)
         i += 1
      Next
   End Sub

   Public ReadOnly Property FullFileName() As String
      Get
         Return m_FileInfo.FullName
      End Get
   End Property

   Public ReadOnly Property FullName() As String
      Get
         Return m_FullName
      End Get
   End Property

   Public ReadOnly Property FileName() As String
      Get
         Return m_FileInfo.Name
      End Get
   End Property

   Public ReadOnly Property AssemblyName() As String
      Get
         Return m_AssemblyName
      End Get
   End Property

   Public ReadOnly Property ComPlusApplicationName() As String
      Get
         Return m_ApplicationName
      End Get
   End Property

   Public Function GetComPlusComponents() As String()
      Dim list As ArrayList = New ArrayList(10)
      Dim exported As Type() = m_LocalAssembly.GetExportedTypes
      For Each t As Type In exported
         Dim isServicedComponent As Boolean
         isServicedComponent = t.IsSubclassOf(GetType(ServicedComponent))
         If isServicedComponent AndAlso Not t.IsAbstract Then
            list.Add(t.ToString)
         End If
      Next
      Dim array As String() = New String(list.Count - 1) {}
      Dim i As Integer = 0
      For Each o As Object In list
         array(i) = CType(o, String)
      Next
      Return array
   End Function
End Class

