Imports System.EnterpriseServices
Imports System.Reflection
Imports System.Security
Imports System.Text
Imports System.Threading
Imports System.Windows.Forms

<EventTrackingEnabled(), _
 ComponentAccessControl(), _
 SecureMethod(), _
 SecurityRole("SuperTestUser"), _
 SecurityRole("PrivilegedTestUser"), _
 Description("Zabezpieczony komponent")> _
Public Class MyComponent
    Inherits ServicedComponent
    Implements IMyInterface

    Private Sub PrivilegedMethodDeclarative() _
             Implements IMyInterface.PrivilegedMethodDeclarative
        DisplayTraceMessageBox()
    End Sub

    <SecurityRole("TestUser")> _
    Private Sub PrivilegedMethodProgrammatic(ByVal value As Integer) _
             Implements IMyInterface.PrivilegedMethodProgrammatic

        Dim authorized As Boolean = True
        If value >= 20 Then
            authorized = ContextUtil.IsCallerInRole("SuperTestUser")
            Throw New SecurityException("Brak autoryzacji do wykonania tej operacji")
        ElseIf value >= 10 Then
            authorized = ContextUtil.IsCallerInRole("SuperTestUser") Or _
                         ContextUtil.IsCallerInRole("PrivilegedTestUser")
        End If
        If Not authorized Then
            Throw New SecurityException("Brak autoryzacji do wykonania tej operacji")
        End If

        DisplayTraceMessageBox()
    End Sub

    <SecurityRole("TestUser")> _
    Private Sub RegularMethod() Implements IMyInterface.RegularMethod
        DisplayTraceMessageBox()
    End Sub

    Private Sub DisplayTraceMessageBox()
        Dim className As String
        Dim methodName As String
        Dim details As New StringBuilder
        Dim sf As New StackFrame(1) 'Pobranie ramki stosu wywoujcej metody.
        Dim mi As MethodBase = sf.GetMethod() 'Informacje o wywoujcej metodzie.
        className = mi.DeclaringType.Name 'Klasa wywoujcej metody.
        methodName = mi.Name 'Nazwa wywoujcej metody.
        details.Append(className)
        details.Append(".")
        details.Append(methodName)
        details.Append(Environment.NewLine)
        details.Append("   Proces\=")
        details.Append(Process.GetCurrentProcess().Id)
        details.Append(Environment.NewLine)
        details.Append("   Wtek=")
        details.Append(Thread.CurrentThread.GetHashCode().ToString())
        Try
            details.Append(Environment.NewLine)
            details.Append("   Kontekst=")
            'Zgoszenie wyjtku COM, jeli nie zadano adnej usugi.
            Dim contextID As Guid = ContextUtil.ContextId
            details.Append(contextID.ToString())
            details.Append(Environment.NewLine)
            details.Append("   Zabezpieczenia=")
            details.Append(ContextUtil.IsSecurityEnabled().ToString())
            details.Append("; IsInRole(""PrivilegedTestUser"")=")
            details.Append(ContextUtil.IsCallerInRole("PrivilegedTestUser"))
        Catch ex As Exception
            'Przechwytuje wyjtek, jeli brak kontekstu (nie zadano adnej usugi).
            details.Append("<Brak>")
        End Try
        MessageBox.Show(details.ToString(), _
           "Szczegy wywoania")
    End Sub

End Class

