Imports System.Diagnostics
Imports System.EnterpriseServices
Imports System.Reflection
Imports System.Runtime.InteropServices
Imports COMAdmin

Public Class TransientSubscriptionManager

   Public Shared Function Add( _
         ByVal eventClass As Type, _
         ByVal sinkInterface As Type, _
         ByVal subscriber As Object) As String


        'Sprawdzanie parametrw -> zapewnia bezpieczestwo ze wzgldu na typ.
        Debug.Assert(eventClass.IsClass()) 'eventClass musi by klas.
      Dim ecaType As Type = GetType(EventClassAttribute)
      Dim eca As Object() = eventClass.GetCustomAttributes(ecaType, True)
        Debug.Assert(eca.Length = 1) 'eventClass musi mie atrybut EventClassAttribute.
        Debug.Assert(sinkInterface.IsInterface()) 'Wymagany interfejs.
      Debug.Assert(sinkInterface.IsInstanceOfType(subscriber))
      Dim siName As String = sinkInterface.ToString()
      Dim siType As Type = eventClass.GetInterface(siName)
      Debug.Assert(Not siType Is Nothing)
      Debug.Assert(sinkInterface Is siType)

        'Dodawanie.
      Dim eventClassString As String = "{" + eventClass.GUID.ToString() + "}"
      Dim sinkIfString As String = "{" + sinkInterface.GUID.ToString() + "}"
      Return AddNotTypesafe(eventClassString, sinkIfString, "", _
         subscriber, "", "")

   End Function

   Public Shared Function AddNotTypesafe( _
         ByVal eventClassString As String, _
         ByVal sinkInterfaceString As String, _
         ByVal method As String, _
         ByVal subscriber As Object, _
         ByVal filterCriteria As String, _
         ByVal publisherId As String) As String

        'Pobranie katalogu.
      Dim catalog As ICOMAdminCatalog = New COMAdminCatalog

        'Pobranie kolekcji TransientSubscriptions
      Dim collection As Object
      Dim transientCollection As ICatalogCollection
      collection = catalog.GetCollection("TransientSubscriptions")
      transientCollection = CType(collection, ICatalogCollection)
      transientCollection.Populate()

        'Tworzenie nazwy subskrypcji.
      Dim subscriptionName As String = Guid.NewGuid().ToString()

        'Dodawanie subskrypcji.
      Dim subscription As ICatalogObject
      subscription = CType(transientCollection.Add(), ICatalogObject)
      subscription.Value("Name") = subscriptionName
      subscription.Value("SubscriberInterface") = subscriber
      subscription.Value("EventCLSID") = eventClassString
      subscription.Value("InterfaceID") = sinkInterfaceString
      subscription.Value("MethodName") = method
      subscription.Value("FilterCriteria") = filterCriteria
      subscription.Value("PublisherID") = publisherId
      transientCollection.SaveChanges()

        'Zwracanie nazwy nowoutworzonej subskrypcji.
      Return subscriptionName
   End Function

   Public Shared Sub Remove(ByVal subscriptionName As String)
      Debug.Assert(subscriptionName <> "")

        'Pobranie katalogu.
      Dim catalog As ICOMAdminCatalog = New COMAdminCatalog

        'Pobranie kolekcji TransientSubscriptions.
      Dim collection As Object
      Dim transientCollection As ICatalogCollection
      collection = catalog.GetCollection("TransientSubscriptions")
      transientCollection = CType(collection, ICatalogCollection)
      transientCollection.Populate()

        'Wyszukanie usuwanej subskrypcji.
      Dim index As Integer = 0
      For Each item As Object In transientCollection
         Dim subscription As ICatalogObject = CType(item, ICatalogObject)
         If subscription.Name.ToString() = subscriptionName Then
                'Metoda znalaza subskrypcj -> usuwa j.
            transientCollection.Remove(index)
            transientCollection.SaveChanges()
            Exit For
         End If
         index += 1
      Next
   End Sub

End Class
