Imports System.Runtime.Remoting
Imports System.Runtime.Remoting.Channels
Imports System.Runtime.Remoting.Channels.Tcp
Imports System.Runtime.Remoting.Channels.Http

Public Class MainWindow
   Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

   Public Sub New()
      MyBase.New()

      'This call is required by the Windows Form Designer.
      InitializeComponent()

      'Add any initialization after the InitializeComponent() call

   End Sub

   'Form overrides dispose to clean up the component list.
   Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
      If disposing Then
         If Not (components Is Nothing) Then
            components.Dispose()
         End If
      End If
      MyBase.Dispose(disposing)
   End Sub

   'Required by the Windows Form Designer
   Private components As System.ComponentModel.IContainer

   'NOTE: The following procedure is required by the Windows Form Designer
   'It can be modified using the Windows Form Designer.  
   'Do not modify it using the code editor.
   Friend WithEvents m_rbSingleton As System.Windows.Forms.RadioButton
   Friend WithEvents m_rbSingleCall As System.Windows.Forms.RadioButton
   Friend WithEvents m_btnRegister As System.Windows.Forms.Button
   Friend WithEvents m_rbClientActivated As System.Windows.Forms.RadioButton
   Friend WithEvents m_grpActivationMode As System.Windows.Forms.GroupBox
   Friend WithEvents m_grpChannelType As System.Windows.Forms.GroupBox
   Friend WithEvents m_rbTCP As System.Windows.Forms.RadioButton
   Friend WithEvents m_rbHTTP As System.Windows.Forms.RadioButton
   <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.m_rbSingleton = New System.Windows.Forms.RadioButton
        Me.m_rbSingleCall = New System.Windows.Forms.RadioButton
        Me.m_btnRegister = New System.Windows.Forms.Button
        Me.m_rbClientActivated = New System.Windows.Forms.RadioButton
        Me.m_grpActivationMode = New System.Windows.Forms.GroupBox
        Me.m_grpChannelType = New System.Windows.Forms.GroupBox
        Me.m_rbTCP = New System.Windows.Forms.RadioButton
        Me.m_rbHTTP = New System.Windows.Forms.RadioButton
        Me.m_grpChannelType.SuspendLayout()
        Me.SuspendLayout()
        '
        'm_rbSingleton
        '
        Me.m_rbSingleton.Checked = True
        Me.m_rbSingleton.Location = New System.Drawing.Point(144, 24)
        Me.m_rbSingleton.Name = "m_rbSingleton"
        Me.m_rbSingleton.Size = New System.Drawing.Size(112, 32)
        Me.m_rbSingleton.TabIndex = 2
        Me.m_rbSingleton.TabStop = True
        Me.m_rbSingleton.Text = "Singleton"
        '
        'm_rbSingleCall
        '
        Me.m_rbSingleCall.Location = New System.Drawing.Point(144, 56)
        Me.m_rbSingleCall.Name = "m_rbSingleCall"
        Me.m_rbSingleCall.Size = New System.Drawing.Size(112, 32)
        Me.m_rbSingleCall.TabIndex = 3
        Me.m_rbSingleCall.Text = "Na czas jednego wywoania"
        '
        'm_btnRegister
        '
        Me.m_btnRegister.DialogResult = System.Windows.Forms.DialogResult.OK
        Me.m_btnRegister.Location = New System.Drawing.Point(24, 144)
        Me.m_btnRegister.Name = "m_btnRegister"
        Me.m_btnRegister.Size = New System.Drawing.Size(232, 23)
        Me.m_btnRegister.TabIndex = 5
        Me.m_btnRegister.Text = "Rejestracja"
        '
        'm_rbClientActivated
        '
        Me.m_rbClientActivated.Location = New System.Drawing.Point(144, 88)
        Me.m_rbClientActivated.Name = "m_rbClientActivated"
        Me.m_rbClientActivated.Size = New System.Drawing.Size(112, 32)
        Me.m_rbClientActivated.TabIndex = 4
        Me.m_rbClientActivated.Text = "Aktywacja przez klienta"
        '
        'm_grpActivationMode
        '
        Me.m_grpActivationMode.Location = New System.Drawing.Point(128, 8)
        Me.m_grpActivationMode.Name = "m_grpActivationMode"
        Me.m_grpActivationMode.Size = New System.Drawing.Size(136, 120)
        Me.m_grpActivationMode.TabIndex = 4
        Me.m_grpActivationMode.TabStop = False
        Me.m_grpActivationMode.Text = "Tryb aktywacji"
        '
        'm_grpChannelType
        '
        Me.m_grpChannelType.Controls.Add(Me.m_rbTCP)
        Me.m_grpChannelType.Controls.Add(Me.m_rbHTTP)
        Me.m_grpChannelType.Location = New System.Drawing.Point(16, 8)
        Me.m_grpChannelType.Name = "m_grpChannelType"
        Me.m_grpChannelType.Size = New System.Drawing.Size(96, 120)
        Me.m_grpChannelType.TabIndex = 6
        Me.m_grpChannelType.TabStop = False
        Me.m_grpChannelType.Text = "Typ kanau"
        '
        'm_rbTCP
        '
        Me.m_rbTCP.Checked = True
        Me.m_rbTCP.Location = New System.Drawing.Point(8, 16)
        Me.m_rbTCP.Name = "m_rbTCP"
        Me.m_rbTCP.Size = New System.Drawing.Size(64, 24)
        Me.m_rbTCP.TabIndex = 0
        Me.m_rbTCP.TabStop = True
        Me.m_rbTCP.Text = "TCP"
        '
        'm_rbHTTP
        '
        Me.m_rbHTTP.Location = New System.Drawing.Point(8, 40)
        Me.m_rbHTTP.Name = "m_rbHTTP"
        Me.m_rbHTTP.Size = New System.Drawing.Size(64, 24)
        Me.m_rbHTTP.TabIndex = 1
        Me.m_rbHTTP.Text = "HTTP"
        '
        'MainWindow
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(312, 181)
        Me.Controls.Add(Me.m_grpChannelType)
        Me.Controls.Add(Me.m_rbClientActivated)
        Me.Controls.Add(Me.m_btnRegister)
        Me.Controls.Add(Me.m_rbSingleton)
        Me.Controls.Add(Me.m_rbSingleCall)
        Me.Controls.Add(Me.m_grpActivationMode)
        Me.Name = "MainWindow"
        Me.Text = "Serwer konfigurowany programowo"
        Me.m_grpChannelType.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region

   Private m_Channel As IChannel

   Private Sub MainWindow_Closing(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing
      If Not m_Channel Is Nothing Then
         ChannelServices.UnregisterChannel(m_Channel)
      End If
   End Sub

   Private Sub btnRegister_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRegister.Click
      If m_rbTCP.Checked Then
         m_Channel = New TcpChannel(8015)
         ChannelServices.RegisterChannel(m_Channel)
      Else
         m_Channel = New HttpChannel(8015)
         ChannelServices.RegisterChannel(m_Channel)
      End If

      Dim serverType As Type
      serverType = GetType(TestLibrary.TestClass)

      If m_rbSingleton.Checked Then
         RemotingConfiguration.RegisterWellKnownServiceType(serverType, _
            "TestService", WellKnownObjectMode.Singleton)
      ElseIf m_rbSingleCall.Checked Then
         RemotingConfiguration.RegisterWellKnownServiceType(serverType, _
            "TestService", WellKnownObjectMode.SingleCall)
      Else
         RemotingConfiguration.RegisterActivatedServiceType(serverType)
      End If

      m_rbTCP.Enabled = False
      m_rbHTTP.Enabled = False
      m_rbSingleCall.Enabled = False
      m_rbSingleton.Enabled = False
      m_rbClientActivated.Enabled = False
      m_btnRegister.Enabled = False
   End Sub
End Class
