Imports System.Runtime.Remoting
Imports System.Runtime.Remoting.Channels
Imports System.Runtime.Remoting.Channels.Tcp
Imports System.Runtime.Remoting.Channels.Http

Imports TestLibrary

Public Class MainWindow
   Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

   Public Sub New()
      MyBase.New()

      'This call is required by the Windows Form Designer.
      InitializeComponent()

      'Add any initialization after the InitializeComponent() call

   End Sub

   'Form overrides dispose to clean up the component list.
   Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
      If disposing Then
         If Not (components Is Nothing) Then
            components.Dispose()
         End If
      End If
      MyBase.Dispose(disposing)
   End Sub

   'Required by the Windows Form Designer
   Private components As System.ComponentModel.IContainer

   'NOTE: The following procedure is required by the Windows Form Designer
   'It can be modified using the Windows Form Designer.  
   'Do not modify it using the code editor.
   Friend WithEvents m_grpChannelType As System.Windows.Forms.GroupBox
   Friend WithEvents m_rbTCP As System.Windows.Forms.RadioButton
   Friend WithEvents m_rbHTTP As System.Windows.Forms.RadioButton
   Friend WithEvents m_rbClientActivated As System.Windows.Forms.RadioButton
   Friend WithEvents m_btnRegister As System.Windows.Forms.Button
   Friend WithEvents m_rbServerActivated As System.Windows.Forms.RadioButton
   Friend WithEvents m_grpActivationMode As System.Windows.Forms.GroupBox
   Friend WithEvents m_btnTest As System.Windows.Forms.Button
   <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.m_grpChannelType = New System.Windows.Forms.GroupBox
        Me.m_rbTCP = New System.Windows.Forms.RadioButton
        Me.m_rbHTTP = New System.Windows.Forms.RadioButton
        Me.m_rbClientActivated = New System.Windows.Forms.RadioButton
        Me.m_btnRegister = New System.Windows.Forms.Button
        Me.m_rbServerActivated = New System.Windows.Forms.RadioButton
        Me.m_grpActivationMode = New System.Windows.Forms.GroupBox
        Me.m_btnTest = New System.Windows.Forms.Button
        Me.m_grpChannelType.SuspendLayout()
        Me.SuspendLayout()
        '
        'm_grpChannelType
        '
        Me.m_grpChannelType.Controls.Add(Me.m_rbTCP)
        Me.m_grpChannelType.Controls.Add(Me.m_rbHTTP)
        Me.m_grpChannelType.Location = New System.Drawing.Point(16, 8)
        Me.m_grpChannelType.Name = "m_grpChannelType"
        Me.m_grpChannelType.Size = New System.Drawing.Size(96, 96)
        Me.m_grpChannelType.TabIndex = 12
        Me.m_grpChannelType.TabStop = False
        Me.m_grpChannelType.Text = "Typ kanau"
        '
        'm_rbTCP
        '
        Me.m_rbTCP.Checked = True
        Me.m_rbTCP.Location = New System.Drawing.Point(8, 16)
        Me.m_rbTCP.Name = "m_rbTCP"
        Me.m_rbTCP.Size = New System.Drawing.Size(64, 24)
        Me.m_rbTCP.TabIndex = 0
        Me.m_rbTCP.TabStop = True
        Me.m_rbTCP.Text = "TCP"
        '
        'm_rbHTTP
        '
        Me.m_rbHTTP.Location = New System.Drawing.Point(8, 40)
        Me.m_rbHTTP.Name = "m_rbHTTP"
        Me.m_rbHTTP.Size = New System.Drawing.Size(64, 24)
        Me.m_rbHTTP.TabIndex = 1
        Me.m_rbHTTP.Text = "HTTP"
        '
        'm_rbClientActivated
        '
        Me.m_rbClientActivated.Location = New System.Drawing.Point(144, 64)
        Me.m_rbClientActivated.Name = "m_rbClientActivated"
        Me.m_rbClientActivated.Size = New System.Drawing.Size(104, 32)
        Me.m_rbClientActivated.TabIndex = 10
        Me.m_rbClientActivated.Text = "Aktywacja przez klienta"
        '
        'm_btnRegister
        '
        Me.m_btnRegister.DialogResult = System.Windows.Forms.DialogResult.OK
        Me.m_btnRegister.Location = New System.Drawing.Point(16, 120)
        Me.m_btnRegister.Name = "m_btnRegister"
        Me.m_btnRegister.Size = New System.Drawing.Size(248, 23)
        Me.m_btnRegister.TabIndex = 11
        Me.m_btnRegister.Text = "Rejestracja"
        '
        'm_rbServerActivated
        '
        Me.m_rbServerActivated.Checked = True
        Me.m_rbServerActivated.Location = New System.Drawing.Point(144, 24)
        Me.m_rbServerActivated.Name = "m_rbServerActivated"
        Me.m_rbServerActivated.Size = New System.Drawing.Size(112, 32)
        Me.m_rbServerActivated.TabIndex = 7
        Me.m_rbServerActivated.TabStop = True
        Me.m_rbServerActivated.Text = "Aktywacja przez serwer"
        '
        'm_grpActivationMode
        '
        Me.m_grpActivationMode.Location = New System.Drawing.Point(128, 8)
        Me.m_grpActivationMode.Name = "m_grpActivationMode"
        Me.m_grpActivationMode.Size = New System.Drawing.Size(136, 96)
        Me.m_grpActivationMode.TabIndex = 9
        Me.m_grpActivationMode.TabStop = False
        Me.m_grpActivationMode.Text = "Tryb aktywacji"
        '
        'm_btnTest
        '
        Me.m_btnTest.Enabled = False
        Me.m_btnTest.Location = New System.Drawing.Point(16, 160)
        Me.m_btnTest.Name = "m_btnTest"
        Me.m_btnTest.Size = New System.Drawing.Size(248, 23)
        Me.m_btnTest.TabIndex = 13
        Me.m_btnTest.Text = "Test"
        '
        'MainWindow
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(286, 205)
        Me.Controls.Add(Me.m_btnTest)
        Me.Controls.Add(Me.m_grpChannelType)
        Me.Controls.Add(Me.m_rbClientActivated)
        Me.Controls.Add(Me.m_btnRegister)
        Me.Controls.Add(Me.m_rbServerActivated)
        Me.Controls.Add(Me.m_grpActivationMode)
        Me.Name = "MainWindow"
        Me.Text = "Klient konfigurowany programowo"
        Me.m_grpChannelType.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region

   Private m_Channel As IChannel

   Private Sub btnRegister_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnRegister.Click
      Dim url As String
      If m_rbTCP.Checked Then
         m_Channel = New TcpChannel(0)
         ChannelServices.RegisterChannel(m_Channel)
         url = "tcp://localhost:8015"
      Else
         m_Channel = New HttpChannel(0)
         ChannelServices.RegisterChannel(m_Channel)
         url = "http://localhost:8015"
      End If
      Dim serverType As Type
      serverType = GetType(TestClass)
      If m_rbServerActivated.Checked Then
         url += "/TestService"
         RemotingConfiguration.RegisterWellKnownClientType(serverType, url)
      Else
         RemotingConfiguration.RegisterActivatedClientType(serverType, url)
      End If
      m_rbTCP.Enabled = False
      m_rbHTTP.Enabled = False
      m_rbServerActivated.Enabled = False
      m_rbClientActivated.Enabled = False
      m_btnRegister.Enabled = False
      m_btnTest.Enabled = True
   End Sub

   Private Sub MainWindow_Closing(ByVal sender As Object, ByVal e As _
   System.ComponentModel.CancelEventArgs) Handles MyBase.Closing
      If Not m_Channel Is Nothing Then
         ChannelServices.UnregisterChannel(m_Channel)
      End If
   End Sub

   Private Sub m_btnTest_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnTest.Click
      Dim test As TestClass
      test = New TestClass
      test.TestMethod()
      test.TestMethod()
   End Sub
End Class
