Imports System.Runtime.Remoting
Imports TestLibrary
Imports UniversalSponsor

Public Class MainWindow
   Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

   Public Sub New()
      MyBase.New()

      'This call is required by the Windows Form Designer.
      InitializeComponent()

      'Add any initialization after the InitializeComponent() call

   End Sub

   'Form overrides dispose to clean up the component list.
   Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
      If disposing Then
         If Not (components Is Nothing) Then
            components.Dispose()
         End If
      End If
      MyBase.Dispose(disposing)
   End Sub

   'Required by the Windows Form Designer
   Private components As System.ComponentModel.IContainer

   'NOTE: The following procedure is required by the Windows Form Designer
   'It can be modified using the Windows Form Designer.  
   'Do not modify it using the code editor.
   Friend WithEvents m_btnTest As System.Windows.Forms.Button
   Friend WithEvents m_btnNew As System.Windows.Forms.Button
   Friend WithEvents m_btnCall As System.Windows.Forms.Button
   Friend WithEvents m_btnRelease As System.Windows.Forms.Button
   <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.m_btnTest = New System.Windows.Forms.Button
        Me.m_btnNew = New System.Windows.Forms.Button
        Me.m_btnCall = New System.Windows.Forms.Button
        Me.m_btnRelease = New System.Windows.Forms.Button
        Me.SuspendLayout()
        '
        'm_btnTest
        '
        Me.m_btnTest.Location = New System.Drawing.Point(24, 16)
        Me.m_btnTest.Name = "m_btnTest"
        Me.m_btnTest.Size = New System.Drawing.Size(256, 23)
        Me.m_btnTest.TabIndex = 15
        Me.m_btnTest.Text = "Test"
        '
        'm_btnNew
        '
        Me.m_btnNew.Location = New System.Drawing.Point(24, 72)
        Me.m_btnNew.Name = "m_btnNew"
        Me.m_btnNew.Size = New System.Drawing.Size(80, 23)
        Me.m_btnNew.TabIndex = 16
        Me.m_btnNew.Text = "Nowy obiekt"
        '
        'm_btnCall
        '
        Me.m_btnCall.Location = New System.Drawing.Point(112, 72)
        Me.m_btnCall.Name = "m_btnCall"
        Me.m_btnCall.Size = New System.Drawing.Size(80, 23)
        Me.m_btnCall.TabIndex = 17
        Me.m_btnCall.Text = "Wywoaj"
        '
        'm_btnRelease
        '
        Me.m_btnRelease.Location = New System.Drawing.Point(200, 72)
        Me.m_btnRelease.Name = "m_btnRelease"
        Me.m_btnRelease.Size = New System.Drawing.Size(80, 23)
        Me.m_btnRelease.TabIndex = 18
        Me.m_btnRelease.Text = "Zwolnij"
        '
        'MainWindow
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(312, 61)
        Me.Controls.Add(Me.m_btnRelease)
        Me.Controls.Add(Me.m_btnCall)
        Me.Controls.Add(Me.m_btnNew)
        Me.Controls.Add(Me.m_btnTest)
        Me.Name = "MainWindow"
        Me.Text = "Klient konfigurowany deklaratywnie"
        Me.ResumeLayout(False)

    End Sub

#End Region

   Private m_Sponsor As Sponsor
   Private m_Object As TestClass
   Private m_UpdateHandler As TestEventHandler

   Private Sub MainWindow_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
      m_Sponsor = New Sponsor
      AddHandler Application.ApplicationExit, AddressOf OnExit
      RemotingConfiguration.Configure("RemoteClient.config")
      m_UpdateHandler = New TestEventHandler
   End Sub

   Private Sub OnExit(ByVal sender As System.Object, ByVal e As System.EventArgs)
      If Not m_Sponsor Is Nothing Then
         Dim disp As IDisposable = CType(m_Sponsor, IDisposable)
         If Not disp Is Nothing Then
            disp.Dispose()
         End If
      End If
   End Sub

   Private Sub btnTest_Click(ByVal sender As System.Object, _
         ByVal e As System.EventArgs) Handles m_btnTest.Click
      Dim test As TestClass
      test = New TestClass
      test.TestMethod()
      test.TestMethod()
   End Sub

   Private Sub btnNew_Click(ByVal sender As System.Object, _
         ByVal e As System.EventArgs) Handles m_btnNew.Click
      If m_Object Is Nothing Then
         Try
            m_Object = New TestClass
            m_Sponsor.Register(m_Object)
            AddHandler m_Object.UpdateEvent, _
               AddressOf m_UpdateHandler.UpdateHandler
         Catch ex As Exception
            MessageBox.Show(ex.ToString())
         End Try
      End If
   End Sub

   Private Sub btnCall_Click(ByVal sender As System.Object, _
         ByVal e As System.EventArgs) Handles m_btnCall.Click
      m_Object.TestMethod()
   End Sub

   Private Sub btnRelease_Click(ByVal sender As System.Object, _
         ByVal e As System.EventArgs) Handles m_btnRelease.Click
      RemoveHandler m_Object.UpdateEvent, _
         AddressOf m_UpdateHandler.UpdateHandler
      m_Sponsor.Unregister(m_Object)
      m_Object = Nothing
   End Sub
End Class
