Imports System.Security
Imports System.Security.Permissions
Imports System.Security.Principal
Imports System.Threading

<PrincipalPermission(SecurityAction.Demand, _
                     Role:="TestUser")> _
Public Class MyTestClass

   Public Sub New()
   End Sub

   Public Sub RegularMethod()
   End Sub

   <PrincipalPermission(SecurityAction.Demand, _
                        Role:="PrivilegedTestUser")> _
   Public Sub PrivilegedMethodDeclarative()
        MessageBox.Show("Deklaratywne zabezpieczanie", "Metoda uprzywilejowana")
   End Sub

   Public Sub PrivilegedMethodProgrammatic(ByVal value As Integer)
      If value >= 20 Then
         Dim authorized As Boolean
         Dim principal As IPrincipal = Thread.CurrentPrincipal()
         authorized = principal.IsInRole("SuperTestUser")
         If Not authorized Then
                Throw New SecurityException("Brak autoryzacji do wykonania tej operacji")
         End If
      ElseIf value >= 10 Then
         Dim permission As IPermission = New PrincipalPermission(Nothing, _
                                              "PrivilegedTestUser")
         permission.Demand()
      End If
        MessageBox.Show("Programowo: Warto = " + value.ToString(), _
                      "Metoda uprzywilejowana")
   End Sub


End Class
