Imports System.Runtime.Serialization
<Serializable()> _
Public Class Customer
    Implements ISerializable
    Private _id As Integer
    Private _name As String
    Public CreditLimit As Double

    Public Sub New(ByVal Id As Integer, ByVal Name As String)
        _id = Id
        _name = Name
        CreditLimit = 0.0
    End Sub

    Public Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
        _id = info.GetInt32("_id")
        _name = info.GetString("_name")
        CreditLimit = info.GetDouble("CreditLimit")
    End Sub

    Public Sub GetObjectData(ByVal info As SerializationInfo, ByVal context As StreamingContext) _
                Implements ISerializable.GetObjectData
        info.AddValue("_id", _id)
        info.AddValue("_name", _name)
        info.AddValue("CreditLimit", CreditLimit)
    End Sub

    Public ReadOnly Property Id() As Integer
        Get
            Return _id
        End Get
    End Property

    Public ReadOnly Property Name() As String
        Get
            Return _name
        End Get
    End Property
End Class
