Imports System.ComponentModel
Imports System.Web.UI

Public Class TabControl
  Inherits System.Web.UI.WebControls.WebControl
  Implements IPostBackEventHandler

  <Bindable(True), Category("Appearance"), DefaultValue("")> Property SelectedTab() As Integer
    Get
      Return CType(Viewstate("TabIndex"), Integer)
    End Get

    Set(ByVal Value As Integer)
      Viewstate("TabIndex") = CType(Value, Integer)
    End Set
  End Property

  Public Sub RaisePostBackEvent(ByVal eventArgument As String) Implements System.Web.UI.IPostBackEventHandler.RaisePostBackEvent
    Viewstate("TabIndex") = CType(eventArgument, Int32)
  End Sub

  Protected Overrides Sub Render(ByVal output As System.Web.UI.HtmlTextWriter)
    output.Write("<table border=1 width=300><tr>")
    output.Write("<td><a id=""" & Me.UniqueID & """ href=""javascript:" & _
        Page.GetPostBackEventReference(Me, 1) & """>A</a></td>")
    output.Write("<td><a id=""" & Me.UniqueID & """ href=""javascript:" & _
        Page.GetPostBackEventReference(Me, 2) & """>A</a></td>")
    output.Write("<td><a id=""" & Me.UniqueID & """ href=""javascript:" & _
        Page.GetPostBackEventReference(Me, 3) & """>A</a></td>")
    output.Write("</tr><tr><td colspan=3>")

    Select Case viewstate("TabIndex")
      Case 1
        output.Write("<input type=submit value='A'>")
      Case 2
        output.Write("<input type=submit value='B'>")
      Case 3
        output.Write("<input type=submit value='C'>")
    End Select

    output.Write("</td></tr></table>")
  End Sub

End Class
