Public Class frmMain
  Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call

  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.IContainer

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  Friend WithEvents grdProducts As System.Windows.Forms.DataGrid
  Friend WithEvents chkLoadSchema As System.Windows.Forms.CheckBox
  Friend WithEvents txtOutputFile As System.Windows.Forms.TextBox
  Friend WithEvents btnWriteSchemaToFile As System.Windows.Forms.Button
  Friend WithEvents btnLoadData As System.Windows.Forms.Button
  Friend WithEvents chkSortOnUnitsInStock As System.Windows.Forms.CheckBox
  Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
  Friend WithEvents mnuFile As System.Windows.Forms.MenuItem
  Friend WithEvents mnuFile_Exit As System.Windows.Forms.MenuItem
  Friend WithEvents mnuHelp As System.Windows.Forms.MenuItem
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.btnLoadData = New System.Windows.Forms.Button
    Me.grdProducts = New System.Windows.Forms.DataGrid
    Me.chkLoadSchema = New System.Windows.Forms.CheckBox
    Me.btnWriteSchemaToFile = New System.Windows.Forms.Button
    Me.txtOutputFile = New System.Windows.Forms.TextBox
    Me.chkSortOnUnitsInStock = New System.Windows.Forms.CheckBox
    Me.MainMenu1 = New System.Windows.Forms.MainMenu
    Me.mnuFile = New System.Windows.Forms.MenuItem
    Me.mnuFile_Exit = New System.Windows.Forms.MenuItem
    Me.mnuHelp = New System.Windows.Forms.MenuItem
    CType(Me.grdProducts, System.ComponentModel.ISupportInitialize).BeginInit()
    Me.SuspendLayout()
    '
    'btnLoadData
    '
    Me.btnLoadData.Location = New System.Drawing.Point(16, 16)
    Me.btnLoadData.Name = "btnLoadData"
    Me.btnLoadData.Size = New System.Drawing.Size(72, 23)
    Me.btnLoadData.TabIndex = 0
    Me.btnLoadData.Text = "aduj dane"
    '
    'grdProducts
    '
    Me.grdProducts.DataMember = ""
    Me.grdProducts.HeaderForeColor = System.Drawing.SystemColors.ControlText
    Me.grdProducts.Location = New System.Drawing.Point(16, 56)
    Me.grdProducts.Name = "grdProducts"
    Me.grdProducts.Size = New System.Drawing.Size(456, 168)
    Me.grdProducts.TabIndex = 2
    '
    'chkLoadSchema
    '
    Me.chkLoadSchema.Location = New System.Drawing.Point(104, 16)
    Me.chkLoadSchema.Name = "chkLoadSchema"
    Me.chkLoadSchema.Size = New System.Drawing.Size(352, 24)
    Me.chkLoadSchema.TabIndex = 1
    Me.chkLoadSchema.Text = "Odczyt zewntrznego schematu przed zaadowaniem danych"
    '
    'btnWriteSchemaToFile
    '
    Me.btnWriteSchemaToFile.Location = New System.Drawing.Point(13, 288)
    Me.btnWriteSchemaToFile.Name = "btnWriteSchemaToFile"
    Me.btnWriteSchemaToFile.Size = New System.Drawing.Size(200, 23)
    Me.btnWriteSchemaToFile.TabIndex = 4
    Me.btnWriteSchemaToFile.Text = "Zapis biecego schematu do pliku:"
    '
    'txtOutputFile
    '
    Me.txtOutputFile.Location = New System.Drawing.Point(216, 288)
    Me.txtOutputFile.Name = "txtOutputFile"
    Me.txtOutputFile.Size = New System.Drawing.Size(248, 20)
    Me.txtOutputFile.TabIndex = 5
    Me.txtOutputFile.Text = "dsProduct_OUT.xsd"
    '
    'chkSortOnUnitsInStock
    '
    Me.chkSortOnUnitsInStock.Location = New System.Drawing.Point(184, 240)
    Me.chkSortOnUnitsInStock.Name = "chkSortOnUnitsInStock"
    Me.chkSortOnUnitsInStock.Size = New System.Drawing.Size(232, 24)
    Me.chkSortOnUnitsInStock.TabIndex = 3
    Me.chkSortOnUnitsInStock.Text = "Sortowanie wg. UnitsInStock"
    '
    'MainMenu1
    '
    Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile, Me.mnuHelp})
    '
    'mnuFile
    '
    Me.mnuFile.Index = 0
    Me.mnuFile.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile_Exit})
    Me.mnuFile.Text = "&Plik"
    '
    'mnuFile_Exit
    '
    Me.mnuFile_Exit.Index = 0
    Me.mnuFile_Exit.Text = "&Koniec"
    '
    'mnuHelp
    '
    Me.mnuHelp.Index = 1
    Me.mnuHelp.Text = "Po&moc"
    '
    'frmMain
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(488, 322)
    Me.Controls.Add(Me.chkSortOnUnitsInStock)
    Me.Controls.Add(Me.txtOutputFile)
    Me.Controls.Add(Me.btnWriteSchemaToFile)
    Me.Controls.Add(Me.chkLoadSchema)
    Me.Controls.Add(Me.grdProducts)
    Me.Controls.Add(Me.btnLoadData)
    Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.Fixed3D
    Me.Menu = Me.MainMenu1
    Me.Name = "frmMain"
    Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
    Me.Text = "Metody ReadXmlSchema WriteXmlSchema"
    CType(Me.grdProducts, System.ComponentModel.ISupportInitialize).EndInit()
    Me.ResumeLayout(False)

  End Sub

#End Region

  Dim objdsProduct As DataSet

  Private Sub btnLoadData_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnLoadData.Click
    LoadData()
    SortData()
    SetBindings()
  End Sub

  Private Function LoadData() As Boolean
    objdsProduct = Nothing        'Kasowanie istniejcej wersji
    objdsProduct = New DataSet    'Tworzenie nowego obiektu DataSet

    'Opcjonalne adowanie zewntrznego pliku schematu
    Try
      If Me.chkLoadSchema.Checked Then
        objdsProduct.ReadXmlSchema("..\dsProduct.xsd")
      End If
    Catch ex As Exception
      MessageBox.Show(ex.Message)
      Return False
    End Try

    'Wypenienie obiektu DataSet
    Try
      objdsProduct.ReadXml("Products.xml")
    Catch ex As Exception
      MessageBox.Show(ex.Message)
    End Try
    Return True

  End Function

  Private Function SetBindings() As Boolean
    'Clear any existing bindings
    Me.grdProducts.DataSource = Nothing
    Try
      Me.grdProducts.DataSource = objdsProduct.Tables("Product")
    Catch ex As Exception
      MessageBox.Show(ex.Message)
      Return False
    End Try
    Return True
  End Function

  Private Sub btnWriteSchemaToFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnWriteSchemaToFile.Click
    'Write the schema that ADO.NET finds in the DataSet
    objdsProduct.WriteXmlSchema(Me.txtOutputFile.Text)
    MessageBox.Show("File " & Me.txtOutputFile.Text & " written to bin folder.")
  End Sub

  Private Sub btnSetBindings_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
    SetBindings()
  End Sub

  Private Sub chkSortOnUnitsInStock_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkSortOnUnitsInStock.CheckedChanged
    SortData()
  End Sub

  Private Sub SortData()
    If chkSortOnUnitsInStock.Checked Then
      objdsProduct.Tables("Product").DefaultView.Sort = "UnitsInStock"
    Else
      objdsProduct.Tables("Product").DefaultView.Sort = ""
    End If
  End Sub

  Private Sub mnuFile_Exit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuFile_Exit.Click
    Me.Close()
  End Sub

  Private Sub mnuHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuHelp.Click
    Dim frmHelp As New frmHelp("..\zzReadMe.txt")
    frmHelp.Show()
  End Sub
End Class
