Imports System.Xml
Imports System.Data
Imports System.Data.SqlClient
Imports System.IO
Imports System.ComponentModel.Design.HelpContextType
Imports System.Runtime.Remoting.Contexts

Public Class frmMain
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents btnFillSchema As System.Windows.Forms.Button
    Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents radSchemaType_Mapped As System.Windows.Forms.RadioButton
    Friend WithEvents radSchemaType_Source As System.Windows.Forms.RadioButton
    Friend WithEvents txtOutput As System.Windows.Forms.TextBox
    Friend WithEvents txtCommandText As System.Windows.Forms.TextBox
    Friend WithEvents cboQuery As System.Windows.Forms.ComboBox
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents txtTargetXmlDatafile As System.Windows.Forms.TextBox
    Friend WithEvents btnWriteXmlDataFile As System.Windows.Forms.Button
    Friend WithEvents mnuMain As System.Windows.Forms.MainMenu
    Friend WithEvents mnuFile As System.Windows.Forms.MenuItem
    Friend WithEvents mnuExit As System.Windows.Forms.MenuItem
    Friend WithEvents mnuHelp As System.Windows.Forms.MenuItem
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.btnFillSchema = New System.Windows.Forms.Button
    Me.GroupBox1 = New System.Windows.Forms.GroupBox
    Me.radSchemaType_Source = New System.Windows.Forms.RadioButton
    Me.radSchemaType_Mapped = New System.Windows.Forms.RadioButton
    Me.txtOutput = New System.Windows.Forms.TextBox
    Me.txtCommandText = New System.Windows.Forms.TextBox
    Me.cboQuery = New System.Windows.Forms.ComboBox
    Me.Label2 = New System.Windows.Forms.Label
    Me.Label1 = New System.Windows.Forms.Label
    Me.txtTargetXmlDatafile = New System.Windows.Forms.TextBox
    Me.btnWriteXmlDataFile = New System.Windows.Forms.Button
    Me.mnuMain = New System.Windows.Forms.MainMenu
    Me.mnuFile = New System.Windows.Forms.MenuItem
    Me.mnuExit = New System.Windows.Forms.MenuItem
    Me.mnuHelp = New System.Windows.Forms.MenuItem
    Me.GroupBox1.SuspendLayout()
    Me.SuspendLayout()
    '
    'btnFillSchema
    '
    Me.btnFillSchema.Location = New System.Drawing.Point(440, 224)
    Me.btnFillSchema.Name = "btnFillSchema"
    Me.btnFillSchema.Size = New System.Drawing.Size(224, 40)
    Me.btnFillSchema.TabIndex = 17
    Me.btnFillSchema.Text = "Wykonaj FillSchema"
    '
    'GroupBox1
    '
    Me.GroupBox1.Controls.Add(Me.radSchemaType_Source)
    Me.GroupBox1.Controls.Add(Me.radSchemaType_Mapped)
    Me.GroupBox1.Location = New System.Drawing.Point(224, 216)
    Me.GroupBox1.Name = "GroupBox1"
    Me.GroupBox1.Size = New System.Drawing.Size(200, 56)
    Me.GroupBox1.TabIndex = 18
    Me.GroupBox1.TabStop = False
    Me.GroupBox1.Text = "Wybierz typ schematu"
    '
    'radSchemaType_Source
    '
    Me.radSchemaType_Source.Location = New System.Drawing.Point(128, 24)
    Me.radSchemaType_Source.Name = "radSchemaType_Source"
    Me.radSchemaType_Source.Size = New System.Drawing.Size(64, 24)
    Me.radSchemaType_Source.TabIndex = 1
    Me.radSchemaType_Source.Text = "Source"
    '
    'radSchemaType_Mapped
    '
    Me.radSchemaType_Mapped.Checked = True
    Me.radSchemaType_Mapped.Location = New System.Drawing.Point(32, 24)
    Me.radSchemaType_Mapped.Name = "radSchemaType_Mapped"
    Me.radSchemaType_Mapped.Size = New System.Drawing.Size(64, 24)
    Me.radSchemaType_Mapped.TabIndex = 0
    Me.radSchemaType_Mapped.TabStop = True
    Me.radSchemaType_Mapped.Text = "Mapped"
    '
    'txtOutput
    '
    Me.txtOutput.Location = New System.Drawing.Point(24, 280)
    Me.txtOutput.Multiline = True
    Me.txtOutput.Name = "txtOutput"
    Me.txtOutput.ScrollBars = System.Windows.Forms.ScrollBars.Vertical
    Me.txtOutput.Size = New System.Drawing.Size(640, 184)
    Me.txtOutput.TabIndex = 19
    Me.txtOutput.Text = ""
    '
    'txtCommandText
    '
    Me.txtCommandText.Font = New System.Drawing.Font("Microsoft Sans Serif", 10.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.txtCommandText.Location = New System.Drawing.Point(24, 48)
    Me.txtCommandText.Multiline = True
    Me.txtCommandText.Name = "txtCommandText"
    Me.txtCommandText.ScrollBars = System.Windows.Forms.ScrollBars.Vertical
    Me.txtCommandText.Size = New System.Drawing.Size(640, 152)
    Me.txtCommandText.TabIndex = 20
    Me.txtCommandText.Text = ""
    '
    'cboQuery
    '
    Me.cboQuery.Items.AddRange(New Object() {"Pojedyncza tabela", "Nadrzdny - podrzdny", "Zoona relacja"})
    Me.cboQuery.Location = New System.Drawing.Point(136, 16)
    Me.cboQuery.Name = "cboQuery"
    Me.cboQuery.Size = New System.Drawing.Size(304, 21)
    Me.cboQuery.TabIndex = 21
    '
    'Label2
    '
    Me.Label2.Location = New System.Drawing.Point(24, 16)
    Me.Label2.Name = "Label2"
    Me.Label2.Size = New System.Drawing.Size(112, 23)
    Me.Label2.TabIndex = 23
    Me.Label2.Text = "Wybierz zapytanie:"
    '
    'Label1
    '
    Me.Label1.Location = New System.Drawing.Point(24, 248)
    Me.Label1.Name = "Label1"
    Me.Label1.Size = New System.Drawing.Size(120, 24)
    Me.Label1.TabIndex = 24
    Me.Label1.Text = "Wynik dziaania WriteXml:"
    Me.Label1.TextAlign = System.Drawing.ContentAlignment.BottomLeft
    '
    'txtTargetXmlDatafile
    '
    Me.txtTargetXmlDatafile.Location = New System.Drawing.Point(200, 480)
    Me.txtTargetXmlDatafile.Name = "txtTargetXmlDatafile"
    Me.txtTargetXmlDatafile.ReadOnly = True
    Me.txtTargetXmlDatafile.Size = New System.Drawing.Size(288, 20)
    Me.txtTargetXmlDatafile.TabIndex = 26
    Me.txtTargetXmlDatafile.TabStop = False
    Me.txtTargetXmlDatafile.Text = ""
    '
    'btnWriteXmlDataFile
    '
    Me.btnWriteXmlDataFile.Location = New System.Drawing.Point(24, 480)
    Me.btnWriteXmlDataFile.Name = "btnWriteXmlDataFile"
    Me.btnWriteXmlDataFile.Size = New System.Drawing.Size(168, 24)
    Me.btnWriteXmlDataFile.TabIndex = 25
    Me.btnWriteXmlDataFile.Text = "Zapisz XML do pliku:"
    '
    'mnuMain
    '
    Me.mnuMain.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile, Me.mnuHelp})
    '
    'mnuFile
    '
    Me.mnuFile.Index = 0
    Me.mnuFile.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuExit})
    Me.mnuFile.Text = "&Plik"
    '
    'mnuExit
    '
    Me.mnuExit.Index = 0
    Me.mnuExit.Text = "&Koniec"
    '
    'mnuHelp
    '
    Me.mnuHelp.Index = 1
    Me.mnuHelp.Text = "P&omoc"
    '
    'frmMain
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(686, 512)
    Me.Controls.Add(Me.txtTargetXmlDatafile)
    Me.Controls.Add(Me.btnWriteXmlDataFile)
    Me.Controls.Add(Me.Label1)
    Me.Controls.Add(Me.Label2)
    Me.Controls.Add(Me.cboQuery)
    Me.Controls.Add(Me.txtCommandText)
    Me.Controls.Add(Me.txtOutput)
    Me.Controls.Add(Me.GroupBox1)
    Me.Controls.Add(Me.btnFillSchema)
    Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.Fixed3D
    Me.Menu = Me.mnuMain
    Me.Name = "frmMain"
    Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
    Me.Text = "DataSet.FillSchema"
    Me.GroupBox1.ResumeLayout(False)
    Me.ResumeLayout(False)

  End Sub

#End Region

    Dim m_strConn As String = "data source=""(local)"";initial catalog=Northwind;integrated security=SSPI;persist security info=False;"
    Dim m_conNw As SqlConnection
    Dim m_strSchemaType As String
    Dim m_strQueryType As String
    Dim m_dsData As System.Data.DataSet

    Const kstrQueryType_SingleTable As String = "SELECT ProductID, ProductName, SupplierID, CategoryID, QuantityPerUnit, UnitPrice, UnitsInStock, UnitsOnOrder, ReorderLevel, Discontinued FROM Products"

    Const kstrQueryType_ParentChild As String = "SELECT Categories.CategoryID, Categories.CategoryName, Categories.Description, Products.ProductID, Products.ProductName, Products.UnitPrice FROM Categories INNER JOIN Products ON Categories.CategoryID = Products.CategoryID"

    Const kstrQueryType_ComplexRelationship As String = "SELECT Orders.OrderID, Orders.OrderDate, Orders.RequiredDate, Orders.ShippedDate, [Order Details].OrderID AS Expr1, [Order Details].ProductID, [Order Details].UnitPrice, [Order Details].Quantity, [Order Details].Discount, Products.ProductID AS Expr2, Products.ProductName, Products.SupplierID, Suppliers.SupplierID AS Expr3, Suppliers.CompanyName, Suppliers.ContactName, Suppliers.ContactTitle, Categories.CategoryID, Categories.CategoryName, Categories.Description FROM Categories INNER JOIN Products ON Categories.CategoryID = Products.CategoryID INNER JOIN Suppliers ON Products.SupplierID = Suppliers.SupplierID INNER JOIN [Order Details] ON Products.ProductID = [Order Details].ProductID INNER JOIN Orders ON [Order Details].OrderID = Orders.OrderID"

    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Me.txtCommandText.Text = kstrQueryType_SingleTable
        Me.cboQuery.SelectedIndex = 0
        SetOutputFileName()
    End Sub

    Private Sub DeleteFile(ByVal pstrFileName As String)
        Dim path As String = pstrFileName
        Dim fi As FileInfo = New FileInfo(path)
        Try
            fi.Delete()
        Catch ex As Exception
            MessageBox.Show("Unable to delete file: {0}", ex.ToString())
        End Try
    End Sub

    Private Sub btnFillSchema_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnFillSchema.Click
        FillSchema()
    End Sub

    Private Sub FillSchema()
        Dim daQuery As SqlDataAdapter
        Try
            m_conNw = New SqlConnection(m_strConn)
            m_dsData = New System.Data.DataSet
            daQuery = New SqlDataAdapter(Me.txtCommandText.Text, m_conNw)

            'Apply TableMapping to change the name of the table in the DataSet. The mapped
            'name will display 'when the selected SchemaType is "Mapped"; otherwise, the 
            'sourcetable name of "Table" will display.

            'Note: For the purpose of table mappings, ADO.NET treats the sourcetable 
            'name as "Table" when the CommandType is CommandText.
            Select Case Me.cboQuery.SelectedIndex
                Case QueryType.SingleTable
                    daQuery.TableMappings.Add("Table", "SimpleTable")
                Case QueryType.ParentChild
                    daQuery.TableMappings.Add("Table", "ParentChild")
                Case QueryType.ComplexRelationship
                    daQuery.TableMappings.Add("Table", "ComplexRelationship")
            End Select

            If Me.radSchemaType_Mapped.Checked Then
                daQuery.FillSchema(m_dsData, SchemaType.Mapped)
            ElseIf Me.radSchemaType_Source.Checked Then
                daQuery.FillSchema(m_dsData, SchemaType.Source)
            End If
            DisplayXmlDataFile()
        Catch ex As Exception
            MessageBox.Show("[FillSchema()] " + ex.Message)
        Finally
            m_conNw = Nothing
            m_dsData = Nothing
            daQuery = Nothing
        End Try

    End Sub

    Private Sub DisplayXmlDataFile()
        Dim strMsg As String = m_dsData.GetXmlSchema() + ControlChars.NewLine + m_dsData.GetXml()
        Me.txtOutput.Text = strMsg
    End Sub

    Private Sub radSchemaType_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles radSchemaType_Mapped.CheckedChanged, radSchemaType_Source.CheckedChanged
        Me.txtOutput.Clear()
        SetOutputFileName()
    End Sub

    Private Enum QueryType
        SingleTable = 0
        ParentChild = 1
        ComplexRelationship = 2
    End Enum

    Private Sub cboQuery_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cboQuery.SelectedIndexChanged

        Select Case Me.cboQuery.SelectedIndex
            Case QueryType.SingleTable
                Me.txtCommandText.Text = kstrQueryType_SingleTable
            Case QueryType.ParentChild
                Me.txtCommandText.Text = kstrQueryType_ParentChild
            Case QueryType.ComplexRelationship
                Me.txtCommandText.Text = kstrQueryType_ComplexRelationship
            Case Else
        End Select

        SetOutputFileName()

    End Sub

    Private Sub SetOutputFileName()
        Select Case Me.cboQuery.SelectedIndex
            Case QueryType.SingleTable
                m_strQueryType = "SingleTable"
            Case QueryType.ParentChild
                m_strQueryType = "ParentChild"
            Case QueryType.ComplexRelationship
                m_strQueryType = "ComplexRelationship"
            Case Else
        End Select

        If Me.radSchemaType_Mapped.Checked Then
            m_strSchemaType = "Mapped"
        ElseIf Me.radSchemaType_Source.Checked Then
            m_strSchemaType = "Source"
        End If

        Me.txtTargetXmlDatafile.Text = "..\" + m_strQueryType + "_" + m_strSchemaType + ".xml"
    End Sub

    Private Sub btnWriteXmlDataFile_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnWriteXmlDataFile.Click

        If Me.txtOutput.Text = "" Then
            FillSchema()
        End If
        Dim swX As New StreamWriter(Me.txtTargetXmlDatafile.Text)
        swX.Write(Me.txtOutput.Text)
        MessageBox.Show("File " & Me.txtTargetXmlDatafile.Text & " written.")
        swX.Close()

    End Sub

    Private Sub mnuExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuExit.Click
        Me.Close()
    End Sub

    Private Sub mnuHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuHelp.Click
        Dim frmX As New frmHelp("..\zzReadMe.txt")
        frmX.Show()
    End Sub
End Class
