Public Class frmMain
  Inherits System.Windows.Forms.Form

  Dim Products As New Products

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call

  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.IContainer

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  Friend WithEvents btnLoadProducts As System.Windows.Forms.Button
  Friend WithEvents btnNavFirst As System.Windows.Forms.Button
  Friend WithEvents btnNavPrev As System.Windows.Forms.Button
  Friend WithEvents btnNavNext As System.Windows.Forms.Button
  Friend WithEvents btnNavLast As System.Windows.Forms.Button
  Friend WithEvents txtListPosition As System.Windows.Forms.TextBox
  Friend WithEvents txtProductId As System.Windows.Forms.TextBox
  Friend WithEvents txtProductName As System.Windows.Forms.TextBox
  Friend WithEvents btnAdd As System.Windows.Forms.Button
  Friend WithEvents btnDel As System.Windows.Forms.Button
  Friend WithEvents btnCancel As System.Windows.Forms.Button
  Friend WithEvents txtUnitsInStock As System.Windows.Forms.TextBox
  Friend WithEvents lblProductName As System.Windows.Forms.Label
  Friend WithEvents lblUnitsInStock As System.Windows.Forms.Label
  Friend WithEvents txtUnitsOnOrder As System.Windows.Forms.TextBox
  Friend WithEvents lblUnitsOnOrder As System.Windows.Forms.Label
  Friend WithEvents txtReorderLevel As System.Windows.Forms.TextBox
  Friend WithEvents lblReorderLevel As System.Windows.Forms.Label
  Friend WithEvents lblProductId As System.Windows.Forms.Label
  Friend WithEvents btnGetChanges As System.Windows.Forms.Button
  Friend WithEvents lblInstructions As System.Windows.Forms.Label
  Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
  Friend WithEvents mnuFile As System.Windows.Forms.MenuItem
  Friend WithEvents mnuFile_Exit As System.Windows.Forms.MenuItem
  Friend WithEvents mnuHelp As System.Windows.Forms.MenuItem
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.btnLoadProducts = New System.Windows.Forms.Button
    Me.txtProductId = New System.Windows.Forms.TextBox
    Me.txtProductName = New System.Windows.Forms.TextBox
    Me.txtUnitsInStock = New System.Windows.Forms.TextBox
    Me.lblProductId = New System.Windows.Forms.Label
    Me.lblProductName = New System.Windows.Forms.Label
    Me.lblUnitsInStock = New System.Windows.Forms.Label
    Me.btnNavFirst = New System.Windows.Forms.Button
    Me.btnNavPrev = New System.Windows.Forms.Button
    Me.btnNavNext = New System.Windows.Forms.Button
    Me.btnNavLast = New System.Windows.Forms.Button
    Me.txtListPosition = New System.Windows.Forms.TextBox
    Me.btnAdd = New System.Windows.Forms.Button
    Me.btnDel = New System.Windows.Forms.Button
    Me.btnCancel = New System.Windows.Forms.Button
    Me.txtUnitsOnOrder = New System.Windows.Forms.TextBox
    Me.lblUnitsOnOrder = New System.Windows.Forms.Label
    Me.txtReorderLevel = New System.Windows.Forms.TextBox
    Me.lblReorderLevel = New System.Windows.Forms.Label
    Me.btnGetChanges = New System.Windows.Forms.Button
    Me.lblInstructions = New System.Windows.Forms.Label
    Me.MainMenu1 = New System.Windows.Forms.MainMenu
    Me.mnuFile = New System.Windows.Forms.MenuItem
    Me.mnuFile_Exit = New System.Windows.Forms.MenuItem
    Me.mnuHelp = New System.Windows.Forms.MenuItem
    Me.SuspendLayout()
    '
    'btnLoadProducts
    '
    Me.btnLoadProducts.Location = New System.Drawing.Point(16, 16)
    Me.btnLoadProducts.Name = "btnLoadProducts"
    Me.btnLoadProducts.Size = New System.Drawing.Size(88, 72)
    Me.btnLoadProducts.TabIndex = 0
    Me.btnLoadProducts.Text = "Zaaduj dane towarw"
    '
    'txtProductId
    '
    Me.txtProductId.Location = New System.Drawing.Point(96, 128)
    Me.txtProductId.Name = "txtProductId"
    Me.txtProductId.ReadOnly = True
    Me.txtProductId.Size = New System.Drawing.Size(224, 20)
    Me.txtProductId.TabIndex = 2
    Me.txtProductId.Text = ""
    '
    'txtProductName
    '
    Me.txtProductName.Location = New System.Drawing.Point(96, 160)
    Me.txtProductName.Name = "txtProductName"
    Me.txtProductName.Size = New System.Drawing.Size(224, 20)
    Me.txtProductName.TabIndex = 4
    Me.txtProductName.Text = ""
    '
    'txtUnitsInStock
    '
    Me.txtUnitsInStock.Location = New System.Drawing.Point(96, 192)
    Me.txtUnitsInStock.Name = "txtUnitsInStock"
    Me.txtUnitsInStock.Size = New System.Drawing.Size(40, 20)
    Me.txtUnitsInStock.TabIndex = 6
    Me.txtUnitsInStock.Text = ""
    '
    'lblProductId
    '
    Me.lblProductId.Location = New System.Drawing.Point(16, 128)
    Me.lblProductId.Name = "lblProductId"
    Me.lblProductId.Size = New System.Drawing.Size(80, 23)
    Me.lblProductId.TabIndex = 1
    Me.lblProductId.Text = "ID towaru"
    '
    'lblProductName
    '
    Me.lblProductName.Location = New System.Drawing.Point(16, 160)
    Me.lblProductName.Name = "lblProductName"
    Me.lblProductName.Size = New System.Drawing.Size(80, 23)
    Me.lblProductName.TabIndex = 3
    Me.lblProductName.Text = "Nazwa towaru"
    '
    'lblUnitsInStock
    '
    Me.lblUnitsInStock.Location = New System.Drawing.Point(16, 192)
    Me.lblUnitsInStock.Name = "lblUnitsInStock"
    Me.lblUnitsInStock.Size = New System.Drawing.Size(80, 23)
    Me.lblUnitsInStock.TabIndex = 5
    Me.lblUnitsInStock.Text = "Ilo w mag."
    '
    'btnNavFirst
    '
    Me.btnNavFirst.Location = New System.Drawing.Point(96, 240)
    Me.btnNavFirst.Name = "btnNavFirst"
    Me.btnNavFirst.Size = New System.Drawing.Size(24, 23)
    Me.btnNavFirst.TabIndex = 11
    Me.btnNavFirst.Text = "|<"
    '
    'btnNavPrev
    '
    Me.btnNavPrev.Location = New System.Drawing.Point(120, 240)
    Me.btnNavPrev.Name = "btnNavPrev"
    Me.btnNavPrev.Size = New System.Drawing.Size(24, 23)
    Me.btnNavPrev.TabIndex = 12
    Me.btnNavPrev.Text = "<"
    '
    'btnNavNext
    '
    Me.btnNavNext.Location = New System.Drawing.Point(248, 240)
    Me.btnNavNext.Name = "btnNavNext"
    Me.btnNavNext.Size = New System.Drawing.Size(24, 23)
    Me.btnNavNext.TabIndex = 14
    Me.btnNavNext.Text = ">"
    '
    'btnNavLast
    '
    Me.btnNavLast.Location = New System.Drawing.Point(272, 240)
    Me.btnNavLast.Name = "btnNavLast"
    Me.btnNavLast.Size = New System.Drawing.Size(24, 23)
    Me.btnNavLast.TabIndex = 15
    Me.btnNavLast.Text = ">|"
    '
    'txtListPosition
    '
    Me.txtListPosition.Location = New System.Drawing.Point(144, 240)
    Me.txtListPosition.Name = "txtListPosition"
    Me.txtListPosition.TabIndex = 13
    Me.txtListPosition.Text = "Rekord m z n"
    '
    'btnAdd
    '
    Me.btnAdd.Location = New System.Drawing.Point(104, 272)
    Me.btnAdd.Name = "btnAdd"
    Me.btnAdd.Size = New System.Drawing.Size(64, 23)
    Me.btnAdd.TabIndex = 16
    Me.btnAdd.Text = "Dodaj"
    '
    'btnDel
    '
    Me.btnDel.Location = New System.Drawing.Point(168, 272)
    Me.btnDel.Name = "btnDel"
    Me.btnDel.Size = New System.Drawing.Size(64, 23)
    Me.btnDel.TabIndex = 17
    Me.btnDel.Text = "Usu"
    '
    'btnCancel
    '
    Me.btnCancel.Location = New System.Drawing.Point(232, 272)
    Me.btnCancel.Name = "btnCancel"
    Me.btnCancel.Size = New System.Drawing.Size(64, 23)
    Me.btnCancel.TabIndex = 18
    Me.btnCancel.Text = "Anuluj"
    '
    'txtUnitsOnOrder
    '
    Me.txtUnitsOnOrder.Location = New System.Drawing.Point(240, 192)
    Me.txtUnitsOnOrder.Name = "txtUnitsOnOrder"
    Me.txtUnitsOnOrder.Size = New System.Drawing.Size(40, 20)
    Me.txtUnitsOnOrder.TabIndex = 8
    Me.txtUnitsOnOrder.Text = ""
    '
    'lblUnitsOnOrder
    '
    Me.lblUnitsOnOrder.Location = New System.Drawing.Point(160, 192)
    Me.lblUnitsOnOrder.Name = "lblUnitsOnOrder"
    Me.lblUnitsOnOrder.Size = New System.Drawing.Size(80, 23)
    Me.lblUnitsOnOrder.TabIndex = 7
    Me.lblUnitsOnOrder.Text = "Ilo w zam."
    '
    'txtReorderLevel
    '
    Me.txtReorderLevel.Location = New System.Drawing.Point(400, 192)
    Me.txtReorderLevel.Name = "txtReorderLevel"
    Me.txtReorderLevel.Size = New System.Drawing.Size(40, 20)
    Me.txtReorderLevel.TabIndex = 10
    Me.txtReorderLevel.Text = ""
    '
    'lblReorderLevel
    '
    Me.lblReorderLevel.Location = New System.Drawing.Point(288, 192)
    Me.lblReorderLevel.Name = "lblReorderLevel"
    Me.lblReorderLevel.Size = New System.Drawing.Size(112, 23)
    Me.lblReorderLevel.TabIndex = 9
    Me.lblReorderLevel.Text = "Poziom zamawiania"
    '
    'btnGetChanges
    '
    Me.btnGetChanges.Location = New System.Drawing.Point(336, 240)
    Me.btnGetChanges.Name = "btnGetChanges"
    Me.btnGetChanges.Size = New System.Drawing.Size(104, 72)
    Me.btnGetChanges.TabIndex = 20
    Me.btnGetChanges.Text = "Poka wszystkie zmiany"
    '
    'lblInstructions
    '
    Me.lblInstructions.ForeColor = System.Drawing.Color.FromArgb(CType(192, Byte), CType(0, Byte), CType(0, Byte))
    Me.lblInstructions.Location = New System.Drawing.Point(120, 24)
    Me.lblInstructions.Name = "lblInstructions"
    Me.lblInstructions.Size = New System.Drawing.Size(368, 88)
    Me.lblInstructions.TabIndex = 21
    Me.lblInstructions.Text = "Instructions"
    '
    'MainMenu1
    '
    Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile, Me.mnuHelp})
    '
    'mnuFile
    '
    Me.mnuFile.Index = 0
    Me.mnuFile.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile_Exit})
    Me.mnuFile.Text = "&Plik"
    '
    'mnuFile_Exit
    '
    Me.mnuFile_Exit.Index = 0
    Me.mnuFile_Exit.Text = "&Koniec"
    '
    'mnuHelp
    '
    Me.mnuHelp.Index = 1
    Me.mnuHelp.Text = "P&omoc"
    '
    'frmMain
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(494, 338)
    Me.Controls.Add(Me.lblInstructions)
    Me.Controls.Add(Me.btnGetChanges)
    Me.Controls.Add(Me.txtReorderLevel)
    Me.Controls.Add(Me.lblReorderLevel)
    Me.Controls.Add(Me.txtUnitsOnOrder)
    Me.Controls.Add(Me.lblUnitsOnOrder)
    Me.Controls.Add(Me.btnCancel)
    Me.Controls.Add(Me.btnDel)
    Me.Controls.Add(Me.btnAdd)
    Me.Controls.Add(Me.txtListPosition)
    Me.Controls.Add(Me.txtUnitsInStock)
    Me.Controls.Add(Me.txtProductName)
    Me.Controls.Add(Me.txtProductId)
    Me.Controls.Add(Me.btnNavLast)
    Me.Controls.Add(Me.btnNavNext)
    Me.Controls.Add(Me.btnNavPrev)
    Me.Controls.Add(Me.btnNavFirst)
    Me.Controls.Add(Me.lblUnitsInStock)
    Me.Controls.Add(Me.lblProductName)
    Me.Controls.Add(Me.lblProductId)
    Me.Controls.Add(Me.btnLoadProducts)
    Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.Fixed3D
    Me.Menu = Me.MainMenu1
    Me.Name = "frmMain"
    Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
    Me.Text = "Wasne kolekcje doczalne do odczytu i zapisu"
    Me.ResumeLayout(False)

  End Sub

#End Region

  Private Sub btnLoadProducts_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnLoadProducts.Click

    Dim objProduct As Product
    objProduct = New Product(System.Guid.NewGuid)
    objProduct.ProductName = "Pasta do zbw"
    objProduct.UnitsInStock = 10
    objProduct.UnitsOnOrder = 25
    objProduct.ReorderLevel = 15
    Products.Add(objProduct)

    objProduct = New Product(System.Guid.NewGuid)
    objProduct.ProductName = "Nici dentystyczne"
    objProduct.UnitsInStock = 200
    objProduct.UnitsOnOrder = 500
    objProduct.ReorderLevel = 300
    Products.Add(objProduct)

    objProduct = New Product(System.Guid.NewGuid)
    objProduct.ProductName = "Mydo"
    objProduct.UnitsInStock = 200
    objProduct.UnitsOnOrder = 500
    objProduct.ReorderLevel = 300
    Products.Add(objProduct)

    'W przypadku, gdy aplikacja ta korzystaaby z bazy danych, powysze wiersze powinny 
    'zosta zamienione na wywoanie metody LoadData() z klasy Products,ktra powinna zaadowa
    'z bazy danych dane z tabeli Product, przeksztaci na kolekcj Products z obiektami Product
    'i dostarczy tu, do interfejsu uytkownika.

    Clearbindings()
    SetBindings()

    Me.BindingContext(Products).Position = 0
    UpdatePositionDisplay()

  End Sub

  Private Sub Clearbindings()
    Me.txtProductId.DataBindings.Clear()
    Me.txtProductName.DataBindings.Clear()
    Me.txtUnitsInStock.DataBindings.Clear()
    Me.txtUnitsOnOrder.DataBindings.Clear()
    Me.txtReorderLevel.DataBindings.Clear()
  End Sub

  Private Sub SetBindings()
    Me.txtProductId.DataBindings.Add(New Binding("Text", Products, "ProductId"))
    Me.txtProductName.DataBindings.Add(New Binding("Text", Products, "ProductName"))
    Me.txtUnitsInStock.DataBindings.Add(New Binding("Text", Products, "UnitsInStock"))
    Me.txtUnitsOnOrder.DataBindings.Add(New Binding("Text", Products, "UnitsOnOrder"))
    Me.txtReorderLevel.DataBindings.Add(New Binding("Text", Products, "ReorderLevel"))
  End Sub

  Private Sub btnNavFirst_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNavFirst.Click
    Me.BindingContext(Products).Position = 0
    UpdatePositionDisplay()
  End Sub

  Private Sub btnNavLast_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNavLast.Click
    Me.BindingContext(Products).Position = Me.BindingContext(Products).Count - 1
    UpdatePositionDisplay()
  End Sub

  Private Sub btnNavPrev_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNavPrev.Click
    Me.BindingContext(Products).Position -= 1
    UpdatePositionDisplay()
  End Sub

  Private Sub btnNavNext_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNavNext.Click
    Me.BindingContext(Products).Position += 1
    UpdatePositionDisplay()
  End Sub

  Private Sub UpdatePositionDisplay()
    Me.txtListPosition.Text = "Rekord " + (Me.BindingContext(Products).Position + 1).ToString + " z " + Me.BindingContext(Products).Count.ToString
  End Sub

  Private Sub btnAdd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAdd.Click
    Dim objProduct As Product
    objProduct = Products.AddNew()
    objProduct.Added = True
    Me.BindingContext(Products).Position = Me.BindingContext(Products).Count - 1
    UpdatePositionDisplay()
    Me.txtProductName.Focus()
  End Sub

  Private Sub btnDel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDel.Click
    Dim intPosition As Int32 = Me.BindingContext(Products).Position
    If intPosition < 0 Then
      MessageBox.Show("Brak elementw do skasowania!")
      Return
    End If
    Me.BindingContext(Products).Position = 0
    Products.Delete(intPosition)
    Select Case intPosition
      Case 0
        If Me.BindingContext(Products).Count = 0 Then
          ClearBoundControls()
          Me.BindingContext(Products).Position = -1
        Else
          Me.BindingContext(Products).Position = Me.BindingContext(Products).Count - 1
          Me.BindingContext(Products).Position = 0
        End If
      Case Else
        Me.BindingContext(Products).Position = intPosition - 1
    End Select
    UpdatePositionDisplay()
  End Sub

  Private Sub ClearBoundControls()
    Me.txtProductId.ResetText()
    Me.txtProductName.ResetText()
    Me.txtUnitsInStock.ResetText()
    Me.txtUnitsOnOrder.ResetText()
    Me.txtReorderLevel.ResetText()
  End Sub

  Private Sub btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancel.Click
    Me.BindingContext(Products).CancelCurrentEdit()
  End Sub

  Private Sub btnGetChanges_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetChanges.Click
    Dim strMsg As String
    If Products.HasChanges Then
      strMsg = Products.GetDescriptionOfChanges()
    Else
      strMsg = "Brak operacji modyfikacji, wstawiania lub kasowania od zaadowania produktw."
    End If
    MessageBox.Show(strMsg)
  End Sub

  Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
    Dim strMsg As String
        strMsg += "1. Wywietl okno Output, aby widzie monitorowanie zdarze. "
    strMsg += ControlChars.NewLine
    strMsg += "2. Zaaduj towary."
    strMsg += ControlChars.NewLine
        strMsg += "3. Zmodyfikuj, skasuj i dodaj kilka towarw. Obserwuj okno Output."
    strMsg += ControlChars.NewLine
        strMsg += "4. Kliknij Poka wszystkie zmiany, aby zobaczy zapis zmian."
    strMsg += ControlChars.NewLine
    strMsg += "5. W razie potrzeby powtarzaj kroki 3 i 4."
    Me.lblInstructions.Text = strMsg
  End Sub

  Private Sub mnuFile_Exit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuFile_Exit.Click
    Me.Close()
  End Sub

  Private Sub mnuHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuHelp.Click
    Dim frmX As New frmHelp("..\zzReadMe.txt")
    frmX.Show()
  End Sub
End Class
