Imports System.ComponentModel
Public Class Products
  Inherits CollectionBase
  Implements IBindingList

  Private objResetEvent As New ListChangedEventArgs(ListChangedType.Reset, -1)
  Private arlDeletedItems As ArrayList
  Dim ChangedProducts As Products

  Private Sub WriteChangeInfoToConsole(ByVal ev As ListChangedEventArgs)
    'Metoda wysya dane diagnostyczne do okna konsoli w momencie zmiany, 
    'wstawienia lub skasowania elementu
    Dim strProductName As String
    Dim strActionTaken As String
    Select Case ev.ListChangedType
      Case ListChangedType.ItemMoved
        strActionTaken = "(przeniesiony)"
        strProductName = list.Item(ev.NewIndex).ProductName & " "
      Case ListChangedType.ItemAdded
        strActionTaken = "(dodany)"
        strProductName = list.Item(ev.NewIndex).ProductName & " "
      Case ListChangedType.ItemChanged
        strActionTaken = "(zmieniony)"
        strProductName = list.Item(ev.NewIndex).ProductName & " "
      Case ListChangedType.ItemDeleted
        strActionTaken = "(skasowany)"
        If ev.NewIndex <= list.Count - 1 Then
          strProductName = list.Item(ev.NewIndex).ProductName & " "
        Else
          'Lista nie zawiera ju tego elementu.
          strProductName = "<Element dodany w tej sesji edycji>"
        End If
      Case ListChangedType.Reset
        strActionTaken = "(Lista zostaa skasowana)"
        strProductName = list.Item(ev.NewIndex).ProductName & " "
      Case Else
        strActionTaken = "(Bd w metodzie obsugi zdarzenia ListChanged. nieoczekiwana warto ListChangedType)"
    End Select
    If strProductName = " " Then
      strProductName = "<Jeszcze nie nazwany towar>"
    End If
    Console.WriteLine(strProductName & strActionTaken)
  End Sub

#Region " Skadowe nie odziedziczone i nie pochodzce z interfejsu "
  Default Public Property Item(ByVal index As Integer) As Product
    Get
      Return CType(List(index), Product)
    End Get
    Set(ByVal Value As Product)
      List(index) = Value
    End Set
  End Property

  Public Function Add(ByVal value As Product) As Integer
    Return List.Add(value)
  End Function

  Public Sub Delete(ByVal index As Integer)
    If Me.Item(index).Added Then
      'Jeeli element by dodany, a nastepnie skasowany, nie dodajemy go do listy skasowanych
      'elementw poniewa nie istnial on w bazie danych i dlatego nie musi by kasowany.
    Else
      'Kasujemy znacznik Changed, dziki czemu, jeeli obiekt by modyfikowany przed
      'skasowaniem nie zostanie on uznany za zmieniony w czasie dziaania metody GetChanges.
      Me.Item(index).Changed = False
      'Dodanie elementu do listy skasowanych elementw.
      If arlDeletedItems Is Nothing Then
        arlDeletedItems = New ArrayList
        arlDeletedItems.Add(Me.Item(index))
      End If
    End If
    'Usunicie elementu z kolekcji.
    Me.RemoveAt(index)

  End Sub

  ' Called by Product when it changes.
  Friend Sub ProductChanged(ByVal objProduct As Product)
    Dim index As Integer = List.IndexOf(objProduct)
    OnListChanged(New ListChangedEventArgs(ListChangedType.ItemChanged, index))
  End Sub

  Protected Overridable Sub OnListChanged(ByVal ev As ListChangedEventArgs)
    WriteChangeInfoToConsole(ev)
  End Sub

  Public Function HasChanges() As Boolean
    If Not arlDeletedItems Is Nothing Then
      Return True
    End If

    Dim objProduct As Product
    For Each objProduct In Me
      If objProduct.Changed Or objProduct.Added Then
        Return True
      End If
    Next
  End Function

  Public Function GetChanges() As Products
    'zwraca typowan kolekcj obiektw Products, reprezentujc podzbir kolekcji 
    'Producs zawierajcy zmienione obiekty.
    ChangedProducts = New Products

    Dim objProduct As Product
    For Each objProduct In Me
      If objProduct.Changed Or objProduct.Added Then
        ChangedProducts.Add(objProduct)
      End If
    Next
    If Not arlDeletedItems Is Nothing Then
      For Each objProduct In arlDeletedItems
        ChangedProducts.Add(objProduct)
      Next
    End If
    GetChanges = ChangedProducts
  End Function

  Public Function GetDescriptionOfChanges() As String
    'Zwraca cig opisujcy wszystkie zmiany wprowadzone do kolekcji towarw
    Dim ChangedProducts As Products = GetChanges()
    Dim objProduct As Product
    Dim strMsg As String

    strMsg = "Zmiana wykonana " & Now.ToUniversalTime & ControlChars.NewLine & ControlChars.NewLine
    For Each objProduct In ChangedProducts
      strMsg += "Towar: " & objProduct.ProductName & " ("
      'Typy zmian musz byc sprawdzane w nastpujcej kolejnoci: Added nastpnie Changed.
      'Zmienione towary nie oznaczone jako Added lub Changed s skasowane.
      If objProduct.Added Then
        strMsg += "Dodany"
      ElseIf objProduct.Changed Then
        strMsg += "Zmieniony"
      Else
        strMsg += "Skasowany"
      End If
      strMsg += ")" & ControlChars.NewLine
    Next

    GetDescriptionOfChanges = strMsg
  End Function

#End Region

#Region " Skadowe przesaniajce odziedziczone skadowe "

  Protected Overrides Sub OnClear()
    Dim objProduct As Product
    For Each objProduct In List
      objProduct.ContainingCollection = Nothing
    Next objProduct
  End Sub

  Protected Overrides Sub OnClearComplete()
    OnListChanged(objResetEvent)
  End Sub

  Protected Overrides Sub OnInsertComplete(ByVal index As Integer, ByVal value As Object)
    Dim objProduct As Product = CType(value, Product)
    objProduct.ContainingCollection = Me
    OnListChanged(New ListChangedEventArgs(ListChangedType.ItemAdded, index))
  End Sub

  Protected Overrides Sub OnRemoveComplete(ByVal index As Integer, ByVal value As Object)
    Dim objProduct As Product = CType(value, Product)
    objProduct.ContainingCollection = Me
    OnListChanged(New ListChangedEventArgs(ListChangedType.ItemDeleted, index))
  End Sub

  Protected Overrides Sub OnSetComplete(ByVal index As Integer, ByVal oldValue As Object, ByVal newValue As Object)
    If oldValue <> newValue Then
      Dim oldProduct As Product = CType(oldValue, Product)
      Dim newProduct As Product = CType(newValue, Product)

      oldProduct.ContainingCollection = Nothing
      newProduct.ContainingCollection = Me

      OnListChanged(New ListChangedEventArgs(ListChangedType.ItemAdded, index))
    End If
  End Sub
#End Region

#Region " Skadowe implementujce skadowe z interfejsu IBindingList "

  'Waciwoci
  ReadOnly Property AllowEdit() As Boolean Implements IBindingList.AllowEdit
    Get
      Return True
    End Get
  End Property

  ReadOnly Property AllowNew() As Boolean Implements IBindingList.AllowNew
    Get
      Return True
    End Get
  End Property

  ReadOnly Property AllowRemove() As Boolean Implements IBindingList.AllowRemove
    Get
      Return True
    End Get
  End Property

  ReadOnly Property SupportsChangeNotification() As Boolean Implements IBindingList.SupportsChangeNotification
    Get
      Return True
    End Get
  End Property

  ReadOnly Property SupportsSearching() As Boolean Implements IBindingList.SupportsSearching
    Get
      Return False
    End Get
  End Property

  ReadOnly Property SupportsSorting() As Boolean Implements IBindingList.SupportsSorting
    Get
      Return False
    End Get
  End Property

  ' Zdarzenia.
  Public Event ListChanged As ListChangedEventHandler Implements IBindingList.ListChanged

  ' Metody.
  Function AddNew() As Object Implements IBindingList.AddNew
    Dim guiX As Guid = System.Guid.NewGuid
    Dim objProduct As New Product(guiX)
    List.Add(objProduct)
    Return objProduct
  End Function

#End Region

#Region " Skadowe implementujc skadowe z interfejsu IBindingList bez realizacji funkcji"

  'Waciwoci.
  ReadOnly Property IsSorted() As Boolean Implements IBindingList.IsSorted
    Get
      Throw New NotSupportedException
    End Get
  End Property

  ReadOnly Property SortDirection() As ListSortDirection Implements IBindingList.SortDirection
    Get
      Throw New NotSupportedException
    End Get
  End Property


  ReadOnly Property SortProperty() As PropertyDescriptor Implements IBindingList.SortProperty
    Get
      Throw New NotSupportedException
    End Get
  End Property

  ' Metody.
  Sub AddIndex(ByVal prop As PropertyDescriptor) Implements IBindingList.AddIndex
    Throw New NotSupportedException
  End Sub

  Sub ApplySort(ByVal prop As PropertyDescriptor, ByVal direction As ListSortDirection) Implements IBindingList.ApplySort
    Throw New NotSupportedException
  End Sub

  Function Find(ByVal prop As PropertyDescriptor, ByVal key As Object) As Integer Implements IBindingList.Find
    Throw New NotSupportedException
  End Function

  Sub RemoveIndex(ByVal prop As PropertyDescriptor) Implements IBindingList.RemoveIndex
    Throw New NotSupportedException
  End Sub

  Sub RemoveSort() Implements IBindingList.RemoveSort
    Throw New NotSupportedException
  End Sub 'IBindingList.RemoveSort
#End Region

End Class
