Imports System.Data.SqlClient


Public Class Data
    Private m_conNw As SqlConnection
    Private m_daProducts As SqlDataAdapter
    Private m_prmMinReorderLevel As SqlParameter

    Private m_dsData As dsNw
    Private m_arlProducts As ArrayList


    Public Sub New()
        'Declare and initialize Connection, Command, Parameter,
        'and DataAdapter objects to be used in data retrieval and updating

        Dim strConn As String
        Dim prmProductName As SqlParameter
        Dim prmUnitsInStock As SqlParameter
        Dim prmUnitsOnOrder As SqlParameter
        Dim prmReorderLevel As SqlParameter

        m_conNw = New SqlConnection
        strConn = "workstation id=DIM4300;packet size=4096;"
        strConn &= "integrated security=SSPI;data source=""(local)"";"
        strConn &= "persist security info=False;initial catalog=Northwind"
        m_conNw.ConnectionString = strConn

        'Set up the SELECT command
        '--------------------------------
        Dim cmdProductSelect As SqlCommand
        cmdProductSelect = New SqlCommand
        cmdProductSelect.CommandType = CommandType.Text
        cmdProductSelect.Connection = m_conNw

        Dim strCommandText As String
        strCommandText = "SELECT ProductID, ProductName, "
        strCommandText &= "UnitsInStock, UnitsOnOrder, ReorderLevel "
        strCommandText &= "FROM dbo.Products "
        strCommandText &= "WHERE ReorderLevel >= @MinReorderLevel "
        cmdProductSelect.CommandText = strCommandText

        m_prmMinReorderLevel = New SqlParameter("@MinReorderLevel", SqlDbType.Int)
        cmdProductSelect.Parameters.Add(m_prmMinReorderLevel)

        m_daProducts = New SqlDataAdapter
        m_daProducts.SelectCommand = cmdProductSelect

    End Sub

    Public Function GetProducts(ByVal pintMinReorderLevel As Int32)

        m_prmMinReorderLevel.Value = pintMinReorderLevel
        m_dsData = New dsNw
        Try
            'Fill the Products table with records from the database.
            m_daProducts.Fill(m_dsData, "Products")
        Catch ex As Exception
            'Don't generate a message here that needs to go to the
            'user interface; that won't work later if we move this class
            'to a separate DLL running on a different machine from
            'the UI. Instead, pass the exception back to the UI and
            'let the UI produce the message.
            Throw ex
        End Try

        'Get products into a module-scoped arraylist. We'll use this arraylist later for comparisons
        'when the front end returns a modified version of it.
        m_arlProducts = GetArraylistOfProducts(m_dsData)

        'If m_arlProducts is returned from this function, changes to the arraylist made in the user
        'interface ripple through to the arraylist here - which we don't want, since we need the original
        'for comparisons later.. Therefore we must create a new local, throwaway clone of the arrayList
        'to return.
        Dim arlProducts As New ArrayList
        arlProducts = m_arlProducts.Clone()
        GetProducts = arlProducts

    End Function

    Private Function GetArraylistOfProducts(ByVal m_dsData As dsNw) As ArrayList
        'Package data from Products DataTable as an arraylist of objects
        Dim arlProducts As New ArrayList
        Dim tblProducts As New DataTable
        Dim rowProduct As DataRow
        tblProducts = m_dsData.Products
        For Each rowProduct In tblProducts.Rows
            arlProducts.Add( _
                New Product( _
                    rowProduct("ProductId"), _
                    rowProduct("ProductName"), _
                    rowProduct("UnitsInStock"), _
                    rowProduct("UnitsOnOrder"), _
                    rowProduct("ReorderLevel") _
                    ) _
                )
        Next
        GetArraylistOfProducts = arlProducts
    End Function

    Public ReadOnly Property NumberOfProducts()
        Get
            NumberOfProducts = m_arlProducts.Count
        End Get
    End Property
End Class
