Public Class frmMain
    Inherits System.Windows.Forms.Form

    Dim m_arlObjects As ArrayList
    Dim m_intPosition As Int32 = 0
    'Declare strongly typed DataSet object; this will permit
    'bindings to be set using strongly-typed syntax, e.g.
    '       BindingContext(Me.m_dsData.Products)
    'instead of
    '       BindingContext(Me.m_dsData, "Products")
    Dim m_dsData As dsNw

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents btnNavFirst As System.Windows.Forms.Button
    Friend WithEvents btnNavPrev As System.Windows.Forms.Button
    Friend WithEvents lblNavLocation As System.Windows.Forms.Label
    Friend WithEvents btnNavNext As System.Windows.Forms.Button
    Friend WithEvents btnNavLast As System.Windows.Forms.Button
    Friend WithEvents txtProductName As System.Windows.Forms.TextBox
    Friend WithEvents txtQtyOnHand As System.Windows.Forms.TextBox
    Friend WithEvents txtQtyOnOrder As System.Windows.Forms.TextBox
    Friend WithEvents txtReorderLevel As System.Windows.Forms.TextBox
    Friend WithEvents grpLoadRecords As System.Windows.Forms.GroupBox
    Friend WithEvents btnRetrieveRecords As System.Windows.Forms.Button
    Friend WithEvents nudMinimumReorderLevel As System.Windows.Forms.NumericUpDown
    Friend WithEvents lblProduct As System.Windows.Forms.Label
    Friend WithEvents lblQtyOnHand As System.Windows.Forms.Label
    Friend WithEvents lblQtyOnOrder As System.Windows.Forms.Label
    Friend WithEvents lblReorderLevel As System.Windows.Forms.Label
    Friend WithEvents lblSpecifyMinRecorder As System.Windows.Forms.Label
    Friend WithEvents lblDataGridView As System.Windows.Forms.Label
    Friend WithEvents btnSaveChanges As System.Windows.Forms.Button
    Friend WithEvents chkDiscontinued As System.Windows.Forms.CheckBox
    Friend WithEvents grdProducts As System.Windows.Forms.DataGrid
    Friend WithEvents btnAdd As System.Windows.Forms.Button
    Friend WithEvents btnDelete As System.Windows.Forms.Button
    Friend WithEvents btnCancel As System.Windows.Forms.Button
    Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
    Friend WithEvents mnuFile As System.Windows.Forms.MenuItem
    Friend WithEvents mnuFile_Exit As System.Windows.Forms.MenuItem
    Friend WithEvents mnuHelp As System.Windows.Forms.MenuItem
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.txtProductName = New System.Windows.Forms.TextBox
    Me.txtQtyOnHand = New System.Windows.Forms.TextBox
    Me.txtQtyOnOrder = New System.Windows.Forms.TextBox
    Me.txtReorderLevel = New System.Windows.Forms.TextBox
    Me.lblProduct = New System.Windows.Forms.Label
    Me.lblQtyOnHand = New System.Windows.Forms.Label
    Me.lblQtyOnOrder = New System.Windows.Forms.Label
    Me.lblReorderLevel = New System.Windows.Forms.Label
    Me.btnNavFirst = New System.Windows.Forms.Button
    Me.btnNavPrev = New System.Windows.Forms.Button
    Me.lblNavLocation = New System.Windows.Forms.Label
    Me.btnNavNext = New System.Windows.Forms.Button
    Me.btnNavLast = New System.Windows.Forms.Button
    Me.grpLoadRecords = New System.Windows.Forms.GroupBox
    Me.btnRetrieveRecords = New System.Windows.Forms.Button
    Me.lblSpecifyMinRecorder = New System.Windows.Forms.Label
    Me.nudMinimumReorderLevel = New System.Windows.Forms.NumericUpDown
    Me.lblDataGridView = New System.Windows.Forms.Label
    Me.btnSaveChanges = New System.Windows.Forms.Button
    Me.chkDiscontinued = New System.Windows.Forms.CheckBox
    Me.grdProducts = New System.Windows.Forms.DataGrid
    Me.btnAdd = New System.Windows.Forms.Button
    Me.btnDelete = New System.Windows.Forms.Button
    Me.btnCancel = New System.Windows.Forms.Button
    Me.MainMenu1 = New System.Windows.Forms.MainMenu
    Me.mnuFile = New System.Windows.Forms.MenuItem
    Me.mnuFile_Exit = New System.Windows.Forms.MenuItem
    Me.mnuHelp = New System.Windows.Forms.MenuItem
    Me.grpLoadRecords.SuspendLayout()
    CType(Me.nudMinimumReorderLevel, System.ComponentModel.ISupportInitialize).BeginInit()
    CType(Me.grdProducts, System.ComponentModel.ISupportInitialize).BeginInit()
    Me.SuspendLayout()
    '
    'txtProductName
    '
    Me.txtProductName.Location = New System.Drawing.Point(128, 96)
    Me.txtProductName.Name = "txtProductName"
    Me.txtProductName.Size = New System.Drawing.Size(144, 20)
    Me.txtProductName.TabIndex = 2
    Me.txtProductName.Text = ""
    '
    'txtQtyOnHand
    '
    Me.txtQtyOnHand.Location = New System.Drawing.Point(376, 96)
    Me.txtQtyOnHand.Name = "txtQtyOnHand"
    Me.txtQtyOnHand.Size = New System.Drawing.Size(40, 20)
    Me.txtQtyOnHand.TabIndex = 4
    Me.txtQtyOnHand.Text = ""
    '
    'txtQtyOnOrder
    '
    Me.txtQtyOnOrder.Location = New System.Drawing.Point(376, 128)
    Me.txtQtyOnOrder.Name = "txtQtyOnOrder"
    Me.txtQtyOnOrder.Size = New System.Drawing.Size(40, 20)
    Me.txtQtyOnOrder.TabIndex = 7
    Me.txtQtyOnOrder.Text = ""
    '
    'txtReorderLevel
    '
    Me.txtReorderLevel.Location = New System.Drawing.Point(376, 160)
    Me.txtReorderLevel.Name = "txtReorderLevel"
    Me.txtReorderLevel.Size = New System.Drawing.Size(40, 20)
    Me.txtReorderLevel.TabIndex = 9
    Me.txtReorderLevel.Text = ""
    '
    'lblProduct
    '
    Me.lblProduct.Location = New System.Drawing.Point(40, 96)
    Me.lblProduct.Name = "lblProduct"
    Me.lblProduct.Size = New System.Drawing.Size(80, 23)
    Me.lblProduct.TabIndex = 1
    Me.lblProduct.Text = "Towar"
    '
    'lblQtyOnHand
    '
    Me.lblQtyOnHand.Location = New System.Drawing.Point(288, 96)
    Me.lblQtyOnHand.Name = "lblQtyOnHand"
    Me.lblQtyOnHand.Size = New System.Drawing.Size(80, 23)
    Me.lblQtyOnHand.TabIndex = 3
    Me.lblQtyOnHand.Text = "Ilo w mag."
    '
    'lblQtyOnOrder
    '
    Me.lblQtyOnOrder.Location = New System.Drawing.Point(288, 128)
    Me.lblQtyOnOrder.Name = "lblQtyOnOrder"
    Me.lblQtyOnOrder.Size = New System.Drawing.Size(80, 23)
    Me.lblQtyOnOrder.TabIndex = 6
    Me.lblQtyOnOrder.Text = "Ilo w zam."
    '
    'lblReorderLevel
    '
    Me.lblReorderLevel.Location = New System.Drawing.Point(288, 160)
    Me.lblReorderLevel.Name = "lblReorderLevel"
    Me.lblReorderLevel.Size = New System.Drawing.Size(80, 23)
    Me.lblReorderLevel.TabIndex = 8
    Me.lblReorderLevel.Text = "Poziom zam."
    '
    'btnNavFirst
    '
    Me.btnNavFirst.Location = New System.Drawing.Point(104, 208)
    Me.btnNavFirst.Name = "btnNavFirst"
    Me.btnNavFirst.Size = New System.Drawing.Size(40, 23)
    Me.btnNavFirst.TabIndex = 10
    Me.btnNavFirst.Text = "<<"
    '
    'btnNavPrev
    '
    Me.btnNavPrev.Location = New System.Drawing.Point(144, 208)
    Me.btnNavPrev.Name = "btnNavPrev"
    Me.btnNavPrev.Size = New System.Drawing.Size(35, 23)
    Me.btnNavPrev.TabIndex = 11
    Me.btnNavPrev.Text = "<"
    '
    'lblNavLocation
    '
    Me.lblNavLocation.BackColor = System.Drawing.Color.White
    Me.lblNavLocation.Location = New System.Drawing.Point(184, 208)
    Me.lblNavLocation.Name = "lblNavLocation"
    Me.lblNavLocation.Size = New System.Drawing.Size(95, 23)
    Me.lblNavLocation.TabIndex = 12
    Me.lblNavLocation.Text = "Brak rekordw"
    Me.lblNavLocation.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
    '
    'btnNavNext
    '
    Me.btnNavNext.Location = New System.Drawing.Point(280, 208)
    Me.btnNavNext.Name = "btnNavNext"
    Me.btnNavNext.Size = New System.Drawing.Size(35, 23)
    Me.btnNavNext.TabIndex = 13
    Me.btnNavNext.Text = ">"
    '
    'btnNavLast
    '
    Me.btnNavLast.Location = New System.Drawing.Point(312, 208)
    Me.btnNavLast.Name = "btnNavLast"
    Me.btnNavLast.Size = New System.Drawing.Size(40, 23)
    Me.btnNavLast.TabIndex = 14
    Me.btnNavLast.Text = ">>"
    '
    'grpLoadRecords
    '
    Me.grpLoadRecords.Controls.Add(Me.btnRetrieveRecords)
    Me.grpLoadRecords.Controls.Add(Me.lblSpecifyMinRecorder)
    Me.grpLoadRecords.Controls.Add(Me.nudMinimumReorderLevel)
    Me.grpLoadRecords.Location = New System.Drawing.Point(24, 16)
    Me.grpLoadRecords.Name = "grpLoadRecords"
    Me.grpLoadRecords.Size = New System.Drawing.Size(392, 64)
    Me.grpLoadRecords.TabIndex = 0
    Me.grpLoadRecords.TabStop = False
    Me.grpLoadRecords.Text = "adowanie rekordw"
    '
    'btnRetrieveRecords
    '
    Me.btnRetrieveRecords.Location = New System.Drawing.Point(264, 24)
    Me.btnRetrieveRecords.Name = "btnRetrieveRecords"
    Me.btnRetrieveRecords.Size = New System.Drawing.Size(120, 23)
    Me.btnRetrieveRecords.TabIndex = 2
    Me.btnRetrieveRecords.Text = "Pobierz rekordy"
    '
    'lblSpecifyMinRecorder
    '
    Me.lblSpecifyMinRecorder.Location = New System.Drawing.Point(8, 32)
    Me.lblSpecifyMinRecorder.Name = "lblSpecifyMinRecorder"
    Me.lblSpecifyMinRecorder.Size = New System.Drawing.Size(200, 23)
    Me.lblSpecifyMinRecorder.TabIndex = 0
    Me.lblSpecifyMinRecorder.Text = "Okrel minimalny poziom zamwienia"
    '
    'nudMinimumReorderLevel
    '
    Me.nudMinimumReorderLevel.Increment = New Decimal(New Integer() {5, 0, 0, 0})
    Me.nudMinimumReorderLevel.Location = New System.Drawing.Point(208, 24)
    Me.nudMinimumReorderLevel.Name = "nudMinimumReorderLevel"
    Me.nudMinimumReorderLevel.Size = New System.Drawing.Size(48, 20)
    Me.nudMinimumReorderLevel.TabIndex = 1
    Me.nudMinimumReorderLevel.Value = New Decimal(New Integer() {5, 0, 0, 0})
    '
    'lblDataGridView
    '
    Me.lblDataGridView.Location = New System.Drawing.Point(24, 280)
    Me.lblDataGridView.Name = "lblDataGridView"
    Me.lblDataGridView.Size = New System.Drawing.Size(312, 23)
    Me.lblDataGridView.TabIndex = 15
    Me.lblDataGridView.Text = "Podgld towarw w formancie DataGrid: (Tylko do odczytu)"
    Me.lblDataGridView.TextAlign = System.Drawing.ContentAlignment.BottomLeft
    '
    'btnSaveChanges
    '
    Me.btnSaveChanges.Location = New System.Drawing.Point(168, 472)
    Me.btnSaveChanges.Name = "btnSaveChanges"
    Me.btnSaveChanges.Size = New System.Drawing.Size(120, 23)
    Me.btnSaveChanges.TabIndex = 17
    Me.btnSaveChanges.Text = "Zapisz zmiany"
    '
    'chkDiscontinued
    '
    Me.chkDiscontinued.Location = New System.Drawing.Point(128, 128)
    Me.chkDiscontinued.Name = "chkDiscontinued"
    Me.chkDiscontinued.TabIndex = 5
    Me.chkDiscontinued.Text = "Wycofany"
    '
    'grdProducts
    '
    Me.grdProducts.DataMember = ""
    Me.grdProducts.HeaderForeColor = System.Drawing.SystemColors.ControlText
    Me.grdProducts.Location = New System.Drawing.Point(24, 312)
    Me.grdProducts.Name = "grdProducts"
    Me.grdProducts.Size = New System.Drawing.Size(408, 144)
    Me.grdProducts.TabIndex = 16
    '
    'btnAdd
    '
    Me.btnAdd.Location = New System.Drawing.Point(80, 240)
    Me.btnAdd.Name = "btnAdd"
    Me.btnAdd.Size = New System.Drawing.Size(96, 23)
    Me.btnAdd.TabIndex = 18
    Me.btnAdd.Text = "Dodaj"
    '
    'btnDelete
    '
    Me.btnDelete.Location = New System.Drawing.Point(176, 240)
    Me.btnDelete.Name = "btnDelete"
    Me.btnDelete.Size = New System.Drawing.Size(96, 23)
    Me.btnDelete.TabIndex = 19
    Me.btnDelete.Text = "Usu"
    '
    'btnCancel
    '
    Me.btnCancel.Location = New System.Drawing.Point(272, 240)
    Me.btnCancel.Name = "btnCancel"
    Me.btnCancel.Size = New System.Drawing.Size(96, 23)
    Me.btnCancel.TabIndex = 20
    Me.btnCancel.Text = "Anuluj zmiany"
    '
    'MainMenu1
    '
    Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile, Me.mnuHelp})
    '
    'mnuFile
    '
    Me.mnuFile.Index = 0
    Me.mnuFile.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile_Exit})
    Me.mnuFile.Text = "&Plik"
    '
    'mnuFile_Exit
    '
    Me.mnuFile_Exit.Index = 0
    Me.mnuFile_Exit.Text = "&Koniec"
    '
    'mnuHelp
    '
    Me.mnuHelp.Index = 1
    Me.mnuHelp.Text = "P&omoc"
    '
    'frmMain
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(456, 514)
    Me.Controls.Add(Me.btnCancel)
    Me.Controls.Add(Me.btnAdd)
    Me.Controls.Add(Me.btnDelete)
    Me.Controls.Add(Me.grdProducts)
    Me.Controls.Add(Me.chkDiscontinued)
    Me.Controls.Add(Me.lblDataGridView)
    Me.Controls.Add(Me.grpLoadRecords)
    Me.Controls.Add(Me.btnNavFirst)
    Me.Controls.Add(Me.btnNavPrev)
    Me.Controls.Add(Me.lblNavLocation)
    Me.Controls.Add(Me.btnNavNext)
    Me.Controls.Add(Me.btnNavLast)
    Me.Controls.Add(Me.lblReorderLevel)
    Me.Controls.Add(Me.lblQtyOnOrder)
    Me.Controls.Add(Me.lblQtyOnHand)
    Me.Controls.Add(Me.lblProduct)
    Me.Controls.Add(Me.txtReorderLevel)
    Me.Controls.Add(Me.txtQtyOnOrder)
    Me.Controls.Add(Me.txtQtyOnHand)
    Me.Controls.Add(Me.txtProductName)
    Me.Controls.Add(Me.btnSaveChanges)
    Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.Fixed3D
    Me.Menu = Me.MainMenu1
    Me.Name = "frmMain"
    Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
    Me.Text = "BindToADataTable"
    Me.grpLoadRecords.ResumeLayout(False)
    CType(Me.nudMinimumReorderLevel, System.ComponentModel.ISupportInitialize).EndInit()
    CType(Me.grdProducts, System.ComponentModel.ISupportInitialize).EndInit()
    Me.ResumeLayout(False)

  End Sub

#End Region

    Private Sub frmMain_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'We'll need an instantiated object based on the dsNw
        'dataset class in order to establish our data bindings.
        m_dsData = New dsNw
        SetBindings()
    End Sub

    Private Sub btnNavFirst_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNavFirst.Click
        Me.BindingContext(Me.m_dsData.Products).Position = 0
        UpdateRecordPositionDisplay()
    End Sub

    Private Sub btnNavLast_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNavLast.Click
        Me.BindingContext(Me.m_dsData.Products).Position = Me.BindingContext(Me.m_dsData.Products).Count - 1
        UpdateRecordPositionDisplay()
    End Sub

    Private Sub btnNavPrev_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNavPrev.Click
        Me.BindingContext(Me.m_dsData.Products).Position = Me.BindingContext(Me.m_dsData.Products).Position - 1
        UpdateRecordPositionDisplay()
    End Sub

    Private Sub btnNavNext_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnNavNext.Click
        Me.BindingContext(Me.m_dsData.Products).Position = Me.BindingContext(Me.m_dsData.Products).Position + 1
        UpdateRecordPositionDisplay()
    End Sub

    Private Sub UpdateRecordPositionDisplay()
        Dim strRecordCount As String
        Dim strRecordPosition As String
        strRecordCount = CType(Me.BindingContext(Me.m_dsData.Products).Count, String)
        strRecordPosition = Me.BindingContext(Me.m_dsData.Products).Position + 1
    Me.lblNavLocation.Text = "Rekord " & strRecordPosition & " z  " & strRecordCount
    End Sub

    Private Sub ClearBindings()
        Me.txtProductName.DataBindings.Clear()
        Me.txtQtyOnHand.DataBindings.Clear()
        Me.txtQtyOnOrder.DataBindings.Clear()
        Me.txtReorderLevel.DataBindings.Clear()
        Me.chkDiscontinued.DataBindings.Clear()
    End Sub

    Private Sub SetBindings()

        Me.txtProductName.DataBindings.Add( _
            New Binding("Text", m_dsData.Products, "ProductName"))

        Me.txtQtyOnHand.DataBindings.Add( _
            New Binding("Text", m_dsData.Products, "UnitsInStock"))

        Me.txtQtyOnOrder.DataBindings.Add( _
            New Binding("Text", m_dsData.Products, "UnitsOnOrder"))

        Me.txtReorderLevel.DataBindings.Add( _
            New Binding("Text", m_dsData.Products, "ReorderLevel"))

        'Me.chkDiscontinued.DataBindings.Add( _
        '    New Binding("Checked", m_dsData.Products, "Discontinued"))

        Me.grdProducts.DataSource = m_dsData.Products

    End Sub

    Private Sub btnRetrieveRecords_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnRetrieveRecords.Click
        Dim objData As New Data

        If False Then
            'As you can see, this section of code doesn't currently get 
            'executed.It() 's included here to make a point, and you 
            'can experiment with it ifyou like by changing the 
            'If statement to check True instead of False.  If you 
            'choose to do that, you might also want to comment out
            'the calls to ClearBindings() and SetBindings the first
            'time to see what happens without them.
            '
            'About this section of code:
            '
            'We set our bindings in the form's load event to m_dsData.
            'If we now point m_dsData at a new DataSet, we will 
            'have to clear and reset 'those bindings.
            Try
                m_dsData = objData.GetData(CType(Me.nudMinimumReorderLevel.Text, Int32))
                objData = Nothing
            Catch ex As Exception
                MessageBox.Show(ex.Message)
            End Try
            ClearBindings()
            SetBindings()
        Else
            'This is a better way. Instead of setting m_dsData
            'to the DataSet returned by our Data class, we'll
            'create a temporary DataSet for that purpose, then
            'merge its contents into m_dsData after first clearing
            'existing data there. Thus m_dsData ends up with only
            'the records returned by objData.
            '
            'Since m_dsData never gets reset to a new DataSet,
            'the bindings remain intact.
            Try
                Dim dsTemp As New dsNw
                dsTemp = objData.GetData(CType(Me.nudMinimumReorderLevel.Text, Int32))
                objData = Nothing
                m_dsData.Clear()
                m_dsData.Merge(dsTemp)
            Catch ex As Exception
                MessageBox.Show(ex.Message)
            End Try
        End If

        UpdateRecordPositionDisplay()

    End Sub

    Private Sub grdProducts_CurrentCellChanged(ByVal sender As System.Object, ByVal e As System.EventArgs)
        'Make sure the record position display keeps up with 
        'position changes made in the DataGrid as well as by
        'means of the provided navigational buttons.
        UpdateRecordPositionDisplay()
    End Sub

    Private Sub btnSaveChanges_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSaveChanges.Click
        Dim objData As New Data
        Dim intRowsChanged As Int32 = 0
        Dim intRowsUpdated As Int32 = 0
        Dim dsChangedRows As dsNw
        Me.BindingContext(m_dsData.Products).EndCurrentEdit()
        dsChangedRows = m_dsData.GetChanges()
        intRowsChanged = dsChangedRows.Products.Rows.Count
        Try
            intRowsUpdated = objData.SaveData(dsChangedRows)
            If intRowsChanged <> intRowsUpdated Then
                Dim strMsg As String
                strMsg = intRowsUpdated & " of " & intRowsChanged
                strMsg &= " rows were updated."
                MessageBox.Show(strMsg)
            End If
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub

    Private Sub btnAdd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAdd.Click
        Try
            Me.BindingContext(m_dsData.Products).EndCurrentEdit()
            Me.BindingContext(m_dsData.Products).AddNew()
        Catch eEndEdit As System.Exception
            System.Windows.Forms.MessageBox.Show(eEndEdit.Message)
        End Try
        Me.UpdateRecordPositionDisplay()
    End Sub

    Private Sub btnDelete_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDelete.Click
        If (Me.BindingContext(m_dsData.Products).Count > 0) Then
            Me.BindingContext(m_dsData.Products).RemoveAt(Me.BindingContext(m_dsData.Products).Position)
            Me.UpdateRecordPositionDisplay()
        End If
    End Sub

    Private Sub btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        Me.BindingContext(m_dsData.Products).CancelCurrentEdit()
        Me.UpdateRecordPositionDisplay()
    End Sub

    Private Sub mnuFile_Exit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuFile_Exit.Click
        Me.Close()
    End Sub

    Private Sub mnuHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuHelp.Click
        Dim frmX As New frmHelp("..\zzReadMe.txt")
        frmX.Show()
    End Sub
End Class
