Imports System.Data.SqlClient

Public Class Data
    Dim conNw As SqlConnection
    Dim daProducts As SqlDataAdapter
    Dim prmMinReorderLevel As SqlParameter

    Public Sub New()

        'Declare and initialize Connection, Command, Parameter,
        'and DataAdapter objects to be used in data retrieval and updating

        Dim strConn As String
        Dim prmProductName As SqlParameter
        Dim prmUnitsInStock As SqlParameter
        Dim prmUnitsOnOrder As SqlParameter
        Dim prmReorderLevel As SqlParameter

        conNw = New SqlConnection
        strConn = "workstation id=DIM4300;packet size=4096;"
        strConn &= "integrated security=SSPI;data source=""(local)"";"
        strConn &= "persist security info=False;initial catalog=Northwind"
        conNw.ConnectionString = strConn

        'Set up the SELECT command
        '--------------------------------
        Dim cmdProductSelect As SqlCommand
        cmdProductSelect = New SqlCommand
        cmdProductSelect.CommandType = CommandType.Text
        cmdProductSelect.Connection = conNw

        Dim strCommandText As String
        strCommandText = "SELECT ProductID, ProductName, "
        strCommandText &= "UnitsInStock, UnitsOnOrder, ReorderLevel "
        strCommandText &= "FROM dbo.Products "
        strCommandText &= "WHERE ReorderLevel >= @MinReorderLevel "
        cmdProductSelect.CommandText = strCommandText

        prmMinReorderLevel = New SqlParameter("@MinReorderLevel", SqlDbType.Int)
        cmdProductSelect.Parameters.Add(prmMinReorderLevel)

        'Set up the UPDATE command
        '--------------------------------
        Dim cmdProductUpdate As SqlCommand
        cmdProductUpdate = New SqlCommand
        cmdProductUpdate.CommandType = CommandType.Text
        cmdProductUpdate.Connection = conNw

        strCommandText = "UPDATE dbo.Products SET "
        strCommandText &= "ProductName = @ProductName, "
        strCommandText &= "UnitsInStock = @UnitsInStock, "
        strCommandText &= "UnitsOnOrder = @UnitsOnOrder, "
        strCommandText &= "ReorderLevel = @ReorderLevel "
        strCommandText &= "WHERE ProductId = @ProductId "
        cmdProductUpdate.CommandText = strCommandText

        prmProductName = New SqlParameter("@ProductName", SqlDbType.NVarChar, 40, "ProductName")
        cmdProductUpdate.Parameters.Add(prmProductName)

        prmUnitsInStock = New SqlParameter("@UnitsInStock", SqlDbType.SmallInt, 2, "UnitsInStock")
        cmdProductUpdate.Parameters.Add(prmUnitsInStock)

        prmUnitsOnOrder = New SqlParameter("@UnitsOnOrder", SqlDbType.SmallInt, 2, "UnitsOnOrder")
        cmdProductUpdate.Parameters.Add(prmUnitsOnOrder)

        prmReorderLevel = New SqlParameter("@ReorderLevel", SqlDbType.SmallInt, 2, "ReorderLevel")
        cmdProductUpdate.Parameters.Add(prmReorderLevel)

        Dim prmProductId As SqlParameter
        If False Then
            'Our WHERE criterion for the update operation is a match on
            'the ProductId.  If we were sure the UI would keep the user from
            'changing the ProductId, we could get away with the following 
            'simple initialization of the ProductId parameter (similar to the
            'initializations done above for the other parameters):
            prmProductId = New SqlParameter("@ProductId", SqlDbType.Int, 4, "ProductId")
        Else
            'This version doesn't leave it to chance.  The record updated
            'will be the one whose ProductId matches the ProductId value
            'that the ProductId column *originally* had when it was 
            'retrieved from the database (or after the most recent execution
            'of the DataSet's AcceptChanges() method, whichever came
            'last.
            '
            'To do this requires that we use a different overload of the 
            'SqlParameter constructor. This overload allows us to 
            'specify the version of the DataRow from which we want to
            'get our value. Thrown into the mix are a few other
            'inputs we have to specify. The statement below is 
            'constructed exactly as it would be if we had used the
            'SqlDataAdapter Wizard to create it.
            prmProductId = New SqlParameter("@ProductID", System.Data.SqlDbType.Int, 4, System.Data.ParameterDirection.Input, False, CType(0, Byte), CType(0, Byte), "ProductID", System.Data.DataRowVersion.Original, Nothing)
        End If
        cmdProductUpdate.Parameters.Add(prmProductId)

        'Set up the INSERT command
        '--------------------------------
        Dim cmdProductInsert As SqlCommand
        cmdProductInsert = New SqlCommand
        cmdProductInsert.CommandType = CommandType.Text
        cmdProductInsert.Connection = conNw

        strCommandText = "INSERT INTO dbo.Products "
        strCommandText &= "(ProductName, UnitsInStock, "
        strCommandText &= "UnitsOnOrder, ReorderLevel, "
        strCommandText &= "Discontinued) "
        strCommandText &= "VALUES ("
        strCommandText &= "@ProductName, @UnitsInStock,"
        strCommandText &= "@UnitsOnOrder, @ReorderLevel, "
        strCommandText &= "@Discontinued) "
        'strCommandText &= ";SELECT ProductID, ProductName, "
        'strCommandText &= "UnitsInStock, UnitsOnOrder, ReorderLevel "
        'strCommandText &= "FROM Products "
        'strCommandText &= "WHERE (ProductID = @@IDENTITY)"

        cmdProductInsert.CommandText = strCommandText

        prmProductName = New SqlParameter("@ProductName", SqlDbType.NVarChar, 40, "ProductName")
        cmdProductInsert.Parameters.Add(prmProductName)

        prmUnitsInStock = New SqlParameter("@UnitsInStock", SqlDbType.SmallInt, 2, "UnitsInStock")
        cmdProductInsert.Parameters.Add(prmUnitsInStock)

        prmUnitsOnOrder = New SqlParameter("@UnitsOnOrder", SqlDbType.SmallInt, 2, "UnitsOnOrder")
        cmdProductInsert.Parameters.Add(prmUnitsOnOrder)

        prmReorderLevel = New SqlParameter("@ReorderLevel", SqlDbType.SmallInt, 2, "ReorderLevel")
        cmdProductInsert.Parameters.Add(prmReorderLevel)

        'The boolean "Discontinued" column in the Products table, which we did not
        'retrieve for this form, requires a value. We'll simply default it to 0.
        Dim prmDiscontinued As SqlParameter
        prmDiscontinued = New SqlParameter("@Discontinued", SqlDbType.Bit)
        prmDiscontinued.Value = 0
        cmdProductInsert.Parameters.Add(prmDiscontinued)

        'Set up the DELETE command
        '--------------------------------
        Dim cmdProductDelete As SqlCommand
        cmdProductDelete = New SqlCommand
        cmdProductDelete.CommandType = CommandType.Text
        cmdProductDelete.Connection = conNw

        strCommandText = "DELETE FROM dbo.Products "
        strCommandText &= "WHERE ProductID = @ProductID"
        cmdProductDelete.CommandText = strCommandText

        prmProductId = New SqlParameter("@ProductID", System.Data.SqlDbType.Int, 4, System.Data.ParameterDirection.Input, False, CType(0, Byte), CType(0, Byte), "ProductID", System.Data.DataRowVersion.Original, Nothing)
        cmdProductDelete.Parameters.Add(prmProductId)

        daProducts = New SqlDataAdapter
        daProducts.SelectCommand = cmdProductSelect
        daProducts.UpdateCommand = cmdProductUpdate
        daProducts.InsertCommand = cmdProductInsert
        daProducts.DeleteCommand = cmdProductDelete

    End Sub

    Public Function GetData(ByVal pintMinReorderLevel As Int32)

        prmMinReorderLevel.Value = pintMinReorderLevel
        Dim dsData As New dsNw
        Try
            daProducts.Fill(dsData, "Products")
        Catch ex As Exception
            'Don't generate a message here that needs to go to the
            'user interface; that won't work later if we move this class
            'to a separate DLL running on a different machine from
            'the UI. Instead, pass the exception back to the UI and
            'let the UI produce the message.
            Throw ex
        End Try
        GetData = dsData

    End Function

    Public Function SaveData(ByVal pdsChangedRows As dsNw) As Int32

        Dim intRowsUpdated As Int32 = -1
        Try
            intRowsUpdated = daProducts.Update(pdsChangedRows.Products)
        Catch ex As Exception
            Throw ex
        End Try
        SaveData = intRowsUpdated

    End Function

End Class
