Public Class frmMain
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents btnAddRecord As System.Windows.Forms.Button
    Friend WithEvents btnRejectChanges As System.Windows.Forms.Button
    Friend WithEvents daProducts As System.Data.SqlClient.SqlDataAdapter
    Friend WithEvents conNw As System.Data.SqlClient.SqlConnection
    Friend WithEvents objdsNw As TransactionsAndDataSets.dsNw
    Friend WithEvents grdProducts As System.Windows.Forms.DataGrid
    Friend WithEvents btnLoadData As System.Windows.Forms.Button
    Friend WithEvents cmdProductsSelect As System.Data.SqlClient.SqlCommand
    Friend WithEvents cmdProductsInsert As System.Data.SqlClient.SqlCommand
    Friend WithEvents cmdProductsUpdate As System.Data.SqlClient.SqlCommand
    Friend WithEvents cmdProductsDelete As System.Data.SqlClient.SqlCommand
    Friend WithEvents chkUpdateBackEnd As System.Windows.Forms.CheckBox
    Friend WithEvents chkWrapInTransaction As System.Windows.Forms.CheckBox
    Friend WithEvents grpOptionsForAdd As System.Windows.Forms.GroupBox
    Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
    Friend WithEvents mnuFile As System.Windows.Forms.MenuItem
    Friend WithEvents mnuFile_Exit As System.Windows.Forms.MenuItem
    Friend WithEvents mnuHelp As System.Windows.Forms.MenuItem
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.btnAddRecord = New System.Windows.Forms.Button
        Me.grdProducts = New System.Windows.Forms.DataGrid
        Me.btnRejectChanges = New System.Windows.Forms.Button
        Me.daProducts = New System.Data.SqlClient.SqlDataAdapter
        Me.cmdProductsDelete = New System.Data.SqlClient.SqlCommand
        Me.conNw = New System.Data.SqlClient.SqlConnection
        Me.cmdProductsInsert = New System.Data.SqlClient.SqlCommand
        Me.cmdProductsSelect = New System.Data.SqlClient.SqlCommand
        Me.cmdProductsUpdate = New System.Data.SqlClient.SqlCommand
        Me.objdsNw = New TransactionsAndDataSets.dsNw
        Me.chkUpdateBackEnd = New System.Windows.Forms.CheckBox
        Me.chkWrapInTransaction = New System.Windows.Forms.CheckBox
        Me.grpOptionsForAdd = New System.Windows.Forms.GroupBox
        Me.btnLoadData = New System.Windows.Forms.Button
        Me.MainMenu1 = New System.Windows.Forms.MainMenu
        Me.mnuFile = New System.Windows.Forms.MenuItem
        Me.mnuFile_Exit = New System.Windows.Forms.MenuItem
        Me.mnuHelp = New System.Windows.Forms.MenuItem
        CType(Me.grdProducts, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.objdsNw, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.grpOptionsForAdd.SuspendLayout()
        Me.SuspendLayout()
        '
        'btnAddRecord
        '
        Me.btnAddRecord.Location = New System.Drawing.Point(16, 96)
        Me.btnAddRecord.Name = "btnAddRecord"
        Me.btnAddRecord.Size = New System.Drawing.Size(288, 23)
        Me.btnAddRecord.TabIndex = 2
        Me.btnAddRecord.Text = "Add Record"
        '
        'grdProducts
        '
        Me.grdProducts.DataMember = ""
        Me.grdProducts.HeaderForeColor = System.Drawing.SystemColors.ControlText
        Me.grdProducts.Location = New System.Drawing.Point(24, 216)
        Me.grdProducts.Name = "grdProducts"
        Me.grdProducts.Size = New System.Drawing.Size(320, 152)
        Me.grdProducts.TabIndex = 2
        '
        'btnRejectChanges
        '
        Me.btnRejectChanges.Location = New System.Drawing.Point(24, 384)
        Me.btnRejectChanges.Name = "btnRejectChanges"
        Me.btnRejectChanges.Size = New System.Drawing.Size(320, 23)
        Me.btnRejectChanges.TabIndex = 3
        Me.btnRejectChanges.Text = "Reject Changes in the DataSet"
        '
        'daProducts
        '
        Me.daProducts.DeleteCommand = Me.cmdProductsDelete
        Me.daProducts.InsertCommand = Me.cmdProductsInsert
        Me.daProducts.SelectCommand = Me.cmdProductsSelect
        Me.daProducts.TableMappings.AddRange(New System.Data.Common.DataTableMapping() {New System.Data.Common.DataTableMapping("Table", "Products", New System.Data.Common.DataColumnMapping() {New System.Data.Common.DataColumnMapping("ProductID", "ProductID"), New System.Data.Common.DataColumnMapping("ProductName", "ProductName"), New System.Data.Common.DataColumnMapping("Discontinued", "Discontinued")})})
        Me.daProducts.UpdateCommand = Me.cmdProductsUpdate
        '
        'cmdProductsDelete
        '
        Me.cmdProductsDelete.CommandText = "DELETE FROM Products WHERE (ProductID = @Original_ProductID) AND (Discontinued = " & _
        "@Original_Discontinued) AND (ProductName = @Original_ProductName)"
        Me.cmdProductsDelete.Connection = Me.conNw
        Me.cmdProductsDelete.Parameters.Add(New System.Data.SqlClient.SqlParameter("@Original_ProductID", System.Data.SqlDbType.Int, 4, System.Data.ParameterDirection.Input, False, CType(0, Byte), CType(0, Byte), "ProductID", System.Data.DataRowVersion.Original, Nothing))
        Me.cmdProductsDelete.Parameters.Add(New System.Data.SqlClient.SqlParameter("@Original_Discontinued", System.Data.SqlDbType.Bit, 1, System.Data.ParameterDirection.Input, False, CType(0, Byte), CType(0, Byte), "Discontinued", System.Data.DataRowVersion.Original, Nothing))
        Me.cmdProductsDelete.Parameters.Add(New System.Data.SqlClient.SqlParameter("@Original_ProductName", System.Data.SqlDbType.NVarChar, 40, System.Data.ParameterDirection.Input, False, CType(0, Byte), CType(0, Byte), "ProductName", System.Data.DataRowVersion.Original, Nothing))
        '
        'conNw
        '
        Me.conNw.ConnectionString = "workstation id=DIM4300;packet size=4096;integrated security=SSPI;data source=""(lo" & _
        "cal)"";persist security info=False;initial catalog=Northwind"
        '
        'cmdProductsInsert
        '
        Me.cmdProductsInsert.CommandText = "INSERT INTO Products(ProductName, Discontinued) VALUES (@ProductName, @Discontinu" & _
        "ed); SELECT ProductID, ProductName, Discontinued FROM Products WHERE (ProductID " & _
        "= @@IDENTITY) ORDER BY ProductID DESC"
        Me.cmdProductsInsert.Connection = Me.conNw
        Me.cmdProductsInsert.Parameters.Add(New System.Data.SqlClient.SqlParameter("@ProductName", System.Data.SqlDbType.NVarChar, 40, "ProductName"))
        Me.cmdProductsInsert.Parameters.Add(New System.Data.SqlClient.SqlParameter("@Discontinued", System.Data.SqlDbType.Bit, 1, "Discontinued"))
        '
        'cmdProductsSelect
        '
        Me.cmdProductsSelect.CommandText = "SELECT ProductID, ProductName, Discontinued FROM Products ORDER BY ProductID DESC" & _
        ""
        Me.cmdProductsSelect.Connection = Me.conNw
        '
        'cmdProductsUpdate
        '
        Me.cmdProductsUpdate.CommandText = "UPDATE Products SET ProductName = @ProductName, Discontinued = @Discontinued WHER" & _
        "E (ProductID = @Original_ProductID) AND (Discontinued = @Original_Discontinued) " & _
        "AND (ProductName = @Original_ProductName); SELECT ProductID, ProductName, Discon" & _
        "tinued FROM Products WHERE (ProductID = @ProductID) ORDER BY ProductID DESC"
        Me.cmdProductsUpdate.Connection = Me.conNw
        Me.cmdProductsUpdate.Parameters.Add(New System.Data.SqlClient.SqlParameter("@ProductName", System.Data.SqlDbType.NVarChar, 40, "ProductName"))
        Me.cmdProductsUpdate.Parameters.Add(New System.Data.SqlClient.SqlParameter("@Discontinued", System.Data.SqlDbType.Bit, 1, "Discontinued"))
        Me.cmdProductsUpdate.Parameters.Add(New System.Data.SqlClient.SqlParameter("@Original_ProductID", System.Data.SqlDbType.Int, 4, System.Data.ParameterDirection.Input, False, CType(0, Byte), CType(0, Byte), "ProductID", System.Data.DataRowVersion.Original, Nothing))
        Me.cmdProductsUpdate.Parameters.Add(New System.Data.SqlClient.SqlParameter("@Original_Discontinued", System.Data.SqlDbType.Bit, 1, System.Data.ParameterDirection.Input, False, CType(0, Byte), CType(0, Byte), "Discontinued", System.Data.DataRowVersion.Original, Nothing))
        Me.cmdProductsUpdate.Parameters.Add(New System.Data.SqlClient.SqlParameter("@Original_ProductName", System.Data.SqlDbType.NVarChar, 40, System.Data.ParameterDirection.Input, False, CType(0, Byte), CType(0, Byte), "ProductName", System.Data.DataRowVersion.Original, Nothing))
        Me.cmdProductsUpdate.Parameters.Add(New System.Data.SqlClient.SqlParameter("@ProductID", System.Data.SqlDbType.Int, 4, "ProductID"))
        '
        'objdsNw
        '
        Me.objdsNw.DataSetName = "dsNw"
        Me.objdsNw.Locale = New System.Globalization.CultureInfo("en-US")
        '
        'chkUpdateBackEnd
        '
        Me.chkUpdateBackEnd.Location = New System.Drawing.Point(16, 24)
        Me.chkUpdateBackEnd.Name = "chkUpdateBackEnd"
        Me.chkUpdateBackEnd.Size = New System.Drawing.Size(192, 24)
        Me.chkUpdateBackEnd.TabIndex = 0
        Me.chkUpdateBackEnd.Text = "Update the back-end database"
        '
        'chkWrapInTransaction
        '
        Me.chkWrapInTransaction.Checked = True
        Me.chkWrapInTransaction.CheckState = System.Windows.Forms.CheckState.Checked
        Me.chkWrapInTransaction.Enabled = False
        Me.chkWrapInTransaction.Location = New System.Drawing.Point(16, 56)
        Me.chkWrapInTransaction.Name = "chkWrapInTransaction"
        Me.chkWrapInTransaction.Size = New System.Drawing.Size(280, 24)
        Me.chkWrapInTransaction.TabIndex = 1
        Me.chkWrapInTransaction.Text = "Wrap the update in a Transaction"
        '
        'grpOptionsForAdd
        '
        Me.grpOptionsForAdd.Controls.Add(Me.chkUpdateBackEnd)
        Me.grpOptionsForAdd.Controls.Add(Me.chkWrapInTransaction)
        Me.grpOptionsForAdd.Controls.Add(Me.btnAddRecord)
        Me.grpOptionsForAdd.Location = New System.Drawing.Point(24, 64)
        Me.grpOptionsForAdd.Name = "grpOptionsForAdd"
        Me.grpOptionsForAdd.Size = New System.Drawing.Size(320, 136)
        Me.grpOptionsForAdd.TabIndex = 1
        Me.grpOptionsForAdd.TabStop = False
        Me.grpOptionsForAdd.Text = "Select Options and Add a Record"
        '
        'btnLoadData
        '
        Me.btnLoadData.Location = New System.Drawing.Point(24, 16)
        Me.btnLoadData.Name = "btnLoadData"
        Me.btnLoadData.Size = New System.Drawing.Size(320, 23)
        Me.btnLoadData.TabIndex = 0
        Me.btnLoadData.Text = "Load Records from Back-End Database"
        '
        'MainMenu1
        '
        Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile, Me.mnuHelp})
        '
        'mnuFile
        '
        Me.mnuFile.Index = 0
        Me.mnuFile.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile_Exit})
        Me.mnuFile.Text = "&File"
        '
        'mnuFile_Exit
        '
        Me.mnuFile_Exit.Index = 0
        Me.mnuFile_Exit.Text = "E&xit"
        '
        'mnuHelp
        '
        Me.mnuHelp.Index = 1
        Me.mnuHelp.Text = "&Help"
        '
        'frmMain
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(368, 426)
        Me.Controls.Add(Me.btnLoadData)
        Me.Controls.Add(Me.grpOptionsForAdd)
        Me.Controls.Add(Me.btnRejectChanges)
        Me.Controls.Add(Me.grdProducts)
        Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.Fixed3D
        Me.Menu = Me.MainMenu1
        Me.Name = "frmMain"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = "Transaction and DataSets"
        CType(Me.grdProducts, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.objdsNw, System.ComponentModel.ISupportInitialize).EndInit()
        Me.grpOptionsForAdd.ResumeLayout(False)
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Enum enmDispositionTechnique
        Commit
        RollBack
        CloseConnection
    End Enum

    Private Sub btnLoadData_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnLoadData.Click
        Me.objdsNw.Products.Clear()
        Try
            Me.daProducts.Fill(Me.objdsNw.Products)
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub

    Private Sub frmRejectChanges_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Me.grdProducts.DataSource = Me.objdsNw.Products
    End Sub

    Private Sub btnAddRecord_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAddRecord.Click
        AddRecord()
    End Sub

    Private Sub AddRecord()
        Dim transX As SqlClient.SqlTransaction
        Me.objdsNw.Products.AddProductsRow("Foo Pellets", False)
        SortGrid()

        If Me.chkUpdateBackEnd.Checked Then
            If Me.chkWrapInTransaction.Checked Then
                Me.conNw.Open()
                transX = Me.conNw.BeginTransaction
                Me.cmdProductsInsert.Transaction = transX
            End If
            '----------------------------------------
            Me.daProducts.Update(Me.objdsNw)
            '----------------------------------------
            If Me.chkWrapInTransaction.Checked Then
                Dim DispositionTechnique As enmDispositionTechnique = IdentifyDispositionTechnique()
                Select Case DispositionTechnique
                    Case enmDispositionTechnique.Commit
                        transX.Commit()
                    Case enmDispositionTechnique.RollBack
                        transX.Rollback()
                    Case enmDispositionTechnique.CloseConnection
                        'Do nothing
                    Case Else
                        MessageBox.Show("[AddRecord()] Unknown option relating to the disposal of the transaction.")
                End Select
                Me.conNw.Close()
            End If
        End If

    End Sub

    Private Sub SortGrid()
        Me.objdsNw.Products.DefaultView.Sort = "ProductId DESC"
        Me.BindingContext(Me.objdsNw.Products).Position = 0
    End Sub

    Private Function IdentifyDispositionTechnique() As enmDispositionTechnique
        Dim frmGetDispositionTechnique As New frmSelectDispositionTechnique
        frmGetDispositionTechnique.ShowDialog()

        Dim DispositionTechnique As enmDispositionTechnique
        If frmGetDispositionTechnique.optTransCommit.Checked Then
            DispositionTechnique = enmDispositionTechnique.Commit
        ElseIf frmGetDispositionTechnique.optTransRollBack.Checked Then
            DispositionTechnique = enmDispositionTechnique.RollBack
        ElseIf frmGetDispositionTechnique.optTransForget.Checked Then
            DispositionTechnique = enmDispositionTechnique.CloseConnection
        Else
            MessageBox.Show("[IdentifyDispositionTechnique] Unknown DispositionTechnique of transaction disposition")
        End If

        frmGetDispositionTechnique.Close()
        Return DispositionTechnique
    End Function

    Private Sub btnRejectChanges_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnRejectChanges.Click
        Me.objdsNw.RejectChanges()
    End Sub

    Private Sub chkUpdateBackEnd_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkUpdateBackEnd.CheckedChanged
        If Me.chkUpdateBackEnd.Checked Then
            Me.chkWrapInTransaction.Enabled = True
            'SetenmDispositionTechniqueState()
        Else
            Me.chkWrapInTransaction.Enabled = False
            'Me.grpenmDispositionTechnique.Enabled = False
        End If
    End Sub

    'Private Sub chkWrapInTransaction_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkWrapInTransaction.CheckedChanged
    '    SetenmDispositionTechniqueState()
    'End Sub

    'Private Sub SetenmDispositionTechniqueState()
    '    If Me.chkWrapInTransaction.Checked = True Then
    '        Me.grpenmDispositionTechnique.Enabled = True
    '    Else
    '        Me.grpenmDispositionTechnique.Enabled = False
    '    End If
    'End Sub

    Private Sub mnuFile_Exit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuFile_Exit.Click
        Me.Close()
    End Sub

    Private Sub mnuHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles mnuHelp.Click
        Dim frmX As New frmHelp("..\zzReadMe.txt")
        frmX.Show()
    End Sub

End Class
