Public Class Class1
    Sub foo()

        'Create Order record
        Dim rowOrders As dsNw.OrdersRow = _
            Me.objdsNw.Orders.AddOrdersRow(Now)
        Me.cmdOrdersInsert.Transaction = transX
        Me.daOrders.Update(Me.objdsNw.Orders)

        'Create Order detail record
        Me.cmdOrderDetailsInsert.Transaction = transX
        Me.objdsNw.Order_Details.AddOrder_DetailsRow(rowOrders, Me.cboProduct.SelectedValue, Me.nudQty.Value)
        Me.daOrderDetails.Update(Me.objdsNw.Order_Details)

        'Decrement the inventory
        'Dim cmProducts As CurrencyManager = Me.BindingContext(Me.objdsNw.Products)
        'Dim rowProducts As DataRow
        Dim strMsg As String
        rowProducts = Me.objdsNw.Products.Rows(cmProducts.Position) 'current row
        If rowProducts("UnitsInStock") >= Me.nudQty.Value Then
            'There are sufficient units in inventory to fill the order, so decrement 
            'the UnitsInStock for the ordered product.
            rowProducts("UnitsInStock") -= Me.nudQty.Value
            Try
                Me.cmdProductsUpdate.Transaction = transX
                Me.daProducts.Update(Me.objdsNw.Products)
                'If the program got this far, all parts of the transaction were successful.
                'So, in a production app you would, you would Commit the transaction now.
                'In this app the Commit is subject to the setting of the chkCommitIfViable
                'checkbox so you can see that the changes are never placed in the database
                'unless the Commit is performed.
                If Me.chkCommitIfViable.Checked Then
                    transX.Commit()
                End If
                'Update on the DataSet is complete; clear the flags indicating there are
                'changes pending
                Me.objdsNw.AcceptChanges()
            Catch ex As Exception
                'There was an error during the attempt to update the Products table. 
                'Roll back the transaction...
                strMsg = ex.Message
                Try
                    transX.Rollback()
                Catch ex2 As Exception
                    strMsg += " (An exception of type " & ex.GetType().ToString()
                    strMsg += " was encountered while attempting to roll back the transaction.)"
                    strMsg += ControlChars.NewLine + ControlChars.NewLine
                    strMsg += ShowFailureInfoInDataSet()
                End Try
                MessageBox.Show(strMsg)
            Finally
                conNw.Close()
            End Try
            Me.objdsNw.Orders.DefaultView.Sort = "OrderDate DESC"
            Me.grdOrders.CurrentRowIndex = 0
            Me.tabMain.SelectedTab = Me.pagViewOrders
        Else  'rowProducts("UnitsInStock") >= Me.nudQty.Value was False
            'Not enough units in inventory to fulfill this order; roll it back.
            MessageBox.Show("Insufficient inventory - cancelling order.")
            Me.Refresh() 'Fully clears the message from the screen before the rollback is begun
            Try
                'Only the Orders and OrderDetails records have been added thus far
                transX.Rollback()
            Catch ex As Exception
                'Just in case there's an error during the rollback operation itself...
                MessageBox.Show(ex.Message)
            Finally
                conNw.Close()
            End Try
        End If   'rowProducts("UnitsInStock") >= Me.nudQty.Value

    End Sub
End Class
