Imports System.IO

Public Class TreeViewExample
  Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call

  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.IContainer

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  Friend WithEvents tvwExplorer As System.Windows.Forms.TreeView
  Friend WithEvents lvwExplorer As System.Windows.Forms.ListView
  Friend WithEvents colName As System.Windows.Forms.ColumnHeader
  Friend WithEvents colModified As System.Windows.Forms.ColumnHeader
  Friend WithEvents splExplorer As System.Windows.Forms.Splitter
  
  Private Sub InitializeComponent()
    Me.tvwExplorer = New System.Windows.Forms.TreeView
    Me.lvwExplorer = New System.Windows.Forms.ListView
    Me.colName = New System.Windows.Forms.ColumnHeader
    Me.colModified = New System.Windows.Forms.ColumnHeader
    Me.splExplorer = New System.Windows.Forms.Splitter
    Me.SuspendLayout()
    '
    'tvwExplorer
    '
    Me.tvwExplorer.Dock = System.Windows.Forms.DockStyle.Left
    Me.tvwExplorer.ImageIndex = -1
    Me.tvwExplorer.Location = New System.Drawing.Point(0, 0)
    Me.tvwExplorer.Name = "tvwExplorer"
    Me.tvwExplorer.SelectedImageIndex = -1
    Me.tvwExplorer.Size = New System.Drawing.Size(256, 438)
    Me.tvwExplorer.TabIndex = 0
    '
    'lvwExplorer
    '
    Me.lvwExplorer.Columns.AddRange(New System.Windows.Forms.ColumnHeader() {Me.colName, Me.colModified})
    Me.lvwExplorer.Dock = System.Windows.Forms.DockStyle.Fill
    Me.lvwExplorer.Location = New System.Drawing.Point(256, 0)
    Me.lvwExplorer.MultiSelect = False
    Me.lvwExplorer.Name = "lvwExplorer"
    Me.lvwExplorer.Size = New System.Drawing.Size(280, 438)
    Me.lvwExplorer.TabIndex = 1
    Me.lvwExplorer.View = System.Windows.Forms.View.Details
    '
    'colName
    '
    Me.colName.Text = "Nazwa"
    Me.colName.Width = 109
    '
    'colModified
    '
    Me.colModified.Text = "Zmodyfikowany"
    Me.colModified.Width = 105
    '
    'splExplorer
    '
    Me.splExplorer.Location = New System.Drawing.Point(256, 0)
    Me.splExplorer.MinExtra = 50
    Me.splExplorer.MinSize = 50
    Me.splExplorer.Name = "splExplorer"
    Me.splExplorer.Size = New System.Drawing.Size(3, 438)
    Me.splExplorer.TabIndex = 2
    Me.splExplorer.TabStop = False
    '
    'TreeViewExample
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
    Me.ClientSize = New System.Drawing.Size(536, 438)
    Me.Controls.Add(Me.splExplorer)
    Me.Controls.Add(Me.lvwExplorer)
    Me.Controls.Add(Me.tvwExplorer)
    Me.Name = "TreeViewExample"
    Me.Text = "Przykad zastosowania formantu TreeView"
    Me.ResumeLayout(False)

  End Sub

#End Region

  Dim folder As DirectoryInfo

  Private Sub TreeViewExample_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
    LoadTree()
  End Sub

  Private Sub LoadTree()
    Dim directory As DirectoryInfo
    ' Czyszczenie drzewa
    tvwExplorer.Nodes.Clear()
    ' Przegldanie liter dyskw i wyszukiwanie dostpnych dyskw.
    Dim drive As String
    For Each drive In Environment.GetLogicalDrives()
      Try
        'Pobranie danych katalogu dla biecej cieki
        directory = New DirectoryInfo(drive)
        'Jeeli pobrany katalog jest prawidowy, dodajemy go do drzewa
        If (directory.Exists = True) Then
          Dim newNode As TreeNode = New TreeNode(directory.FullName)
          tvwExplorer.Nodes.Add(newNode)
          'Dodanie nowych wzw na poziomie korzenia.
          GetSubDirectories(newNode)
          'Wyszukiwanie podkatalogw dla biecego dysku.
        End If
      Catch ex As Exception
        'Ignorowanie wyjtkw.
        Return
      End Try
    Next
  End Sub

  Private Sub GetSubDirectories(ByVal parent As TreeNode)
    Dim directory As DirectoryInfo
    Try
      'Sprawdzenie, czy ten kataog by ju przeszukiwany
      If (parent.Nodes.Count = 0) Then
        directory = New DirectoryInfo(parent.FullPath)
        Dim dir As DirectoryInfo
        For Each dir In directory.GetDirectories()
          Dim newNode As TreeNode = New TreeNode(dir.Name)
          parent.Nodes.Add(newNode)
        Next
      End If
      Dim node As TreeNode
      'Przeszukanie pierwszego poziomu podkatalogw w celu utworzenia znakw +  i - 
      For Each node In parent.Nodes
        'Jeeli wze ten nie by wczeniej przeszukiwany
        If (node.Nodes.Count = 0) Then
          'Pobranie danych katalogw dla biecej cieki
          directory = New DirectoryInfo(node.FullPath)
          'Wyszukanie podkatalogw biecego katalogu
          Dim dir As DirectoryInfo
          For Each dir In directory.GetDirectories()
            'Utworzenie nowego obiektu TreeNode i dodanie go do TreeView
            Dim newNode As TreeNode = New TreeNode(dir.Name)
            node.Nodes.Add(newNode)
          Next
        End If
      Next
    Catch ex As Exception
      'Ignorowanie wyjtkw.
      Return
    End Try
  End Sub

  Private Sub tvwExplorer_BeforeSelect(ByVal sender As Object, ByVal e As System.Windows.Forms.TreeViewCancelEventArgs) Handles tvwExplorer.BeforeSelect
    'Pobranie wszystkich podkatalogw wybranego wza
    GetSubDirectories(e.Node)
    'Utworzenie obiektu DirectoryInfo i przypisanie go do zmiennej moduu
    folder = New DirectoryInfo(e.Node.FullPath)
  End Sub

  Private Sub tvwExplorer_BeforeExpand(ByVal sender As Object, ByVal e As System.Windows.Forms.TreeViewCancelEventArgs) Handles tvwExplorer.BeforeExpand
    'Pobranie wszystkich podkatalogw wybranego wza
    GetSubDirectories(e.Node)
    'Utworzenie obiektu DirectoryInfo i przypisanie go do zmiennej moduu
    folder = New DirectoryInfo(e.Node.FullPath)
  End Sub

  Private Sub tvwExplorer_AfterSelect(ByVal sender As Object, ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles tvwExplorer.AfterSelect
    'Pobranie referencji do wybranego wza
    Dim dirInfo As DirectoryInfo = New DirectoryInfo(e.Node.FullPath)
    'Skasowanie wszystkich elementw z pola listy
    lvwExplorer.Items.Clear()
    'Sprawdzenie, czy katalog istnieje
    If (dirInfo.Exists) Then
      'Pobranie referencji do wszystkich plikw
      Dim fileInfos As FileInfo() = dirInfo.GetFiles()
      'Dodanie wszystkich plikw do ListView
      Dim info As FileInfo
      For Each info In fileInfos
        Dim item As ListViewItem = New ListViewItem
        item = lvwExplorer.Items.Add(info.Name)
        item.SubItems.Add(info.LastAccessTime.ToString())
      Next
    End If
  End Sub
End Class
