Imports System
Imports System.Drawing
Imports System.Drawing.Printing

Public Class PrintPreviewControlExample
  Inherits System.Windows.Forms.Form

  Private WithEvents PrintPreviewControl1 As New PrintPreviewControl
  Private WithEvents printDoc As New PrintDocument
  Private WithEvents btnPrint As New System.Windows.Forms.Button

  Public Sub New()
    InitializeComponent()
  End Sub

  Private Sub InitializeComponent()
    ' Ustawienie pooenia, nazwy i stylu dokowania dla PrintPreviewControl1.
    Me.PrintPreviewControl1.Location = New Point(88, 80)
    Me.PrintPreviewControl1.Name = "PrintPreviewControl1"
    Me.PrintPreviewControl1.Dock = DockStyle.Fill

    ' Ustawienie waciwoci Document na PrintDocument 
    Me.PrintPreviewControl1.Document = printDoc
    ' Ustawienie powiekszenia na 50%.
    Me.PrintPreviewControl1.Zoom = 0.5
    ' Ustawienie nazwy dokumentu. Bdzie ona uzywana podczas adowania dokumentu do formantu
    Me.PrintPreviewControl1.Document.DocumentName = "c:\Temp\NazwaDokumentu.txt"
    ' Ustawienie waciwoci UseAntiAlias na true, dziki czemu czcionki sa wygadzane
    Me.PrintPreviewControl1.UseAntiAlias = True
    ' Dodanie formantu do formularza.
    Me.Controls.Add(Me.PrintPreviewControl1)
    AddHandler printDoc.PrintPage, AddressOf Me.OnPrintPage
  End Sub

  Private Sub OnPrintPage(ByVal sender As Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs)
    ' Poniszy kod tworzy zawarto prostego dokumentu
    Dim text As String = "Przykad zastosowania PrintPreviewControl"
    Dim printFont As New Font("Arial", 35, System.Drawing.FontStyle.Regular)
    e.Graphics.DrawString(text, printFont, System.Drawing.Brushes.Black, 10, 10)
  End Sub

  Public Shared Sub Main()
    Application.Run(New PrintPreviewControlExample)
  End Sub
End Class
