Imports System
Imports System.Drawing
Imports System.Drawing.Printing

Public Class PrintDialogExample
  Inherits System.Windows.Forms.Form

  Private WithEvents btnPrint As New System.Windows.Forms.Button

  Public Sub New()
    InitializeComponent()
  End Sub

  Private Sub InitializeComponent()
    Me.btnPrint.Location = New System.Drawing.Point(86, 180)
    Me.btnPrint.Name = "btnPrint"
    Me.btnPrint.Size = New System.Drawing.Size(96, 32)
    Me.btnPrint.Text = "Drukuj"
    Me.Controls.Add(Me.btnPrint)
    Me.Name = "PrintDialogExample"
    Me.Text = "Przykad uycia PrintDialog"
  End Sub

  Private Sub btnPrint_Click(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles btnPrint.Click
    ' Utworzenie obiektu PrintDocument.
    Dim printDoc As New PrintDocument
    ' Doczenie procedury drukowania do zdarzenia PrintPage.
    AddHandler printDoc.PrintPage, AddressOf Me.OnPrintPage
    Dim prDlg As New PrintDialog
    prDlg.Document = printDoc
    ' Jeeli uytkownik zamknie okno za pomoc OK, rozpoczcie drukowania
    If prDlg.ShowDialog = DialogResult.OK Then
      ' Rozpoczcie drukowania
      printDoc.Print()
    End If
  End Sub

  Private Sub DrawPage(ByVal g As Graphics)
    'Definiowanie prostokta.
    Dim r As New Rectangle(25, 25, 200, 150)
    'Rysowanie czarnym pirem.
    g.DrawRectangle(Pens.Black, r)
    'Dodanie tekstu.
    Dim f As New Font("Times", 24)
    g.DrawString("Drukowanie", f, Brushes.Red, 45, 80)
  End Sub

  Private Sub OnPrintPage(ByVal sender As Object, ByVal e As PrintPageEventArgs)
    DrawPage(e.Graphics)
  End Sub

  Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
    DrawPage(e.Graphics)
  End Sub

  Public Shared Sub Main()
    Application.Run(New PrintDialogExample)
  End Sub
End Class
