Imports System
Imports System.Drawing
Imports System.Windows.Forms

Public Class ListBoxExample
    Inherits System.Windows.Forms.Form
    Private btnAdd As New Button

    Public Sub New()
        MyBase.New()
        Me.InitializeComponent()
    End Sub

    Private Sub InitializeComponent()
        Me.btnAdd.Location = New Point(10, 10)
        Me.btnAdd.Size = New Size(50, 20)
        Me.btnAdd.TabIndex = 1
        Me.btnAdd.Text = "Dodaj"
        AddHandler Me.btnAdd.Click, AddressOf Me.btnAdd_Click
        Me.AutoScaleBaseSize = New Size(5, 13)
        Me.ClientSize = New Size(292, 273)
        Me.Controls.AddRange(New Control() {Me.btnAdd})
        Me.Text = "Przykad zastosowania klasy ListBox"
    End Sub

    Private Sub btnAdd_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        'Tworzenie obiektu ListBox.
        Dim lstItems As New ListBox
        'Ustawianie rozmiaru i pooenia listy
        lstItems.Size = New Size(200, 100)
        lstItems.Location = New Point(30, 60)
        'Dodanie obiektu ListBox do formularza
        Me.Controls.Add(lstItems)

        lstItems.MultiColumn = True

        lstItems.SelectionMode = SelectionMode.MultiExtended
        'Zatrzymanie rysowania obiektu ListBox w czasie dodawania elementw.

        lstItems.BeginUpdate()

        'Dodanie 50 elementw do listy
        Dim x As Integer
        For x = 1 To 50
            lstItems.Items.Add("Element " & x.ToString())
        Next x
        'Umoliwienie narysowania obiektu ListBox i wywietlenia nowej zawartoci

        lstItems.EndUpdate()

        'Wybranie trzech elementw z listy
        lstItems.SetSelected(1, True)
        lstItems.SetSelected(3, True)
        lstItems.SetSelected(5, True)
        'Wywietlenie pierwszego wybranego elementu    
        MessageBox.Show(lstItems.SelectedItems(0).ToString())
    End Sub

    Shared Sub Main()
        Application.Run(New ListBoxExample)
    End Sub
End Class
