Imports System.Data.SqlClient
Imports System.EnterpriseServices
Imports System.Runtime.InteropServices

'Transaction(Isolation:=TransactionIsolationLevel.RepeatableRead)> _
'Transaction(TransactionOption.RequiresNew)> _
<EventTrackingEnabled(), _
 ConstructionEnabled(Default:="workstation id=""HG-TABLET"";" & _
      "packet size=4096;integrated security=SSPI;data source=" & _
      """HG-TABLET"";persist security info=True;" & _
      "initial catalog=MySimpleBank"), _
 ObjectPooling(MinPoolSize:=1, MaxPoolSize:=4), _
 Transaction()> _
Public Class AccountManager
   Inherits ServicedComponent
   Implements IAccountManager

   Public Sub New()
   End Sub

   Private m_ConnectionString As String

   Protected Overrides Sub Construct(ByVal s As String)
      m_ConnectionString = s
      InitializeComponent()
   End Sub

   Protected Overrides Sub Activate()
      m_MySimpleBankConnection.Open()
   End Sub

   Protected Overrides Sub Deactivate()
      m_MySimpleBankConnection.Close()
   End Sub

   Protected Overrides Function CanBePooled() As Boolean
      Return m_MySimpleBankConnection.State = ConnectionState.Closed
   End Function

   <AutoComplete()> _
   Private Sub TransferMoney(ByVal fromAccount As Integer, _
         ByVal toAccount As Integer, ByVal ammount As Decimal) _
      Implements IAccountManager.TransferMoney

      Dim fromBalance As Decimal
      Dim toBalance As Decimal

      toBalance = GetBalance(toAccount)
      If toBalance = 0 Then
            Throw New ArgumentException( _
               "Prawdopodobnie nie jest to rachunek (jednak ten test jest zbyt prosty)")
      End If
      toBalance += ammount
      StoreBalance(toAccount, toBalance)

      fromBalance = GetBalance(fromAccount)
      If toBalance = 0 Then
            Throw New ArgumentException( _
               "Prawdopodobnie nie jest to rachunek (jednak ten test jest zbyt prosty)")
      End If
      fromBalance -= ammount
      If fromBalance < 0 Then
            Throw New ArgumentException("Brak rodkw na rachunku")
      End If
      StoreBalance(fromAccount, fromBalance)
   End Sub

   Private m_cmdRetrieveBalance As SqlCommand
   Private m_cmdStoreBalance As SqlCommand
   Private m_MySimpleBankConnection As SqlConnection

   Private Sub InitializeComponent()
        'Inicjalizacja poczenia.
      m_MySimpleBankConnection = New SqlConnection
      m_MySimpleBankConnection.ConnectionString = m_ConnectionString

        'Pobranie stanu rachunku.
      m_cmdRetrieveBalance = New SqlCommand( _
         "SELECT Balance FROM Accounts WHERE AccountNumber = @AccountNumber", _
         m_MySimpleBankConnection)
      m_cmdRetrieveBalance.Parameters.Add( _
         New SqlParameter("@AccountNumber", SqlDbType.Int, 4))

        'Zapisanie nowego stanu rachunku.
      m_cmdStoreBalance = New SqlCommand("UPDATE Accounts " & _
         "SET Balance = @Balance WHERE AccountNumber = @AccountNumber", _
         m_MySimpleBankConnection)
      m_cmdStoreBalance.Parameters.Add( _
         New SqlParameter("@AccountNumber", SqlDbType.Int, 4))
      m_cmdStoreBalance.Parameters.Add( _
         New SqlParameter("@Balance", SqlDbType.Money, 8))
   End Sub

   Public Function GetBalance(ByVal account As Integer) As Decimal
      Dim balance As Decimal

      m_cmdRetrieveBalance.Parameters(0).Value = account
      balance = CType(m_cmdRetrieveBalance.ExecuteScalar(), Decimal)

      Return balance
   End Function

   Public Function StoreBalance(ByVal account As Integer, _
         ByVal balance As Decimal)

      m_cmdStoreBalance.Parameters(0).Value = account
      m_cmdStoreBalance.Parameters(1).Value = balance
      m_cmdStoreBalance.ExecuteNonQuery()
   End Function

End Class
